/*
 * autoreconf -isvf && ./configure && make
 */

#include <gtk/gtk.h>
#include <string.h>

static void
open_file (const gchar *filepath)
{
  GError *er = NULL;
  gchar *data;
  g_file_get_contents (filepath, &data, NULL, &er);
  if (er)
    {
      GtkWidget *edial = gtk_message_dialog_new (NULL,
						 GTK_DIALOG_MODAL,
						 GTK_MESSAGE_ERROR,
						 GTK_BUTTONS_OK,
						 "failed to open %s: %s", filepath, er->message,
						 NULL);
      gtk_dialog_run (GTK_DIALOG(edial));
      gtk_widget_destroy (edial);
      g_clear_error (&er);
      return ;
    }

  g_free (data);
}

static gboolean
save_file (const gchar *filepath)
{
  GError *er = NULL;
  g_file_set_contents (filepath, "test", strlen ("test"), &er);
  if (er)
    {
      GtkWidget *edial = gtk_message_dialog_new (NULL,
						 GTK_DIALOG_MODAL,
						 GTK_MESSAGE_ERROR,
						 GTK_BUTTONS_OK,
						 "failed to create %s: %s", filepath, er->message,
						 NULL);
      gtk_dialog_run (GTK_DIALOG(edial));
      gtk_widget_destroy (edial);
      g_clear_error (&er);
    }
}

static void
select_folder (const gchar *folderpath)
{
  if (!g_file_test (folderpath, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS))
    {
      GtkWidget *edial = gtk_message_dialog_new (NULL,
						 GTK_DIALOG_MODAL,
						 GTK_MESSAGE_ERROR,
						 GTK_BUTTONS_OK,
						 "%s coudn't be selected !", folderpath,
						 NULL);
      gtk_dialog_run (GTK_DIALOG(edial));
      gtk_widget_destroy (edial);
    }
}

static void
create_folder (const gchar *folderpath)
{
  if (!g_file_test (folderpath, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS))
    {
      GtkWidget *edial = gtk_message_dialog_new (NULL,
						 GTK_DIALOG_MODAL,
						 GTK_MESSAGE_ERROR,
						 GTK_BUTTONS_OK,
						 "%s coudn't be created !", folderpath,
						 NULL);
      gtk_dialog_run (GTK_DIALOG(edial));
      gtk_widget_destroy (edial);
    }
}

gint
main (gint argc, gchar *argv[])
{
  gchar *dir = NULL;
  gchar *action = NULL;

  GOptionContext *context = NULL;
  GOptionEntry options[] =
  {
    {"action", 'a', 0, G_OPTION_ARG_STRING, &action,
     "action between open|save|create-folder|select-folder", NULL },
    {"dir", 't', 0, G_OPTION_ARG_STRING, &dir,
     "path of the directory to open", NULL },
    { NULL }
  };

  GError *er = NULL;
  GOptionContext *ctx = g_option_context_new ("test for 601451");
  g_option_context_add_main_entries (ctx, options, NULL);
  g_option_context_parse (ctx, &argc, &argv, &er);

  gtk_init (&argc, &argv);

  if (!dir)
    {
      dir = g_strdup (".");
    }

  GtkFileChooserAction action_id = GTK_FILE_CHOOSER_ACTION_OPEN;
  
  if (action)
    {
      if (!strcmp (action, "open"))
	action_id = GTK_FILE_CHOOSER_ACTION_OPEN;
      else if (!strcmp (action, "save"))
	action_id = GTK_FILE_CHOOSER_ACTION_SAVE;
      else if (!strcmp (action, "select-folder"))
	action_id = GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER;
      else if (!strcmp (action, "create-folder"))
	action_id = GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER;
    }

  GtkWidget *dial;
  gchar *title = g_strdup_printf ("601451 ACTION %s\n", action);
  dial = gtk_file_chooser_dialog_new (title,
				      NULL,
				      action_id,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);

  if(gtk_dialog_run (GTK_DIALOG(dial)) == GTK_RESPONSE_ACCEPT)
    {
      gchar    *filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dial));
      switch (action_id)
	{
	case GTK_FILE_CHOOSER_ACTION_OPEN:
	  open_file (filename);
	  break;
	case GTK_FILE_CHOOSER_ACTION_SAVE:
	  save_file (filename);
	  break;
	case GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER:
	  select_folder (filename);
	  break;
	case GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER:
	  create_folder (filename);
	  break;
	default:
	  g_assert_not_reached ();
	  break;
	}
      g_free (filename);
    }

  gtk_widget_destroy (dial);

  g_free (dir);

  g_option_context_free(ctx);

  return 0;
}
