/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.util.LinkedList;
import org.GNOME.Accessibility.Application;
import org.GNOME.Accessibility.Desktop;
import org.GNOME.Accessibility.DeviceEventController;
import org.GNOME.Accessibility.Event;
import org.GNOME.Accessibility.EventListener;
import org.GNOME.Accessibility.Registry;
import org.GNOME.Accessibility._RegistryStub;
import org.GNOME.Bonobo.Unknown;
import org.omg.CORBA.portable.ObjectImpl;

public class EventQueueRegistry
extends _RegistryStub {
    Registry registry;
    EventProcessor eventProcessor;
    Thread eventProcessorThread;

    public EventQueueRegistry(Registry registry) {
        if (registry == null) {
            System.err.println("Unable to contact registry");
            this.registry = null;
            this.eventProcessor = null;
            this.eventProcessorThread = null;
            return;
        }
        this.registry = registry;
        this.registry.ref();
        this._set_delegate(((ObjectImpl)registry)._get_delegate());
        this.eventProcessor = new EventProcessor();
        this.eventProcessorThread = new Thread(this.eventProcessor);
        this.eventProcessorThread.start();
    }

    public void registerApplication(Application application) {
        if (this.registry != null) {
            this.registry.registerApplication(application);
        }
    }

    public void deregisterApplication(Application application) {
        if (this.registry != null) {
            this.registry.deregisterApplication(application);
        }
    }

    public void registerGlobalEventListener(EventListener eventListener, String string) {
        if (this.registry != null) {
            this.registry.registerGlobalEventListener(eventListener, string);
        }
    }

    public void deregisterGlobalEventListenerAll(EventListener eventListener) {
        if (this.registry != null) {
            this.registry.deregisterGlobalEventListenerAll(eventListener);
        }
    }

    public void deregisterGlobalEventListener(EventListener eventListener, String string) {
        if (this.registry != null) {
            this.registry.deregisterGlobalEventListener(eventListener, string);
        }
    }

    public short getDesktopCount() {
        if (this.registry != null) {
            return this.registry.getDesktopCount();
        }
        return 0;
    }

    public Desktop getDesktop(short s) {
        if (this.registry != null) {
            return this.getDesktop(s);
        }
        return null;
    }

    public Desktop[] getDesktopList() {
        if (this.registry != null) {
            return this.registry.getDesktopList();
        }
        return null;
    }

    public DeviceEventController getDeviceEventController() {
        if (this.registry != null) {
            return this.registry.getDeviceEventController();
        }
        return null;
    }

    public void unImplemented() {
        if (this.registry != null) {
            this.registry.unImplemented();
        }
    }

    public void unImplemented2() {
        if (this.registry != null) {
            this.registry.unImplemented2();
        }
    }

    public void notifyEvent(Event event) {
        if (this.eventProcessor != null) {
            this.eventProcessor.postEvent(event);
        }
    }

    public void ref() {
        if (this.registry != null) {
            this.registry.ref();
        }
    }

    public void unref() {
        if (this.registry != null) {
            this.registry.unref();
        }
    }

    public Unknown queryInterface(String string) {
        if (this.registry != null) {
            return this.registry.queryInterface(string);
        }
        return null;
    }

    class EventProcessor
    implements Runnable {
        LinkedList eventList = new LinkedList();

        EventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (this.numEvents() == 0) {
                    try {
                        EventProcessor eventProcessor = this;
                        synchronized (eventProcessor) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                this.processEvent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int numEvents() {
            int n;
            LinkedList linkedList = this.eventList;
            synchronized (linkedList) {
                n = this.eventList.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postEvent(Event event) {
            LinkedList linkedList = this.eventList;
            synchronized (linkedList) {
                this.eventList.addLast(event);
            }
            EventProcessor eventProcessor = this;
            synchronized (eventProcessor) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processEvent() {
            try {
                Event event;
                LinkedList linkedList = this.eventList;
                synchronized (linkedList) {
                    event = (Event)this.eventList.removeFirst();
                }
                if (EventQueueRegistry.this.registry != null) {
                    EventQueueRegistry.this.registry.notifyEvent(event);
                }
            }
            catch (Exception exception) {
                System.err.println("processEvent : Exception Caught : " + exception.toString());
            }
        }
    }
}

