/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import org.GNOME.Accessibility.Accessible;
import org.GNOME.Accessibility.AccessibleOperations;
import org.GNOME.Accessibility.AccessiblePOATie;
import org.GNOME.Accessibility.ActionImpl;
import org.GNOME.Accessibility.ComponentImpl;
import org.GNOME.Accessibility.EditableTextImpl;
import org.GNOME.Accessibility.HypertextImpl;
import org.GNOME.Accessibility.ImageImpl;
import org.GNOME.Accessibility.JavaBridge;
import org.GNOME.Accessibility.Relation;
import org.GNOME.Accessibility.RelationHelper;
import org.GNOME.Accessibility.RelationImpl;
import org.GNOME.Accessibility.Role;
import org.GNOME.Accessibility.SelectionImpl;
import org.GNOME.Accessibility.StateSet;
import org.GNOME.Accessibility.StateSetHelper;
import org.GNOME.Accessibility.StateSetImpl;
import org.GNOME.Accessibility.TableImpl;
import org.GNOME.Accessibility.TextImpl;
import org.GNOME.Accessibility.ValueImpl;
import org.GNOME.Bonobo.UnknownImpl;

public class AccessibleImpl
extends UnknownImpl
implements AccessibleOperations {
    protected AccessibleContext ac;

    public AccessibleImpl(AccessibleContext accessibleContext) {
        this();
        this.ac = accessibleContext;
        this.ac.addPropertyChangeListener(JavaBridge.getGlobalPropertyChangeListener());
        this.poa = JavaBridge.getRootPOA();
        this.tie = new AccessiblePOATie(this, JavaBridge.getRootPOA());
        this.aggregate_interfaces();
        try {
            JavaBridge.getRootPOA().activate_object(this.tie);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public AccessibleImpl() {
    }

    private void aggregate_interfaces() {
        if (this.ac != null) {
            UnknownImpl unknownImpl;
            if (this.ac.getAccessibleAction() != null) {
                unknownImpl = new ActionImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if (this.ac.getAccessibleComponent() != null) {
                unknownImpl = new ComponentImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if (this.ac.getAccessibleEditableText() != null) {
                unknownImpl = new EditableTextImpl(this.ac);
                this.add_interface(unknownImpl);
            } else if (this.ac.getAccessibleText() != null) {
                unknownImpl = new TextImpl(this.ac);
                this.add_interface(unknownImpl);
                if (this.ac.getAccessibleText() instanceof AccessibleHypertext) {
                    unknownImpl = new HypertextImpl(this.ac);
                    this.add_interface(unknownImpl);
                }
            }
            if (this.ac.getAccessibleIcon() != null) {
                unknownImpl = new ImageImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if (this.ac.getAccessibleSelection() != null) {
                unknownImpl = new SelectionImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if (this.ac.getAccessibleTable() != null) {
                unknownImpl = new TableImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if (this.ac.getAccessibleValue() != null) {
                unknownImpl = new ValueImpl(this.ac);
                this.add_interface(unknownImpl);
            }
        }
    }

    public void name(String string) {
        if (this.ac != null) {
            this.ac.setAccessibleName(string);
        }
    }

    public String name() {
        String string = null;
        if (this.ac != null) {
            string = this.ac.getAccessibleName();
        }
        return string != null ? string : "";
    }

    public Accessible parent() {
        javax.accessibility.Accessible accessible;
        Accessible accessible2 = null;
        if (this.ac != null && (accessible = this.ac.getAccessibleParent()) != null) {
            accessible2 = JavaBridge.getAccessibleObjectFactory().getAccessible(accessible.getAccessibleContext());
        }
        return accessible2;
    }

    public void description(String string) {
        if (this.ac != null) {
            this.ac.setAccessibleDescription(string);
        }
    }

    public String description() {
        String string = null;
        if (this.ac != null) {
            string = this.ac.getAccessibleDescription();
        }
        return string != null ? string : "";
    }

    public int childCount() {
        int n = 0;
        if (this.ac != null) {
            n = this.ac.getAccessibleChildrenCount();
        }
        return n;
    }

    public boolean isEqual(Accessible accessible) {
        if (this.ac == null || accessible == null) {
            return false;
        }
        return accessible._is_equivalent(this.tie());
    }

    public Accessible getChildAtIndex(int n) {
        javax.accessibility.Accessible accessible;
        Accessible accessible2 = null;
        if (this.ac != null && this.ac.getAccessibleChildrenCount() > n && (accessible = this.ac.getAccessibleChild(n)) != null) {
            accessible2 = JavaBridge.getAccessibleObjectFactory().getAccessible(accessible.getAccessibleContext());
        }
        return accessible2;
    }

    public int getIndexInParent() {
        int n = -1;
        if (this.ac != null) {
            n = this.ac.getAccessibleIndexInParent();
        }
        return n;
    }

    public Relation[] getRelationSet() {
        AccessibleRelationSet accessibleRelationSet;
        Relation[] relationArray = new Relation[]{null};
        if (this.ac != null && (accessibleRelationSet = this.ac.getAccessibleRelationSet()) != null) {
            AccessibleRelation[] accessibleRelationArray = accessibleRelationSet.toArray();
            relationArray = new Relation[accessibleRelationArray.length];
            int n = 0;
            while (n < accessibleRelationArray.length) {
                RelationImpl relationImpl = new RelationImpl(accessibleRelationArray[n]);
                Relation relation = null;
                try {
                    relation = RelationHelper.narrow(relationImpl.tie());
                }
                catch (Exception exception) {
                    System.out.println("Error getting relation:" + exception);
                }
                relationArray[n] = relation;
                ++n;
            }
        }
        return relationArray;
    }

    public Role getRole() {
        Role role = Role.ROLE_INVALID;
        if (this.ac != null) {
            AccessibleRole accessibleRole = this.ac.getAccessibleRole();
            role = accessibleRole == AccessibleRole.ALERT ? Role.ROLE_ALERT : (accessibleRole == AccessibleRole.AWT_COMPONENT ? Role.ROLE_UNKNOWN : (accessibleRole == AccessibleRole.CANVAS ? Role.ROLE_CANVAS : (accessibleRole == AccessibleRole.CHECK_BOX ? Role.ROLE_CHECK_BOX : (accessibleRole == AccessibleRole.COLOR_CHOOSER ? Role.ROLE_COLOR_CHOOSER : (accessibleRole == AccessibleRole.COLUMN_HEADER ? Role.ROLE_COLUMN_HEADER : (accessibleRole == AccessibleRole.COMBO_BOX ? Role.ROLE_COMBO_BOX : (accessibleRole == AccessibleRole.DATE_EDITOR ? Role.ROLE_DATE_EDITOR : (accessibleRole == AccessibleRole.DESKTOP_ICON ? Role.ROLE_DESKTOP_ICON : (accessibleRole == AccessibleRole.DESKTOP_PANE ? Role.ROLE_LAYERED_PANE : (accessibleRole == AccessibleRole.DIALOG ? Role.ROLE_DIALOG : (accessibleRole == AccessibleRole.DIRECTORY_PANE ? Role.ROLE_DIRECTORY_PANE : (accessibleRole == AccessibleRole.FILE_CHOOSER ? Role.ROLE_FILE_CHOOSER : (accessibleRole == AccessibleRole.FILLER ? Role.ROLE_FILLER : (accessibleRole == AccessibleRole.FONT_CHOOSER ? Role.ROLE_FONT_CHOOSER : (accessibleRole == AccessibleRole.FRAME ? Role.ROLE_FRAME : (accessibleRole == AccessibleRole.GLASS_PANE ? Role.ROLE_GLASS_PANE : (accessibleRole == AccessibleRole.GROUP_BOX ? Role.ROLE_PANEL : (accessibleRole == AccessibleRole.HYPERLINK ? Role.ROLE_UNKNOWN : (accessibleRole == AccessibleRole.ICON ? Role.ROLE_ICON : (accessibleRole == AccessibleRole.INTERNAL_FRAME ? Role.ROLE_INTERNAL_FRAME : (accessibleRole == AccessibleRole.LABEL ? Role.ROLE_LABEL : (accessibleRole == AccessibleRole.LAYERED_PANE ? Role.ROLE_LAYERED_PANE : (accessibleRole == AccessibleRole.LIST ? Role.ROLE_LIST : (accessibleRole == AccessibleRole.LIST_ITEM ? Role.ROLE_LIST_ITEM : (accessibleRole == AccessibleRole.MENU ? Role.ROLE_MENU : (accessibleRole == AccessibleRole.MENU_BAR ? Role.ROLE_MENU_BAR : (accessibleRole == AccessibleRole.MENU_ITEM ? Role.ROLE_MENU_ITEM : (accessibleRole == AccessibleRole.OPTION_PANE ? Role.ROLE_OPTION_PANE : (accessibleRole == AccessibleRole.PAGE_TAB ? Role.ROLE_PAGE_TAB : (accessibleRole == AccessibleRole.PAGE_TAB_LIST ? Role.ROLE_PAGE_TAB_LIST : (accessibleRole == AccessibleRole.PANEL ? Role.ROLE_PANEL : (accessibleRole == AccessibleRole.PASSWORD_TEXT ? Role.ROLE_PASSWORD_TEXT : (accessibleRole == AccessibleRole.POPUP_MENU ? Role.ROLE_POPUP_MENU : (accessibleRole == AccessibleRole.PROGRESS_BAR ? Role.ROLE_PROGRESS_BAR : (accessibleRole == AccessibleRole.PUSH_BUTTON ? Role.ROLE_PUSH_BUTTON : (accessibleRole == AccessibleRole.RADIO_BUTTON ? Role.ROLE_RADIO_BUTTON : (accessibleRole == AccessibleRole.ROOT_PANE ? Role.ROLE_ROOT_PANE : (accessibleRole == AccessibleRole.ROW_HEADER ? Role.ROLE_ROW_HEADER : (accessibleRole == AccessibleRole.SCROLL_BAR ? Role.ROLE_SCROLL_BAR : (accessibleRole == AccessibleRole.SCROLL_PANE ? Role.ROLE_SCROLL_PANE : (accessibleRole == AccessibleRole.SEPARATOR ? Role.ROLE_SEPARATOR : (accessibleRole == AccessibleRole.SLIDER ? Role.ROLE_SLIDER : (accessibleRole == AccessibleRole.SPIN_BOX ? Role.ROLE_SPIN_BUTTON : (accessibleRole == AccessibleRole.SPLIT_PANE ? Role.ROLE_SPLIT_PANE : (accessibleRole == AccessibleRole.STATUS_BAR ? Role.ROLE_STATUS_BAR : (accessibleRole == AccessibleRole.SWING_COMPONENT ? Role.ROLE_UNKNOWN : (accessibleRole == AccessibleRole.TABLE ? Role.ROLE_TABLE : (accessibleRole == AccessibleRole.TEXT ? Role.ROLE_TEXT : (accessibleRole == AccessibleRole.TOGGLE_BUTTON ? Role.ROLE_TOGGLE_BUTTON : (accessibleRole == AccessibleRole.TOOL_BAR ? Role.ROLE_TOOL_BAR : (accessibleRole == AccessibleRole.TOOL_TIP ? Role.ROLE_TOOL_TIP : (accessibleRole == AccessibleRole.TREE ? Role.ROLE_TREE : (accessibleRole == AccessibleRole.UNKNOWN ? Role.ROLE_UNKNOWN : (accessibleRole == AccessibleRole.VIEWPORT ? Role.ROLE_VIEWPORT : (accessibleRole == AccessibleRole.WINDOW ? Role.ROLE_WINDOW : Role.ROLE_EXTENDED)))))))))))))))))))))))))))))))))))))))))))))))))))))));
        }
        return role;
    }

    public String getRoleName() {
        AccessibleRole accessibleRole;
        if (this.ac != null && (accessibleRole = this.ac.getAccessibleRole()) != null) {
            return accessibleRole.toString();
        }
        return "";
    }

    public StateSet getState() {
        StateSet stateSet = null;
        if (this.ac != null) {
            AccessibleStateSet accessibleStateSet = this.ac.getAccessibleStateSet();
            StateSetImpl stateSetImpl = new StateSetImpl(accessibleStateSet);
            stateSet = StateSetHelper.narrow(stateSetImpl.tie());
        }
        return stateSet;
    }

    public void unImplemented() {
    }

    public void unImplemented2() {
    }

    public void unImplemented3() {
    }

    public void unImplemented4() {
    }
}

