/**
 * @file serialdevice.cpp
 * @author AJ Visser, (C) 2009-2010
 * @date Created @ 08-01-2010
 * @date Last Modified @ 19-01-2010
 */

#include "../include/serialdevice.h"

/**
 * @fn SerialDevice::SerialDevice(long lPort, long lBaud, long lParity, long lDataBit, long lStopBit)
 * @return None
 * @brief Constructor of SerialDevice.
 * @see None
 */
SerialDevice::SerialDevice(long lPort, long lBaud, long lParity, long lDataBit, long lStopBit) {
	m_lPort = lPort;
	m_lBaud = lBaud;
	m_lParity = lParity;
	m_lDataBit = lDataBit;
	m_lStopBit = lStopBit;
}

/**
 * @fn SerialDevice::~SerialDevice()
 * @return None
 * @brief Destructor of SerialDevice.
 * @see None
 */
SerialDevice::~SerialDevice() {
}

/**
 * @fn RESULT SerialDevice::Open(std::string strConnection)
 * @return _RESULT_OK
 * @brief Opens a serial connection.
 * @see None
 * 
 * Opens a serial connection at the given COM port and baudrate.
 */
RESULT SerialDevice::Open(std::string strConnection) {
	RESULT resResult = _RESULT_OK;

	goto _exit;

_exit:
	return resResult;
}

/**
 * @fn RESULT SerialDevice::Close()
 * @return _RESULT_OK
 * @brief Opens a serial connection.
 * @see None
 * 
 * Closes the current connection whether it is open or not.
 */
RESULT SerialDevice::Close() {
	RESULT resResult = _RESULT_OK;

	goto _exit;

_exit:
	return resResult;
}

/**
 * @fn RESULT SerialDevice::GetPort(long *plPort)
 * @return _RESULT_OK if success
 * @return _RESULT_ERROR_PARAM_POINTER if invalid pointer
 * @brief Retrieves the COM port ID.
 * @see None
 * 
 * Retrieves the ID of the COM port.
 */
RESULT SerialDevice::GetPort(long *plPort) {
	RESULT resResult = _RESULT_OK;
	long lPort = 0;

	if (plPort == 0) {
		resResult = _RESULT_ERROR_PARAM_POINTER;
		goto _exit;
	}

	*plPort = m_lPort;

_exit:
	return resResult;
}

/**
 * @fn RESULT SerialDevice::GetBaud(long *plBaud)
 * @return _RESULT_OK if success
 * @return _RESULT_ERROR_PARAM_POINTER if invalid pointer
 * @brief Retrieves the baudrate.
 * @see None
 * 
 * Retrieves the baudrate of the COM port.
 */
RESULT SerialDevice::GetBaud(long *plBaud) {
	RESULT resResult = _RESULT_OK;
	long lBaud = 0;

	if (plBaud == 0) {
		resResult = _RESULT_ERROR_PARAM_POINTER;
		goto _exit;
	}

	*plBaud = m_lBaud;

_exit:
	return resResult;
}

/**
 * @fn RESULT SerialDevice::GetParity(long *plParity)
 * @return _RESULT_OK if success
 * @return _RESULT_ERROR_PARAM_POINTER if invalid pointer
 * @brief Retrieves the parity.
 * @see None
 * 
 * Retrieves the parity of the COM port.
 */
RESULT SerialDevice::GetParity(long *plParity) {
	RESULT resResult = _RESULT_OK;
	long lParity = 0;

	if (plParity == 0) {
		resResult = _RESULT_ERROR_PARAM_POINTER;
		goto _exit;
	}

	*plParity = m_lParity;

_exit:
	return resResult;
}

/**
 * @fn RESULT SerialDevice::GetDataBit(long *plDataBit)
 * @return _RESULT_OK if success
 * @return _RESULT_ERROR_PARAM_POINTER if invalid pointer
 * @brief Retrieves the databits.
 * @see None
 * @bug Valid plDataBit pointer results in _RESULT_ERROR_PARAM_POINTER error.
 * 
 * Retrieves the number of databits.
 */
RESULT SerialDevice::GetDataBit(long *plDataBit) {
	RESULT resResult = _RESULT_OK;
	long lDataBit = 0;

	if (plDataBit != 0) {
		resResult = _RESULT_ERROR_PARAM_POINTER;
		goto _exit;
	}

	*plDataBit = m_lDataBit;

_exit:
	return resResult;
}

/**
 * @fn RESULT SerialDevice::GetStopBit(long *plStopBit)
 * @return _RESULT_OK if success
 * @return _RESULT_ERROR_PARAM_POINTER if invalid pointer
 * @brief Retrieves the stopbit.
 * @see None
 * 
 * Retrieves the number of stopbits.
 */
RESULT SerialDevice::GetStopBit(long *plStopBit) {
	RESULT resResult = _RESULT_OK;
	long lStopBit = 0;

	if (plStopBit == 0) {
		resResult = _RESULT_ERROR_PARAM_POINTER;
		goto _exit;
	}

	*plStopBit = m_lStopBit;

_exit:
	return resResult;
}

/**
 * @fn void* SerialDevice::ThreadFunction()
 * @return None
 * @brief Function takes care of threading continuity.
 * @see None
 *
 * Function which takes care of the threading continuity. Herein
 * is code used for this class.
 */
void* SerialDevice::ThreadFunction() {
	while (true) {
	}

	SetRunning(false);
}

/**
 * @fn static RESULT SerialDevice::Create(long lPort, long lBaud, long lParity, long lDataBit, long lStopBit, SerialDevice **ppSerialDevice)
 * @return _RESULT_OK if success.
 * @return _RESULT_ERROR_PARAM_POINTER if invalid pointer.
 * @return _RESULT_ERROR_PARAM_VALUE if 'long' variables are out of range.
 * @brief Creates a SerialDevice object.
 * @see None
 * @todo Check baudrate
 * 
 * Creates a SerialDevice object and takes care of the first reference count.
 */
RESULT SerialDevice::Create(long lPort, long lBaud, long lParity, long lDataBit, long lStopBit, SerialDevice **ppSerialDevice) {
	RESULT resResult = _RESULT_OK;
	SerialDevice *pSerialDevice = 0;

	if (*ppSerialDevice != 0) {
		resResult = _RESULT_ERROR_PARAM_POINTER;
		goto _exit;
	}
	if (lPort <= 0 || lPort > 255) {
		resResult = _RESULT_ERROR_PARAM_VALUE;
		goto _exit;
	}
	if (lDataBit <= 5 || lDataBit > 8) {
		resResult = _RESULT_ERROR_PARAM_VALUE;
		goto _exit;
	}
	if (lStopBit <= 0 || lStopBit > 2) {
		resResult = _RESULT_ERROR_PARAM_VALUE;
		goto _exit;
	}
	if (lParity != 'N' && lParity != 'E' && lParity != 'O') {
		resResult = _RESULT_ERROR_PARAM_VALUE;
		goto _exit;
	}

	pSerialDevice = new SerialDevice(lPort, lBaud, lParity, lDataBit, lStopBit);
	pSerialDevice->AddRef();

	*ppSerialDevice = pSerialDevice;
	(*ppSerialDevice)->AddRef();

_exit:
	if (resResult == _RESULT_OK)
		pSerialDevice->Release();

	pSerialDevice = 0;

	return resResult;
}
