/**
 * @file device.cpp
 * @author AJ Visser, (C) 2009-2010
 * @date Created @ 08-01-2010
 * @date Last Modified @ 18-01-2010
 */

#include "../include/device.h"

/**
 * @fn Device::Device()
 * @return None
 * @brief Constructor of Device.
 * @see None
 */
Device::Device() {
	m_sStatus = _STATUS_NONE;
}

/**
 * @fn Device::~Device()
 * @return None
 * @brief Destructor of Device.
 * @see None
 */
Device::~Device() {
}

/**
 * @fn RESULT Device::SetStatus(STATUS sStatus)
 * @return _RESULT_OK
 * @brief Sets the status of the current object.
 * @see None
 * 
 * Sets the status of the current object.
 * (*NOTE: It does not check the inbound status.)
 */
RESULT Device::SetStatus(STATUS sStatus) {
	m_sStatus = sStatus;

	return _RESULT_OK;
}

/**
 * @fn RESULT Device::GetStatus(STATUS *psStatus)
 * @return _RESULT_OK if success.
 * @return _RESULT_ERROR_PARAM_POINTER if invalid pointer.
 * @brief Returns the status of the current object.
 * @see None
 * 
 * Return the status of the current object. Return an error
 * if the psStatus pointer is invalid.
 */
RESULT Device::GetStatus(STATUS *psStatus) {
	RESULT resResult = _RESULT_OK;

	if (psStatus == 0) {
		resResult = _RESULT_ERROR_PARAM_POINTER;
		goto _exit;
	}

	(*psStatus) = m_sStatus;

_exit:
	return resResult;
}