/**
 * @file serialdevice.h
 * @author AJ Visser, (C) 2009-2010
 * @date Created @ 08-01-2010
 * @date Last Modified @ 18-01-2010
 */

#ifndef _H_SERIAL_DEVICE_H_
#define _H_SERIAL_DEVICE_H_

#include "../include/defines/return.h"
#include "../include/device.h"

/**
 * @class SerialDevice
 * @brief Device for writing and reading serial ports.
 */

class SerialDevice : public Device {
	private:
		long m_lPort;		/**< COM port ID. */
		long m_lBaud;		/**< Baudrate of COM port. */
		long m_lParity;		/**< Parity settings of COM port ('N' = None, 'E' = Even, 'O' = Odd). */
		long m_lDataBit;	/**< Number of databits (5 to 8). */
		long m_lStopBit;	/**< Number of stopbits (1 or 2). */

	protected:
		SerialDevice(long lPort, long lBaud, long lParity, long lDataBit, long lStopBit);
		void *ThreadFunction();

	public:
		virtual ~SerialDevice();
		RESULT Open(std::string strConnection);
		RESULT Close();

		RESULT GetPort(long *plPort);
		RESULT GetBaud(long *plBaud);
		RESULT GetParity(long *plParity);
		RESULT GetDataBit(long *plDataBit);
		RESULT GetStopBit(long *plStopBit);

		static RESULT Create(long lPort, long lBaud, long lParity, long lDataBit, long lStopBit, SerialDevice **ppSerialDevice);
};

#endif
