/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JLayeredPane;
import org.GNOME.Accessibility.Accessible;
import org.GNOME.Accessibility.BoundingBox;
import org.GNOME.Accessibility.ComponentLayer;
import org.GNOME.Accessibility.ComponentOperations;
import org.GNOME.Accessibility.ComponentPOATie;
import org.GNOME.Accessibility.EventListener;
import org.GNOME.Accessibility.JavaBridge;
import org.GNOME.Bonobo.UnknownImpl;
import org.omg.CORBA.IntHolder;

public class ComponentImpl
extends UnknownImpl
implements ComponentOperations {
    AccessibleComponent accComponent;
    AccessibleContext ac;
    Component component;
    JLayeredPane layeredPane;

    public ComponentImpl(AccessibleContext accessibleContext) {
        this.accComponent = accessibleContext.getAccessibleComponent();
        this.ac = accessibleContext;
        this.component = null;
        this.layeredPane = null;
        this.poa = JavaBridge.getRootPOA();
        this.tie = new ComponentPOATie(this, JavaBridge.getRootPOA());
        try {
            JavaBridge.getRootPOA().activate_object(this.tie);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public boolean contains(int n, int n2, short s) {
        Point point = new Point(n, n2);
        if (this.accComponent != null) {
            return this.accComponent.contains(point);
        }
        return false;
    }

    public Accessible getAccessibleAtPoint(int n, int n2, short s) {
        javax.accessibility.Accessible accessible;
        Accessible accessible2 = null;
        if (this.accComponent != null && (accessible = this.accComponent.getAccessibleAt(new Point(n, n2))) != null) {
            accessible2 = JavaBridge.getAccessibleObjectFactory().getAccessible(accessible.getAccessibleContext());
        }
        return accessible2;
    }

    public BoundingBox getExtents(short s) {
        BoundingBox boundingBox = null;
        if (this.accComponent != null) {
            Dimension dimension = null;
            try {
                dimension = this.accComponent.getSize();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Point point = this.accComponent.getLocationOnScreen();
            if (dimension == null) {
                dimension = new Dimension(0, 0);
            }
            if (point == null) {
                point = new Point(-1, -1);
            }
            if (s == 0) {
                boundingBox = new BoundingBox(point.x, point.y, (int)dimension.getWidth(), (int)dimension.getHeight());
            } else {
                Point point2 = this.getToplevelLocationOnScreen();
                boundingBox = new BoundingBox(point.x - point2.x, point.y - point2.y, (int)dimension.getWidth(), (int)dimension.getHeight());
            }
        }
        if (boundingBox == null) {
            System.out.println("Null bounds!");
        }
        return boundingBox;
    }

    private Point getToplevelLocationOnScreen() {
        Point point = new Point(0, 0);
        javax.accessibility.Accessible accessible = this.ac.getAccessibleParent();
        AccessibleContext accessibleContext = this.ac;
        AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
        while (accessible != null && accessibleComponent != null) {
            Point point2 = accessibleComponent.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            accessible = accessibleContext.getAccessibleParent();
            accessibleContext = accessible.getAccessibleContext();
            accessibleComponent = accessibleContext.getAccessibleComponent();
        }
        return point;
    }

    public void getPosition(IntHolder intHolder, IntHolder intHolder2, short s) {
        if (this.accComponent != null) {
            Point point = this.accComponent.getLocationOnScreen();
            if (s != 0) {
                Point point2 = this.getToplevelLocationOnScreen();
                point.x -= point2.x;
                point.y -= point2.y;
            }
            intHolder = new IntHolder(point.x);
            intHolder2 = new IntHolder(point.y);
        }
    }

    public void getSize(IntHolder intHolder, IntHolder intHolder2) {
        if (this.accComponent != null) {
            Dimension dimension = null;
            try {
                dimension = this.accComponent.getSize();
            }
            catch (Exception exception) {
                dimension = new Dimension(0, 0);
            }
            intHolder = new IntHolder(dimension.width);
            intHolder2 = new IntHolder(dimension.height);
        }
    }

    public boolean grabFocus() {
        if (this.accComponent != null) {
            this.accComponent.requestFocus();
            return true;
        }
        return false;
    }

    public void registerFocusHandler(EventListener eventListener) {
    }

    public void deregisterFocusHandler(EventListener eventListener) {
    }

    public ComponentLayer getLayer() {
        if (this.ac == null) {
            return ComponentLayer.LAYER_INVALID;
        }
        AccessibleRole accessibleRole = this.ac.getAccessibleRole();
        if (accessibleRole == AccessibleRole.MENU || accessibleRole == AccessibleRole.MENU_ITEM || accessibleRole == AccessibleRole.POPUP_MENU || accessibleRole == AccessibleRole.MENU) {
            return ComponentLayer.LAYER_POPUP;
        }
        if (accessibleRole == AccessibleRole.INTERNAL_FRAME) {
            return ComponentLayer.LAYER_MDI;
        }
        if (accessibleRole == AccessibleRole.GLASS_PANE) {
            return ComponentLayer.LAYER_OVERLAY;
        }
        if (accessibleRole == AccessibleRole.CANVAS || accessibleRole == AccessibleRole.ROOT_PANE || accessibleRole == AccessibleRole.LAYERED_PANE) {
            return ComponentLayer.LAYER_CANVAS;
        }
        return ComponentLayer.LAYER_WIDGET;
    }

    public short getMDIZOrder() {
        if (this.getLayer() != ComponentLayer.LAYER_MDI) {
            return 0;
        }
        if (this.layeredPane != null && this.component != null) {
            return (short)this.layeredPane.getPosition(this.component);
        }
        return 0;
    }

    public void unImplemented() {
    }

    public void unImplemented2() {
    }

    public void unImplemented3() {
    }

    public void unImplemented4() {
    }
}

