#ifndef GSTTHREAD_H
#define GSTTHREAD_H

#include <QtCore/QThread>
#include "glcontextid.h"

class Pipeline;

class GstThread : public QThread
{
  Q_OBJECT

public:
  GstThread(const GLContextID &ctxId, 
            const QString &videoLocation, 
            const char *renderer_slot, 
            QObject *parent = 0);

  ~GstThread();

  Pipeline *getPipeline() {return this->m_pipeline;}

public Q_SLOTS:
  void stop();
    
protected:
  void run();

private:
  const GLContextID contextId;
  const QString m_videoLocation;
  Pipeline* m_pipeline;
};

#endif
