<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                version="1.0"
                xmlns:c='http://exslt.org/common'
                extension-element-prefixes="c">

  <xsl:output indent="yes" method="xml"/>
  
  <xsl:variable name='list' select='//Id'/>
  <xsl:variable name='list-ns' select='c:node-set($list)'/>


  <xsl:variable name='sorted-uniqued-list0'>
    <xsl:for-each select='$list-ns/..//Id[not(.=preceding::Id)]'>
      <xsl:sort select='.'/>
      <xsl:copy-of select='.'/>
    </xsl:for-each>
  </xsl:variable>

  <xsl:variable name='sorted-uniqued-list1'>
    <xsl:for-each select='$list-ns/..//Id[not(.=following::Id)]'>
      <xsl:sort select='.'/>
      <xsl:copy-of select='.'/>
    </xsl:for-each>
  </xsl:variable>

  <xsl:template match='/'>
    <foo>
      <comment>
        <xsl:text>count($list-ns) = </xsl:text>
        <xsl:value-of select='count($list-ns)'/>
      </comment>
      <list0>
        <xsl:copy-of select='$sorted-uniqued-list0'/>
      </list0>
      <list1>
        <xsl:copy-of select='$sorted-uniqued-list1'/>
      </list1>
    </foo>
  </xsl:template>
</xsl:stylesheet>
