class OClass : Object {
    public uint f1;
    public double f2;

    public static OClass instantiate (uint f1, double f2) {
        OClass obj = new OClass ();
        obj.f1 = f1;
        obj.f2 = f2;

        return obj;
    }
}


//class MiniClass : Gst.MiniObject {
//    public uint f1;
//    public double f2;
//
//    MiniClass (uint f1, double f2) {
//        this.f1 = f1;
//        this.f2 = f2;
//    }
//}

class Test.Perf {
    static const uint NUM_INSTANCES = 10000000;

    // Create some instances to get rid of any first-time creation time
    OClass aoclass = OClass.instantiate (0, 0.0);

    Timer timer = new Timer();

//    public void test_mini_class () {
//        MiniClass[] classes = new MiniClass[NUM_INSTANCES];

        // Reset timer
//        this.timer.start ();
//        for (int i = 0; i < NUM_INSTANCES; i++) {
//            classes[i] = new MiniClass (0, 0.0);
//        }

//        print ("%f seconds taken in creating %u instances (GstMiniObject).\n",
//               timer.elapsed (),
//               NUM_INSTANCES);
//    }


    public void test_oclass () {
        OClass[] classes = new OClass[NUM_INSTANCES];

        // Reset timer
        this.timer.start ();
        for (int i = 0; i < NUM_INSTANCES; i++) {
            classes[i] = OClass.instantiate (0, 0.0);
        }

        print ("%f seconds taken in creating %u instances (GObject).\n",
               timer.elapsed (),
               NUM_INSTANCES);
    }

    public static int main (string[] args) {
        Test.Perf perf = new Test.Perf ();
	uint i;
	for (i = 0; i< 5; i++)
	{
		if (i < 2) {
			print ("Don't count these:\n");
		} else {
			print ("Useful results:\n");
		}

//	        perf.test_mini_class ();
	        perf.test_oclass ();
	}

        return 0;
    }
}

