//*****************************************************************************
//*****                            UNCLASSIFIED                           *****
//*****************************************************************************
/**
* @file 
* Implementation of the Class SetCaptureThreadChannel.
*/

#include "Rc/Exec/Executive.h"
#include "SetCaptureThreadChannel.h"
#include "Rc/Tgp/HelperThreads/CaptureThread/CaptureThread.h"
#include <iostream>

using namespace Rc;
using namespace std;

using Rc::Tgp::HelperThreads::SetCaptureThreadChannel;

using Rc::Tgp::HelperThreads::CaptureThreadChannel;
using Rc::Exec::HelperThread;

SetCaptureThreadChannel::SetCaptureThreadChannel(const CaptureThreadChannel channel, 
                                                 HelperThread* helperThread)
: HelperThreadRequest(HelperThreadRequest::Type::e_setCaptureThreadChannel, helperThread),
m_channel (channel)
{
   setHelperThreadName ("CaptureThread");
}

SetCaptureThreadChannel::SetCaptureThreadChannel(const SetCaptureThreadChannel& request)
: HelperThreadRequest(request),
m_channel (request.m_channel)
{
}

SetCaptureThreadChannel::~SetCaptureThreadChannel(){
}

void SetCaptureThreadChannel::serialize()
{
   HelperThreadRequest::serialize();
   Int32 channel = m_channel.getValue();
   m_buffer.pushBack (channel);
}

void SetCaptureThreadChannel::deserialize()
{
   HelperThreadRequest::deserialize();
   Int32 channel;
   m_buffer.pop (&channel);
   m_channel.setValue(static_cast<CaptureThreadChannel::Enum>(channel));
}

std::ostream& Rc::Tgp::HelperThreads::operator<< (std::ostream& out, Rc::Tgp::HelperThreads::SetCaptureThreadChannel& rhs)
{
   out << static_cast<HelperThreadRequest&>(rhs) << "SetCaptureThreadChannel: " << rhs.m_channel.getDisplayName() << endl;
   return out;
}

void SetCaptureThreadChannel::execute()
{
   if (m_helperThread)
   {
      CaptureThread* t = dynamic_cast<CaptureThread*>(m_helperThread);
      t->log ("Executing SetCaptureThreadChannel : " + m_channel.getDisplayName());
      t->setChannel (m_channel);    
   }
}
