/**
 * Dcrit un raccourcis
 **/
struct Raccourcis
{
	bool maj;		//< Indique si la touche majuscule doit tre enfonce aussi
	bool ctrl;		//< Indique si la touche Ctrl doit tre enfonce
	bool alt;		//< Touche Alt enfonce ?
	DWORD touche;	//< Code de la touche  enfoncer

	bool operator == (const Raccourcis &r);
	Raccourcis &operator =(const Raccourcis &r);
};

/**
 * Structure dcrivant un raccourci
 **/
struct ShortcutItem
{
	WORD		action;			//< Identifiant de l'action
	LPTSTR		nom;			//< Nom de l'action
	Raccourcis	defaut;			//< Raccourcis par dfaut
	Raccourcis	raccourcis;		//< Raccourcis principal
	Raccourcis	alternatif;		//< Raccourcis alternatif

	ShortcutItem &operator =(const ShortcutItem &s);
};

/**
 * Sample structure. In this sample, all columns should be vertically aligned (using a tab width of 4),
 * but because of the bug, they are not as soon as there are accented characters on their left.
 **/
ShortcutItem shortcuts[24] = {
	// Identifiant			nom textuel										 maj	ctrl	alt		touche
	{IDM_CHAN_AUG,			TEXT("Chane suivante"),						{false,	false,	false,	VK_DOWN}},
	{IDM_CHAN_DIM,			TEXT("Chane prcdente"),						{false,	false,	false,	VK_UP}},
	{IDM_EPG,				TEXT("Guide des programmes"),					{false,	false,	false,	TEXT('G')}},
	{IDM_SHOW_PROGRAMME,	TEXT("Programme actuel"),						{false,	false,	false,	TEXT('I')}},
	{IDM_FULLSCREEN,		TEXT("Plein cran"),							{false,	false,	false,	VK_SPACE}},
	{IDM_DELAYED_RECORD,	TEXT("Programmer les enregistrements"),			{false,	false,	false,	TEXT('P')}},
	{IDM_RECORD_CHANNEL_PS,	TEXT("Enregistrer la chane en PS"),			{false,	true,	false,	VK_SPACE}},
	{IDM_RECORD_CHANNEL_TS,	TEXT("Enregistrer la chane en TS"),			{false,	true,	false,	TEXT('T')}},
	{IDM_SCREENSHOT,		TEXT("Capture d'cran"),						{false,	true,	false,	TEXT('X')}},
	{IDM_STOP_RECORD,		TEXT("Stopper l'enregistrement"),				{false,	true,	false,	VK_RETURN}},
	{IDM_DELAYED_STOP,		TEXT("Arrt diffr des enregistrements"),		{false,	false,	false,	TEXT('S')}},
	{IDM_MUTE,				TEXT("Couper le son"),							{false,	false,	false,	TEXT('M')}},
	{IDM_VOL_AUG,			TEXT("Augmenter le volume"),					{false,	false,	false,	VK_ADD}},
	{IDM_VOL_DIM,			TEXT("Diminuer le volume"),						{false,	false,	false,	VK_SUBTRACT}},
	{IDM_ALWAYS_ON_TOP,		TEXT("Rester toujours devant"),					{false,	false,	true,	TEXT('T')}},
	{IDM_FIRST_AUDIO,		TEXT("Utiliser la premire piste audio"),		{false,	true,	false,	TEXT('1')}},
	{IDM_SECOND_AUDIO,		TEXT("Utiliser la seconde piste audio"),		{false,	true,	false,	TEXT('2')}},
	{IDM_AC3_AUDIO,			TEXT("Utiliser la piste audio AC3"),			{false,	true,	false,	TEXT('3')}},
	{IDM_ZOOM,				TEXT("Zoomer"),									{true,	false,	false,	TEXT('Z')}},
	{IDM_DEZOOM,			TEXT("Dzoomer"),								{false,	false,	false,	TEXT('Z')}},
	{IDM_ALLWDT,			TEXT("Utiliser toute la largeur"),				{false,	false,	false,	TEXT('W')}},
	{IDM_ETIRER,			TEXT("tirer la vido"),						{false,	false,	false,	TEXT('E')}},
	{IDM_DEFAULT_ZOOM,		TEXT("Restaure le zoom/tirement"),				{false,	false,	false,	TEXT('D')}},

	{IDM_ABOUT,				TEXT(""),										{false,	true,	false,	VK_F1}},
};
