#!/usr/bin/python

import dbus
import dbus.glib
import gobject

import sys

bus = dbus.SessionBus()
slo = bus.get_object('org.gnome.Rhythmbox', '/org/gnome/Rhythmbox/SourceList')
sl = dbus.Interface(slo, 'org.gnome.Rhythmbox.SourceList')

columns = {}

def get_iter(bus, path):
	obj = bus.get_object('org.gnome.Rhythmbox', path)
	return dbus.Interface(obj, 'org.gnome.Rhythmbox.TreeIter')

def get_columns(iter):
	(names, types) = iter.GetColumns()
	for index in range(len(names)):
		columns[names[index]] = index

def recurse(level, sli):
	(playing, name, group) = sli.Get((columns["Playing"], columns["Name"], columns["Is group"]))
	has_child = sli.HasChild()
	if group:
		str = ">"
	elif playing:
		str = "*"
	else:
		str = " "

	if has_child and not group:
		str += "+"
	else:
		str += " "
	str += name

	print (" " * level) + str
	if has_child:
		csli = get_iter(bus, sli.Children())

		while True:
			recurse(level+1, csli)
			if csli.Next() == False:
				break

if len(sys.argv) > 1:
	gip = sl.GetIterGroup(sys.argv[1])
	gi = get_iter(bus, gip)
	get_columns(gi)
	recurse(0, gi)
else:
	sli = get_iter(bus, sl.GetIterFirst())
	get_columns(sli)

	while True:
		recurse(0, sli)
		if sli.Next() == False:
			break
	sli.Unref()


