#!/usr/bin/python

import dbus
import dbus.glib
import gobject

bus = dbus.SessionBus()
# temporary way of getting at the library query model.
# not sure how this will really work.
lo = bus.get_object('org.gnome.Rhythmbox', '/org/gnome/Rhythmbox/Library')
l = dbus.Interface(lo, 'org.gnome.Rhythmbox.QueryModel')

lio = l.GetIter(0)
lii = bus.get_object('org.gnome.Rhythmbox', lio)
li = dbus.Interface(lii, 'org.gnome.Rhythmbox.TreeIter')

# print column information.
(names, types) = li.GetColumns()
for (n, t) in zip(names, types):
	print n + ": " + t.__class__.__name__

# map property names to column numbers
properties = {}
for index in range(len(names)):
	properties[names[index]] = index
	
# find column numbers for things we're going to print
c_title = properties["title"]
c_artist = properties["artist"]
c_album = properties["album"]
c_duration = properties["duration"]
c_playcount = properties["play-count"]

c = 0
while c < 300:
	# request just about everything
	(rows, more) = li.GetBatch(100, range(40))
	for entry in rows:
		try:
			# print a few things.
			print "<%s> by <%s> from <%s>; <%d:%.2d>; played <%d> times" % \
				(entry[c_title], entry[c_artist], entry[c_album],\
				 entry[c_duration]/60, entry[c_duration]%60, entry[c_playcount])
		except UnicodeEncodeError, e:
			# ignore
			pass
		c = c + 1

	if more == False:
		break
		
li.Unref()
