#!/usr/bin/python

import dbus
import dbus.glib
import gobject

bus = dbus.SessionBus()
lo = bus.get_object('org.gnome.Rhythmbox', '/org/gnome/Rhythmbox/Library')
l = dbus.Interface(lo, 'org.gnome.Rhythmbox.QueryModel')

def entry_added(uri):
	print "Entry %s added to library" % (uri)

def entry_removed(uri):
	print "Entry %s removed from library" % (uri)

def entry_prop_changed(uri, prop, oldval, newval):
	print "Property %s of entry %s in library changed from %s to %s" % (prop, uri, str(oldval), str(newval))

def entries_reordered():
	print "Library entries reordered"

l.Ref(True)		# enable signals
l.connect_to_signal("EntryAdded", entry_added)
l.connect_to_signal("EntryRemoved", entry_removed)
l.connect_to_signal("EntryPropChanged", entry_prop_changed)
l.connect_to_signal("EntriesReordered", entries_reordered)

loop = gobject.MainLoop()
loop.run()

