/* GIMP Plug-in DeNoise
 * Copyright (C) 2007 Roland Simmen
 * All Rights Reserved.
 * 
 * This plugin is derived from the template provided by Michael Natterer
 * 
 * GIMP Plug-in Template
 * Copyright (C) 2000  Michael Natterer <mitch@gimp.org> (the "Author").
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the Author of the
 * Software shall not be used in advertising or otherwise to promote the
 * sale, use or other dealings in this Software without prior written
 * authorization from the Author.
 */

#ifndef __RENDER_H__
#define __RENDER_H__

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#define   RENDER_8BIT
#undef    RENDER_16BIT

#define   RADIUS_MAX    15
#define   NOISE_MAX     255

/* type definitions */
typedef struct _RenderParams
{
  gint            radius;           // blurring radius
  gint            sigmaNoiseDark;   // sigma of noise level for dark
  gint            sigmaNoiseLight;  // sigma of noise level for light
  gboolean        withPreview;      // check box for preview
  gboolean        lockRatio;        // check box for locking ratio
  gboolean        checkNoise;       // check box for check noise
} RenderParams;
  
typedef struct _PlugInVals
{
  gint32          image_ID;     // image id 
  GimpDrawable   *drawable;     // handle to drawable
  GimpPreview    *preview;      // handle to preview
  RenderParams    vals;         // parameter values for rendering
} PlugInVals;


/*  Public functions  */

extern 
void   denoise_render (PlugInVals  *data);
/***
 * Render the picture
 * 
 * in : data = handle to plugin values
 */

#endif /* __RENDER_H__ */
