# -*- coding: utf-8 -*-

# __init__.py -- plugin object
#
# Copyright (C) 2007 - Diego Escalante Urrelo
# Copyright (C) 2006 - Steve Frécinaux
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# Parts from "Interactive Python-GTK Console" (stolen from gedit's python console.pe which was actually stolen from epiphany's console.py)
#     Copyright (C), 1998 James Henstridge <james@daa.com.au>
#     Copyright (C), 2005 Adam Hooper <adamh@densi.com>
#     Copyrignt (C), 2005 Raphaël Slinckx

import gtk
import eog
from console import PythonConsole


class PythonConsolePlugin(eog.Plugin):
	_ui_str = """
	<ui>
	  <menubar name="MainMenu">
	    <menu name="ToolsMenu" action="Tools">
	      <separator/>
	      <menuitem name="PythonConsole" action="PythonConsole"/>
	      <separator/>
	    </menu>
	  </menubar>
	</ui>
	"""
	def __init__(self):
		eog.Plugin.__init__(self)
			
	def activate(self, window):
		console = PythonConsole(namespace = {'__builtins__' : __builtins__,
		                                     'eog' : eog,
		                                     'window' : window})
		console.eval('print "You can access the main window through ' \
		             '\'window\' :\\n%s" % window', False)
		
		console_window = gtk.Window()
		console_window.set_title('Python Console')
		console_window.add(console)
		console_window.connect('delete-event', self.on_delete_cb)

		window.PythonConsolePluginInfo = console
		ui_manager = window.get_ui_manager()
		group = gtk.ActionGroup('PythonConsole')
		group.add_actions([('PythonConsole', None, 'P_ython Console', None, None, self.console_cb)], window)
		ui_manager.insert_action_group(group, 0)
		ui_id = ui_manager.add_ui_from_string(self._ui_str)
	
	def deactivate(self, window):
		console = window.get_data("PythonConsolePluginInfo")
		window.PythonConsolePluginInfo = None

		ui_manager = window.get_ui_manager()
		ui_manager.remove_ui(ui_id)
		ui_manager.remove_action_group(group)
		ui_manager.ensure_update()

	def console_cb(self, action, window):
		window.PythonConsolePluginInfo.parent.show_all()
	
	def on_delete_cb(self, window, event):
		window.destroy()
