/* Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * SISSI diagram -  adapted by Luc Cessieux
 * This class could draw the system security
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <assert.h>
#include <math.h>
#include <string.h>
#include <glib.h>

#include "intl.h"
#include "object.h"
#include "element.h"
#include "connectionpoint.h"
#include "diarenderer.h"
#include "attributes.h"
#include "text.h"
#include "widgets.h"
#include "message.h"
#include "connpoint_line.h"
#include "color.h"

#include "room.h"

#define DEFAULT_WIDTH  1.0
#define DEFAULT_HEIGHT 1.0
#define TEXT_FONT (DIA_FONT_SANS|DIA_FONT_BOLD)
#define TEXT_FONT_HEIGHT 0.6
#define TEXT_HEIGHT (2.0)
#define NUM_CONNECTIONS 9

static ObjectTypeOps room_type_ops =
{
  (CreateFunc) room_create,
  (LoadFunc)   room_load,
  (SaveFunc)   object_sissi_save,
  (GetDefaultsFunc)   NULL,
  (ApplyDefaultsFunc) NULL,
};

DiaObjectType room_type =
{
  "SISSI - room",           /* name */
  0,                            /* version */
  (char **) sissi_object_xpm, /* this is the default pixmap */
  &room_type_ops      /* ops */
};


static ObjectOps object_sissi_ops = {
  (DestroyFunc)         object_sissi_destroy,
  (DrawFunc)            object_sissi_draw,
  (DistanceFunc)        object_sissi_distance_from,
  (SelectFunc)          object_sissi_select,
  (CopyFunc)            object_sissi_copy_using_properties,
  (MoveFunc)            object_sissi_move,
  (MoveHandleFunc)      object_sissi_move_handle,
  (GetPropertiesFunc)   object_sissi_get_properties,
  (ApplyPropertiesFunc) object_sissi_apply_properties,
  (ObjectMenuFunc)      NULL,
  (DescribePropsFunc)   room_describe_props,
  (GetPropsFunc)        room_get_props,
  (SetPropsFunc)        room_set_props
};

static PropDescription generic_props[] = {
  ELEMENT_COMMON_PROPERTIES,
/*      { "confidentialite", PROP_TYPE_ENUM, PROP_FLAG_VISIBLE, N_("Confidentialite :"), N_("confidentialite "), property_confidentialite_data},*/
    PROP_DESC_END
};

static PropOffset generic_offsets[] = {
  ELEMENT_COMMON_PROPERTIES_OFFSETS,
  {NULL}
};

static PropDescription *room_describe_props(ObjetSISSI *room)
{
  if (generic_props[0].quark == 0) {
    prop_desc_list_calculate_quarks(generic_props);
  }
  return generic_props;
}

static void room_set_props(ObjetSISSI *object_sissi, GPtrArray *props)
{
/*   object_set_props_from_offsets(&object_sissi->element.object, generic_offsets,props);

     object_sissi_update_data(object_sissi, ANCHOR_MIDDLE, ANCHOR_MIDDLE);*/
}

static void room_get_props(ObjetSISSI *object_sissi, GPtrArray *props)
{
  object_get_props_from_offsets(&object_sissi->element.object, generic_offsets,props);
}

static DiaObject *room_create(Point *startpoint,  void *user_data, Handle **handle1, Handle **handle2)
{
  ObjetSISSI *object_sissi;
  Element *elem;
  DiaObject *obj;
  int i;
  DiaFont* action_font;
  Point pos;
  
  object_sissi = g_malloc0(sizeof(ObjetSISSI));
  elem = &object_sissi->element;
  obj = &elem->object;

  obj->type = &room_type;
  obj->ops = &object_sissi_ops;

  elem->corner = *startpoint;
  elem->width = DEFAULT_WIDTH;
  elem->height = DEFAULT_HEIGHT;

 element_init(elem, 8, NUM_CONNECTIONS);

  for (i=0;i<NUM_CONNECTIONS;i++) {
    obj->connections[i] = &object_sissi->connections[i];
    object_sissi->connections[i].object = obj;
    object_sissi->connections[i].connected = NULL;
  }
    object_sissi->connections[8].flags = CP_FLAGS_MAIN;

   object_sissi->border_color=color_gris;
   object_sissi->fill_colour=color_white;
   object_sissi->dashlength=5.0;
   object_sissi->show_background=1;

   object_sissi->entity=g_strdup("");
   object_sissi->entity_type=g_strdup("PHYSIC");
    if (object_sissi->image) {
      elem->width = (elem->width*(float)dia_image_width(object_sissi->image))/
	(float)dia_image_height(object_sissi->image);
    }

  action_font = dia_font_new_from_style(TEXT_FONT,TEXT_FONT_HEIGHT); 
  object_sissi->text = new_text("",action_font, TEXT_FONT_HEIGHT, &pos, &color_black, ALIGN_LEFT);

   object_sissi->properties_menaces=create_list_properties_menace(object_sissi->properties_menaces,object_sissi->entity_type);
   object_sissi->properties_others=create_list_properties_others(object_sissi->properties_others);
   object_sissi->type_element = g_strdup("room");
  

  object_sissi->nb_others_fixes=9;
  object_sissi_update_data(object_sissi, ANCHOR_MIDDLE, ANCHOR_MIDDLE);

  *handle1 = NULL;
  *handle2 = obj->handles[7];
  
   return &object_sissi->element.object;
}
 
DiaObject *room_load(ObjectNode obj_node, int version, const char *filename)
{
  ObjetSISSI *object_sissi;
  Element *elem;
  DiaObject *obj;
  gchar *file_name;
  DiaFont* action_font;
  Point pos;
  
  
  object_sissi = g_malloc0(sizeof(ObjetSISSI));
  elem = &object_sissi->element;
  obj = &elem->object;

  obj->type = &room_type;
  obj->ops = &object_sissi_ops;
  
  action_font = dia_font_new_from_style(TEXT_FONT,TEXT_FONT_HEIGHT); 
  object_sissi->text = new_text("",action_font, TEXT_FONT_HEIGHT, &pos, &color_black, ALIGN_LEFT);

  object_sissi=object_sissi_load(obj_node, version, filename, object_sissi,elem,obj);
    object_sissi->show_background=1; 
  file_name= g_strdup(object_sissi->file);
  object_sissi->image = dia_image_load(dia_get_data_directory(file_name));
  
    if (object_sissi->image) {
      elem->width = (elem->width*(float)dia_image_width(object_sissi->image))/
	(float)dia_image_height(object_sissi->image);
    }

  object_sissi_update_data(object_sissi, ANCHOR_MIDDLE, ANCHOR_MIDDLE);

  return &object_sissi->element.object;

}

static GList *create_list_properties_others(GList *list_property_other)
{
 list_property_other = g_list_append(list_property_other, create_new_property_other("No room","Room number", "")); 
 list_property_other = g_list_append(list_property_other, create_new_property_other("Building name","Building name where is the room", ""));
 list_property_other = g_list_append(list_property_other, create_new_property_other("Organism in charge","Organism in charge off room", ""));
 list_property_other = g_list_append(list_property_other, create_new_property_other("Function","Room function", ""));
 list_property_other = g_list_append(list_property_other, create_new_property_other("Description","Room description", ""));
 list_property_other = g_list_append(list_property_other, create_new_property_other("Level","Room level", ""));
 list_property_other = g_list_append(list_property_other, create_new_property_other("Walls type","Walls are in wood, iron, brick...", ""));
 list_property_other = g_list_append(list_property_other, create_new_property_other("Longitude","Longitude position room", "")); 
 list_property_other = g_list_append(list_property_other, create_new_property_other("Latitude","Latitude position room", "")); 

 return list_property_other;
}