// gtkmm_test.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "gtkmm_test.h"


#define MAX_LOADSTRING 100

Gtk::Label* MainLabel = NULL; 

static void on_button_clicked( void ) 
{
	MainLabel->set_label( "hello world" ); 
}

static void on_new_clicked( void ) 
{
	MainLabel->set_label( "new file - yeah" ); 
}

static void on_open_clicked( void ) 
{
	MainLabel->set_label( "open file - yeah " ); 
}


int main(int argc, char *argv[])
{
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF  );
	_CrtSetBreakAlloc(134); 

    Gtk::Main kit(argc, argv);

	Glib::RefPtr<Gnome::Glade::Xml> refXml = Gnome::Glade::Xml::create("testwindow.glade");

	Gtk::Window* MainWindow = NULL; 
	refXml->get_widget( "MainWindow", MainWindow );  
	refXml->get_widget( "HelloLabel", MainLabel );  


	Gtk::Button* HelloButton = NULL; 
	refXml->get_widget( "HelloButton", HelloButton );  
	HelloButton->signal_clicked().connect( sigc::ptr_fun( &on_button_clicked ) ); 

	refXml->connect_clicked( "FileNew", sigc::ptr_fun( &on_new_clicked ) ); 
	refXml->connect_clicked( "FileOpen", sigc::ptr_fun( &on_open_clicked ) ); 
	
	MainLabel->set_label( "testing gtkmm in 2006" ); 

	Gtk::Main::run( *MainWindow ); 

    return 0;

}

