
#include "config.h"

#include <string.h>

#include <glib.h>
#include <glib/gstdio.h>

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "webx_main.h"
#include "webx_source.h"
#include "webx_dialog.h"
#include "webx_png8.h"
#include "webx_widgets.h"
#include "webx_indexed.h"

#include "libgimp/stdplugins-intl.h"

static WebxPNG8Settings     webx_png8;
static WebxIndexed          webx_indexed;

void
webx_png8_init ()
{
  GimpParam  *return_vals;
  gint        n_return_vals;

  return_vals = gimp_run_procedure ("file-png-get-defaults", &n_return_vals,
				    GIMP_PDB_END);
  webx_png8.interlace    = return_vals[1].data.d_int32;
  webx_png8.compression  = return_vals[2].data.d_int32;
  webx_png8.bkgd         = return_vals[3].data.d_int32;
  webx_png8.gama         = return_vals[4].data.d_int32;
  webx_png8.offs         = return_vals[5].data.d_int32;
  webx_png8.phys         = return_vals[6].data.d_int32;
  webx_png8.time         = return_vals[7].data.d_int32;
  webx_png8.comment      = return_vals[8].data.d_int32;
  webx_png8.svtrans      = return_vals[9].data.d_int32;
  gimp_destroy_params (return_vals, n_return_vals);

  webx_indexed_init (&webx_indexed);
}

void
webx_png8_cleanup ()
{
  webx_indexed_cleanup (&webx_indexed);
}

GtkWidget*
webx_png8_toolbox_new ()
{
  GtkWidget   *box;
  GtkObject   *adj;
  GtkWidget   *check;
  GtkWidget   *table;
  GtkWidget   *indexed;
  gint         row = 0;

  box = gtk_vbox_new (FALSE, 0);

  indexed = webx_indexed_create_widgets (&webx_indexed);
  gtk_box_pack_start (GTK_BOX (box), indexed, FALSE, FALSE, 0);
  g_object_set_data (G_OBJECT (box), "indexed", indexed);

  table = gtk_table_new (12, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (box), table, FALSE, FALSE, 0);

  check = gtk_check_button_new_with_label (_("Interlace"));
  gtk_table_attach (GTK_TABLE (table), check,
		    0, 3, row, row+1,
		    GTK_FILL, GTK_FILL, 0, 0);
  g_signal_connect (check, "toggled",
		    G_CALLBACK (webx_widgets_boolean_update),
		    &webx_png8.interlace);
  g_object_set_data (G_OBJECT (box), "interlace", check);

  row++;
  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, row++,
			    _("_Compression:"), 90, 6,
			    webx_png8.compression, 0.0, 9.0, 1.0, 1.0, 0,
			    TRUE, 0, 0,
			    NULL, NULL);
  g_signal_connect (adj, "value-changed",
		    G_CALLBACK (webx_widgets_int_update),
		    &webx_png8.compression);
  g_object_set_data (G_OBJECT (box), "compression", adj);

  return box;
}

void
webx_png8_toolbox_update (GtkWidget *toolbox)
{
  GtkObject   *adj;
  GtkWidget   *check;
  GtkWidget   *w;

  w = g_object_get_data (G_OBJECT (toolbox), "indexed");
  webx_indexed_update_widgets (w, &webx_indexed);
 
  check = g_object_get_data (G_OBJECT (toolbox), "interlace");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check),
				(gboolean) webx_png8.interlace);

  adj = GTK_OBJECT (g_object_get_data (G_OBJECT (toolbox), "compression"));
  gtk_range_set_value (GTK_RANGE (GIMP_SCALE_ENTRY_SCALE (adj)),
		       webx_png8.compression);
}

gboolean
webx_png8_save (const gchar *file_name)
{
  GimpParam    *return_vals;
  gint          n_return_vals;
  gint32        image;
  gint32        layer;
  gboolean      save_res;

  image = webx_indexed_get_image (&webx_indexed, &layer);

  return_vals = gimp_run_procedure ("file-png-save", &n_return_vals,
				    GIMP_PDB_INT32, GIMP_RUN_NONINTERACTIVE,
				    GIMP_PDB_IMAGE, image,
				    GIMP_PDB_DRAWABLE, layer,
				    GIMP_PDB_STRING, file_name,
				    GIMP_PDB_STRING, file_name,
				    GIMP_PDB_INT32, webx_png8.interlace,
				    GIMP_PDB_INT32, webx_png8.compression,
				    GIMP_PDB_INT32, webx_png8.bkgd,
				    GIMP_PDB_INT32, webx_png8.gama,
				    GIMP_PDB_INT32, webx_png8.offs,
				    GIMP_PDB_INT32, webx_png8.phys,
				    GIMP_PDB_INT32, webx_png8.time,
				    GIMP_PDB_END);
  if (return_vals[0].data.d_int32 == GIMP_PDB_SUCCESS)
    save_res = TRUE;
  else
    save_res = FALSE;
  gimp_destroy_params (return_vals, n_return_vals);

  return save_res;
}

static gint32
webx_png8_load (const gchar *file_name)
{
  GimpParam  *return_vals;
  gint        n_return_vals;
  gint32      image;

  return_vals = gimp_run_procedure ("file-png-load", &n_return_vals,
				    GIMP_PDB_INT32, GIMP_RUN_NONINTERACTIVE,
				    GIMP_PDB_STRING, file_name,
				    GIMP_PDB_STRING, file_name,
				    GIMP_PDB_END);
  image = return_vals[1].data.d_image;
  gimp_destroy_params (return_vals, n_return_vals);

  return image;
}

GdkPixbuf*
webx_png8_generate_preview ()
{
  gchar       *file_name;
  GdkPixbuf   *pixbuf = NULL;
  gint32       image;

  file_name = gimp_temp_name ("PNG");
  if (webx_png8_save (file_name))
    {
      webx_dialog_update_file_size (file_name);
      image = webx_png8_load (file_name);
      if (image != -1)
	{
	  pixbuf = webx_image_to_pixbuf (image);
	  gimp_image_delete (image);
	}
    }
  g_unlink (file_name);
  g_free (file_name);

  return pixbuf;
}

void
webx_png8_invalidate (void)
{
  webx_indexed_invalidate (NULL, &webx_indexed);
}
