
#define WEBX_VIEW_PADDING   20

enum
  {
    WEBX_FMT_JPEG,
    WEBX_FMT_PNG8,
    WEBX_FMT_PNG24,
    WEBX_FMT_GIF,
    WEBX_MAXFORMATS
  };

typedef struct _WebxView
{
  GdkPixbuf       *pixbuf;
  GtkWidget       *frame_widget;
  GtkWidget       *scroll_widget;
  GtkWidget       *view_widget;
  gint             cursor_type;
} WebxView;

typedef struct _WebxDialog
{
  GtkWidget       *dialog;
    
  gdouble          zoom;
  GtkWidget       *zoom_combo;

  GtkWidget       *file_fmt_label;
  GtkWidget       *dimensions_label;
  GtkWidget       *file_size_label;

  gint             drag_mode;
  WebxView        *drag_view;
  /* previous coordinates to calculated deltas */
  gint             drag_start_x;
  gint             drag_start_y;
  GdkRectangle     drag_crop_rect;

  /* we use this for timeout function to make sure
   * user has stopped editing. If we find the same
   * update count 2 cycles, we can check for changes. */
  gint             update_count;

  gint             format;
  GtkWidget       *format_combo;
  GtkWidget       *toolboxes[WEBX_MAXFORMATS];

  gint             stop_recursion;
    
  GtkWidget       *resize_width;
  GtkWidget       *resize_height;
  GtkWidget       *resize_chain;
  gdouble          resize_aspect;
    
  GtkWidget       *crop_offsx;
  GtkWidget       *crop_offsy;
  GtkWidget       *crop_width;
  GtkWidget       *crop_height;
  GdkRectangle     crop_rect;
    
  GtkWidget       *progress_bar;
    
  /* shared adjustments for synchronized scrolling */
  GtkAdjustment   *hadj;
  GtkAdjustment   *vadj;

  WebxView         original;
  WebxView         optimized;
} WebxDialog;

void        webx_dialog_init (void);
void        webx_dialog_cleanup (void);
gboolean    webx_dialog_run (void);

void        webx_dialog_queue_update (void);
glong       webx_dialog_update_file_size (const gchar *file_name);

