
#include "config.h"

#include <string.h>

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "webx_main.h"
#include "webx_widgets.h"

#include "libgimp/stdplugins-intl.h"

void
webx_widgets_percent_update (GtkRange  *range,
                             gdouble   *value)
{
  gdouble     newval;

  range = GIMP_SCALE_ENTRY_SCALE (range);
  newval = gtk_range_get_value (GTK_RANGE (range)) / 100.0;
  if (*value != newval)
    {
      *value = newval;
      webx_dialog_queue_update ();
    }
}

void
webx_widgets_int_update (GtkRange  *range,
                         gint      *value)
{
  gdouble     newval;

  range = GIMP_SCALE_ENTRY_SCALE (range);
  newval = (gint) gtk_range_get_value (range);
  if (*value != newval)
    {
      *value = newval;
      webx_dialog_queue_update ();
    }
}

void
webx_widgets_boolean_update (GtkToggleButton *toggle,
                             gboolean        *value)
{
  gboolean    newval;

  newval = gtk_toggle_button_get_active (toggle);
  if (*value != newval)
    {
      *value = newval;
      webx_dialog_queue_update ();
    }
}
