
typedef struct _WebxIndexed
{
  gint        image;
  gint        layer;
    
  gint        dither_type;
  gint        palette_type;
  gint        num_colors;
    
  gchar      *custom_palette;
    
  gboolean    alpha_dither;
  gboolean    remove_unused;
} WebxIndexed;

void        webx_indexed_init (WebxIndexed *settings);
void        webx_indexed_cleanup (WebxIndexed *settings);

GtkWidget*  webx_indexed_create_widgets (WebxIndexed *settings);
void        webx_indexed_update_widgets (GtkWidget      *widget,
                                         WebxIndexed    *settings);

gint32      webx_indexed_convert (WebxIndexed  *settings);

gint        webx_indexed_get_image (WebxIndexed *settings,
                                    gint *drawable);
                                    
void        webx_indexed_invalidate (void        *toggle,
                                     WebxIndexed *settings);
