//-*-c++-*-
#ifndef INCLUDED_MotionManager_h
#define INCLUDED_MotionManager_h

//! A small header that precedes data sent by MotionManager between processes
struct MotionManagerMsg {
	//! the type to use when referring to MotionCommand ID's
	typedef unsigned short MC_ID;
};

class MotionManager {
public:
	//! re-typedefing (this is a critical step to reproduce)
	typedef MotionManagerMsg::MC_ID MC_ID;

	//! note no error on this inline version; it only complains about externally defined members
	inline MC_ID next(MC_ID cur) const { return skip_ahead(cmdlist.next(cur)); }

	//! like this one
	MotionCommand * checkoutMotion(MC_ID mcid,bool block=true);
	
	//! or this one (testing scoping?)
	void convertMotion(MotionManager::MC_ID mcid);
	
	//! but **NOT** this one (testing external to class, but still in header)
	MotionCommand * peekMotion(MC_ID mcid);
	
};

//! a class containing a member of type MC_ID (also a critical step)
/*! now one interesting tidbit is that this must be in the 'includes'
 of a file to see errors in that .cc file.  In other words, if you
 move this class to MotionManager.cc, you'll lose the errors in ControllerGUI.cc,
 and only see the errors in MotionManager.cc.  Or move to ControllerGUI.cc and
 only see the error there. */
class OutputState {
public:
	MotionManager::MC_ID mcid; //!< MC_ID of requester
};

MotionCommand * MotionManager::peekMotion(MC_ID mcid) { return NULL; }


#endif
