/* Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>
#include <gtk/gtk.h>
#include <math.h>
#include <string.h>

#include "object.h"
#include "objchange.h"
#include "intl.h"
#include "sissi.h"

#include "sissi_dialog.h"

/************ function of menace list copy*******/
extern GList *menace_list_copy(GList *list_old, GList *list_new)
{
  unsigned int i;
  const gchar *s; 

  for (i=0;i<g_list_length(list_old);i++)
  {

   Propriete_Menace *new_propriete_menace;
   new_propriete_menace=g_new0(Propriete_Menace,1);
		/*Label*/
   s = ((Propriete_Menace *)(g_list_nth(list_old,i)->data))->label;
   if (s && s[0])
      new_propriete_menace->label = g_strdup (s);
   else
      new_propriete_menace->label = NULL;
		/* comments */
   s = ((Propriete_Menace *)(g_list_nth(list_old,i)->data))->comments;
   if (s && s[0])
      new_propriete_menace->comments = g_strdup (s);
   else
      new_propriete_menace->comments = NULL;

   new_propriete_menace->action = ((Propriete_Menace *)(g_list_nth(list_old,i)->data))->action;
   
   new_propriete_menace->detection = ((Propriete_Menace *)(g_list_nth(list_old,i)->data))->detection;

   new_propriete_menace->vulnerability = ((Propriete_Menace *)(g_list_nth(list_old,i)->data))->vulnerability;
   
   list_new=g_list_append(list_new,new_propriete_menace);
  }
  return list_new;
}

/************ copy function of menace list in dailog box *******/
extern void menace_list_copy_gtk(GList *list_old, GList *list_dialog)
{
/*  int i;
//  const gchar *s; 

  for (i=0;i<g_list_length(list_old);i++)
  {
   gtk_entry_set_text(((Propriete_Menace *)(g_list_nth(list_dialog,i)->data))->label, ((Propriete_Menace *)(g_list_nth(list_old,i)->data))->label);    
   gtk_entry_set_text(((Propriete_Menace *)(g_list_nth(list_dialog,i)->data))->action, ((Propriete_Menace *)(g_list_nth(list_old,i)->data))->action);    
   gtk_entry_set_text(((Propriete_Menace *)(g_list_nth(list_dialog,i)->data))->detection, ((Propriete_Menace *)(g_list_nth(list_old,i)->data))->detection);    
   gtk_entry_set_text(((Propriete_Menace *)(g_list_nth(list_dialog,i)->data))->vulnerability, ((Propriete_Menace *)(g_list_nth(list_old,i)->data))->vulnerability);    
  }*/
}

static GList *vidage_liste_propriete_widget(GList *list)
{  
  while (list != NULL) {
    Propriete_Widget *propriete = (Propriete_Widget *) list->data;
    gtk_widget_destroy((GtkWidget *)propriete->label);
    gtk_widget_destroy((GtkWidget *)propriete->value);
    gtk_widget_destroy((GtkWidget *)propriete->description);
    g_free(propriete);
    list = g_list_next(list);
  }
  g_list_free(list);
  list=NULL;
  return list;
}

static GList *vidage_liste_url_doc_widget(GList *list)
{  
  while (list != NULL) {
    Url_Docs_Widget *url_doc = (Url_Docs_Widget *) list->data;
    gtk_widget_destroy((GtkWidget *)url_doc->label);
    gtk_widget_destroy((GtkWidget *)url_doc->url);
    gtk_widget_destroy((GtkWidget *)url_doc->description);
    g_free(url_doc);
    list = g_list_next(list);
  }
  g_list_free(list);
  list=NULL;
  return list;
}

/*
static void object_sissi_free_state(SISSIState *state)
{
//    fprintf(stderr,"espion object_sissi_free_state\n");
}
*/
static void
object_sissi_set_state(ObjetSISSI *object_sissi, SISSIState *state)
{

/*/   object_sissi->proprietes_menaces = state->proprietes_menaces;
//   object_sissi->proprietes_autres = state->proprietes_autres;
*/
  g_free(state);
/*   object_sissi_calculate_data(object_sissi);*/
  object_sissi_update_data(object_sissi, ANCHOR_MIDDLE, ANCHOR_MIDDLE);
}


static void
object_sissi_change_apply(SISSIChange *change, DiaObject *obj)
{
/*    fprintf(stderr,"espion object_sissi_change_apply\n");     */
}

static void object_sissi_change_revert(SISSIChange *change, DiaObject *obj)
{
/*
    fprintf(stderr,"espion object_sissi_change_revert\n");*/
}

static void object_sissi_change_free(SISSIChange *change)
{
/*
  GList *list, *free_list;

  object_sissi_free_state(change->saved_state);
  g_free(change->saved_state);

  if (change->applied) 
    free_list = change->deleted_cp;
  else
    free_list = change->added_cp;

  list = free_list;
  while (list != NULL) {
    ConnectionPoint *connection = (ConnectionPoint *) list->data;
    
    g_assert(connection->connected == NULL); // Paranoid
    object_remove_connections_to(connection); // Shouldn't be needed
    g_free(connection);
      
    list = g_list_next(list);
  }

  g_list_free(free_list);
*/
}

static ObjectChange *new_sissi_change(ObjetSISSI *object_sissi, SISSIState *state, GList *added, GList *deleted, GList *disconnected)
{
  SISSIChange *change;

  change = g_new0(SISSIChange, 1);
  
  change->obj_change.apply =
    (ObjectChangeApplyFunc) object_sissi_change_apply;
  change->obj_change.revert =
    (ObjectChangeRevertFunc) object_sissi_change_revert;
  change->obj_change.free =
    (ObjectChangeFreeFunc) object_sissi_change_free;
/*
  change->obj = obj;
  change->saved_state = saved_state;
  change->applied = 1;

  change->added_cp = added;
  change->deleted_cp = deleted;
  change->disconnected = disconnected;
*/
  return (ObjectChange *)change;
}

/********************************************************
 ******************** menace *****************************
 ********************************************************/

static void proprietes_menaces_read_from_dialog(ObjetSISSI *object_sissi, SISSIDialog *prop_dialog)
{

  unsigned int i;
/************ copy the list of menaces *******/
  for (i=0;i<g_list_length(object_sissi->proprietes_menaces);i++)
  {

     ((Propriete_Menace *)(g_list_nth(object_sissi->proprietes_menaces,i)->data))->comments = g_strdup(gtk_entry_get_text((GtkEntry *)(((Propriete_Menace_Widget *)(g_list_nth(prop_dialog->proprietes_menaces,i)->data))->comments)));

     ((Propriete_Menace *)(g_list_nth(object_sissi->proprietes_menaces,i)->data))->action = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(((Propriete_Menace_Widget *)(g_list_nth(prop_dialog->proprietes_menaces,i)->data))->action));
     ((Propriete_Menace *)(g_list_nth(object_sissi->proprietes_menaces,i)->data))->detection = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(((Propriete_Menace_Widget *)(g_list_nth(prop_dialog->proprietes_menaces,i)->data))->detection));
     ((Propriete_Menace *)(g_list_nth(object_sissi->proprietes_menaces,i)->data))->vulnerability = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(((Propriete_Menace_Widget *)(g_list_nth(prop_dialog->proprietes_menaces,i)->data))->vulnerability));
  }
/*  fprintf(stderr,"espion proprietes_menaces_read_from_dialog fin\n");*/
}

static void proprietes_menaces_create_page(GtkNotebook *notebook,  ObjetSISSI *object_sissi)
{
  unsigned int i;
  SISSIDialog *prop_dialog;
  GtkWidget *page_label;
  GtkWidget *label;
  GtkWidget *pScroll;
  GtkWidget *vbox;
  GtkWidget *table;
  prop_dialog = object_sissi->properties_dialog;
  
  /* Class page:*/
  page_label = gtk_label_new_with_mnemonic (_("_Menace"));
  
  vbox = gtk_vbox_new(FALSE, 0);


  gtk_container_set_border_width (GTK_CONTAINER (vbox), 0);

pScroll = gtk_scrolled_window_new(NULL, NULL);
/*gtk_window_set_default_size(GTK_WINDOW(pScroll), 300, 200);*/
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(pScroll), vbox);

  
  table = gtk_table_new (43, 8, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 0);

  /********** label of board **********/
  label = gtk_label_new (_("Menace"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  label = gtk_label_new (_("P Action"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 0, 1);
  label = gtk_label_new (_("P Detection"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 0, 1);
  label = gtk_label_new (_("Vulnerabilite"));
  
  gtk_table_attach_defaults (GTK_TABLE (table), label, 3, 4, 0, 1);
  label = gtk_label_new (_("Menace"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 4, 5, 0, 1);
  label = gtk_label_new (_("P Action"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 5, 6, 0, 1);
  label = gtk_label_new (_("P Detection"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 6, 7, 0, 1);
  label = gtk_label_new (_("Vulnerabilite"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 7, 8, 0, 1);

  /************* values of board *********/
/*********   GtkObject *adj; **********/
  for (i=0;i<g_list_length(object_sissi->proprietes_menaces);i++)
  {
   Propriete_Menace_Widget *propriete_menace_widget;
   propriete_menace_widget=g_malloc0(sizeof(Propriete_Menace_Widget));

   propriete_menace_widget->label = gtk_label_new (NULL);
   gtk_label_set_text(GTK_LABEL(propriete_menace_widget->label), _(((Propriete_Menace *)(g_list_nth(object_sissi->proprietes_menaces,i)->data))->label));
   

propriete_menace_widget->comments = gtk_entry_new();

/*   adj = gtk_adjustment_new( umlclass->wrap_after_char, 0.0, 200.0, 1.0, 5.0, 1.0);
//   prop_dialog->wrap_after_char = GTK_SPIN_BUTTON(gtk_spin_button_new( GTK_ADJUSTMENT( adj), 0.1, 0));
//   gtk_spin_button_set_numeric( GTK_SPIN_BUTTON( prop_dialog->wrap_after_char), TRUE);
//   gtk_spin_button_set_snap_to_ticks( GTK_SPIN_BUTTON( prop_dialog->wrap_after_char), TRUE);*/
   
   propriete_menace_widget->action = gtk_spin_button_new_with_range(0, 3, 1); 
   propriete_menace_widget->detection = gtk_spin_button_new_with_range(0, 3, 1);
   propriete_menace_widget->vulnerability = gtk_spin_button_new_with_range(0, 3, 1);
         
   gtk_table_attach_defaults (GTK_TABLE (table), propriete_menace_widget->label, (i%2)*4, (i%2)*4+1, i*2+1-2*(i%2), i*2+2-2*(i%2));
   gtk_table_attach_defaults (GTK_TABLE (table), propriete_menace_widget->action, (i%2)*4+1, (i%2)*4+2, i*2+1-2*(i%2), i*2+2-2*(i%2));
   gtk_table_attach_defaults (GTK_TABLE (table), propriete_menace_widget->detection, (i%2)*4+2, (i%2)*4+3, i*2+1-2*(i%2), i*2+2-2*(i%2));
   gtk_table_attach_defaults (GTK_TABLE (table), propriete_menace_widget->vulnerability, (i%2)*4+3,(i%2)*4+4, i*2+1-2*(i%2), i*2+2-2*(i%2));
   gtk_table_attach_defaults (GTK_TABLE (table), propriete_menace_widget->comments, (i%2)*4, (i%2)*4+4, i*2+2-2*(i%2), i*2+3-2*(i%2));

   /* after the création of the elements, we put there in the widget list */
   prop_dialog->proprietes_menaces=g_list_append(prop_dialog->proprietes_menaces,propriete_menace_widget);
  }
  
  gtk_widget_show_all (vbox);
gtk_widget_show_all (pScroll);
  gtk_widget_show (page_label);
  gtk_notebook_append_page(notebook, pScroll, page_label);
}


static void proprietes_autres_read_from_dialog(ObjetSISSI *object_sissi, SISSIDialog *prop_dialog)
{
  GList *list;
  unsigned int i;
     /************** classification *************/
  if (GTK_IS_OPTION_MENU(object_sissi->properties_dialog->confidentialite)) {
   object_sissi->confidentialite = g_strdup((char *)(gtk_object_get_user_data(
           GTK_OBJECT(GTK_OPTION_MENU(object_sissi->properties_dialog->confidentialite)->menu_item))));
  } else {
    object_sissi->confidentialite = g_strdup((char *)strtol(gtk_entry_get_text(GTK_ENTRY(object_sissi->properties_dialog->confidentialite)), NULL, 0));
  }

  if (GTK_IS_OPTION_MENU(object_sissi->properties_dialog->integrite)) {
   object_sissi->integrite = g_strdup((char *)(gtk_object_get_user_data(
           GTK_OBJECT(GTK_OPTION_MENU(object_sissi->properties_dialog->integrite)->menu_item))));
  } else {
    object_sissi->integrite = g_strdup((char *)strtol(gtk_entry_get_text(GTK_ENTRY(object_sissi->properties_dialog->integrite)), NULL, 0));
  }
  
  if (GTK_IS_OPTION_MENU(object_sissi->properties_dialog->disponibilite_echelle)) {
   object_sissi->disponibilite_echelle = g_strdup((char *)(gtk_object_get_user_data(
           GTK_OBJECT(GTK_OPTION_MENU(object_sissi->properties_dialog->disponibilite_echelle)->menu_item))));
  } else {
    object_sissi->disponibilite_echelle = g_strdup((char *)strtol(gtk_entry_get_text(GTK_ENTRY(object_sissi->properties_dialog->disponibilite_echelle)), NULL, 0));
  }
  
  object_sissi->disponibilite_valeur = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(object_sissi->properties_dialog->disponibilite_valeur));
  
  
    /************ Entity *******************/
  if (GTK_IS_OPTION_MENU(object_sissi->properties_dialog->entite)) {
   object_sissi->entite = g_strdup((char *)(gtk_object_get_user_data(
           GTK_OBJECT(GTK_OPTION_MENU(object_sissi->properties_dialog->entite)->menu_item))));
  } else {
    object_sissi->entite = g_strdup((char *)strtol(gtk_entry_get_text(GTK_ENTRY(object_sissi->properties_dialog->entite)), NULL, 0));
  }

  
    /* to copy the properties list to propreties object */
  
  object_sissi->proprietes_autres=vidage_liste_propriete(object_sissi->proprietes_autres);
   for (i=0;i<g_list_length(prop_dialog->proprietes_autres);i++)
   {
      Propriete *proprietes_autres;
      proprietes_autres=g_malloc0(sizeof(Propriete));
      if (i < object_sissi->nb_autres_fixes)
      {
        proprietes_autres->label = g_strdup(gtk_label_get_text(GTK_LABEL(((Propriete_Widget *)(g_list_nth(prop_dialog->proprietes_autres,i)->data))->label)));
        proprietes_autres->description = g_strdup(gtk_label_get_text(GTK_LABEL(((Propriete_Widget *)(g_list_nth(prop_dialog->proprietes_autres,i)->data))->description)));
      }
      else
      {
        proprietes_autres->label = g_strdup(gtk_entry_get_text((GtkEntry *)(((Propriete_Widget *)(g_list_nth(prop_dialog->proprietes_autres,i)->data))->label)));
        proprietes_autres->description = g_strdup(gtk_entry_get_text((GtkEntry *)(((Propriete_Widget *)(g_list_nth(prop_dialog->proprietes_autres,i)->data))->description)));      
      }
      proprietes_autres->value = g_strdup(gtk_entry_get_text((GtkEntry *)(((Propriete_Widget *)(g_list_nth(prop_dialog->proprietes_autres,i)->data))->value)));
      if((strcmp(proprietes_autres->label,"")==0) && (strcmp(proprietes_autres->value,"")==0) && (strcmp(proprietes_autres->description,"")==0))
      {
	g_free(proprietes_autres->label);
	g_free(proprietes_autres->value);
	g_free(proprietes_autres->description);
	g_free(proprietes_autres);
      }
      else
      {
      	object_sissi->proprietes_autres=g_list_append(object_sissi->proprietes_autres, proprietes_autres);
      }
   }
  object_sissi->name = g_strdup(gtk_entry_get_text((GtkEntry *)prop_dialog->name));
}

static void
autres_new_callback(GtkWidget *button, ObjetSISSI *object_sissi)
{
    unsigned int i;
    Propriete_Widget *propriete_autre;
    SISSIDialog *prop_dialog;
  /* DiaObject *obj; */
  	prop_dialog = object_sissi->properties_dialog;    
	i=prop_dialog->nb_proprietes_autres;
	
	propriete_autre=g_malloc0(sizeof(Propriete_Widget));
	
	propriete_autre->label = gtk_entry_new();
	propriete_autre->value = gtk_entry_new();
	propriete_autre->description= gtk_entry_new();
	
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), (GtkWidget *)propriete_autre->label, 0, 1, i+5, i+6);
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), (GtkWidget *)propriete_autre->value, 1,2,i+5,i+6);
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), (GtkWidget *)propriete_autre->description, 2,3,i+5,i+6);
	/* after creation we put elemnts in widget list */
	prop_dialog->proprietes_autres=g_list_append(prop_dialog->proprietes_autres,propriete_autre);
	
	gtk_widget_show (prop_dialog->table_autres);
	gtk_widget_show_all (prop_dialog->vbox_autres);
  	gtk_widget_show (prop_dialog->page_label_autres);	
	prop_dialog->nb_proprietes_autres=i+1;
}


static void proprietes_autres_create_page(GtkNotebook *notebook,  ObjetSISSI *object_sissi)
{
  SISSIDialog *prop_dialog;
  GtkWidget *label,*button;
  GtkWidget *pScroll_autres;


  GtkWidget *menu_classification, *menu_integrite, *menu_disponibilite_echelle, *disponibilite_valeur;  
  GtkWidget *menu_entite;
  unsigned int j;  
  
  prop_dialog = object_sissi->properties_dialog;
  
  /* Other properties of page: */
  prop_dialog->page_label_autres = gtk_label_new_with_mnemonic (_("Autres proprietes"));

  prop_dialog->vbox_autres = gtk_vbox_new(FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (prop_dialog->vbox_autres), 0);


pScroll_autres = gtk_scrolled_window_new(NULL, NULL);
gtk_scrolled_window_set_policy(pScroll_autres,GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
/*gtk_window_set_default_size(GTK_WINDOW(pScroll_autres), 300, 200);*/

gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(pScroll_autres), prop_dialog->vbox_autres);

  prop_dialog->table_autres = gtk_table_new (43, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (prop_dialog->vbox_autres), prop_dialog->table_autres, FALSE, FALSE, 0);
  
  /**** Selection menu of classification  ****/

  object_sissi->properties_dialog->confidentialite = gtk_option_menu_new();
  menu_classification = gtk_menu_new();
  object_sissi->properties_dialog->integrite= gtk_option_menu_new();
  menu_integrite = gtk_menu_new();
  object_sissi->properties_dialog->disponibilite_echelle = gtk_option_menu_new();
  menu_disponibilite_echelle = gtk_menu_new();
  
  for (j = 0; propriete_classification_data[j].label != NULL; j++) {
      GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_classification_data[j].label));
      gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_classification_data[j].value));
      gtk_container_add(GTK_CONTAINER(menu_classification), item);
      gtk_widget_show(item);
  }
  gtk_option_menu_set_menu(GTK_OPTION_MENU(object_sissi->properties_dialog->confidentialite), menu_classification);
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), object_sissi->properties_dialog->confidentialite, 0, 2, 0, 1);
 /************* end of menu **********/
  for (j = 0; propriete_integrite_data[j].label != NULL; j++) {
      GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_integrite_data[j].label));
      gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_integrite_data[j].value));
      gtk_container_add(GTK_CONTAINER(menu_integrite), item);
      gtk_widget_show(item);
  }
  gtk_option_menu_set_menu(GTK_OPTION_MENU(object_sissi->properties_dialog->integrite), menu_integrite);
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), object_sissi->properties_dialog->integrite, 2, 4, 0, 1);

  object_sissi->properties_dialog->disponibilite_valeur = gtk_spin_button_new_with_range(0, 100, 1);
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), object_sissi->properties_dialog->disponibilite_valeur, 0, 1, 1, 2);

  for (j = 0; propriete_disponibilite_echelle_data[j].label != NULL; j++) {
      GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_disponibilite_echelle_data[j].label));
      gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_disponibilite_echelle_data[j].value));
      gtk_container_add(GTK_CONTAINER(menu_disponibilite_echelle), item);
      gtk_widget_show(item);
  }
  gtk_option_menu_set_menu(GTK_OPTION_MENU(object_sissi->properties_dialog->disponibilite_echelle), menu_disponibilite_echelle);
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), object_sissi->properties_dialog->disponibilite_echelle, 1, 2, 1, 2);
 /*********** Selection of entite menu ***************/
  object_sissi->properties_dialog->entite = gtk_option_menu_new();
  menu_entite = gtk_menu_new();
  /****** Choice of list in function of object type ***********/
  if (0==strcmp(object_sissi->entite_type,"MATERIEL"))
  {  
    for (j = 0; propriete_materiel_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_materiel_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_materiel_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"LOGICIEL"))
  {  
    for (j = 0; propriete_logiciel_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_logiciel_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_logiciel_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"RESEAU"))
  {  
    for (j = 0; propriete_reseau_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_reseau_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_reseau_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PERSONNE"))
  {  
    for (j = 0; propriete_personnel_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_personnel_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_personnel_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHYSIQUE"))
  {  
    for (j = 0; propriete_physique_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_DETECTION_THERMIQUE"))
  {  
    for (j = 0; propriete_physique_detecTHERMIQUE_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_detecTHERMIQUE_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_detecTHERMIQUE_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_DETECTION_FEU"))
  {  
    for (j = 0; propriete_physique_detecFEU_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_detecFEU_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_detecFEU_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_DETECTION_EAU"))
  {  
    for (j = 0; propriete_physique_detecEAU_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_detecEAU_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_detecEAU_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_DETECTION_AIR"))
  {  
    for (j = 0; propriete_physique_detecAIR_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_detecAIR_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_detecAIR_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_DETECTION_ENERGIE"))
  {  
    for (j = 0; propriete_physique_detecENERGIE_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_detecENERGIE_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_detecENERGIE_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_DETECTION_INTRUSION"))
  {  
    for (j = 0; propriete_physique_detecINTRUSION_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_detecINTRUSION_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_detecINTRUSION_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_ACTION_THERMIQUE"))
  {  
    for (j = 0; propriete_physique_actionTHERMIQUE_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_actionTHERMIQUE_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_actionTHERMIQUE_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_ACTION_FEU"))
  {  
    for (j = 0; propriete_physique_actionFEU_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_actionFEU_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_actionFEU_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_ACTION_EAU"))
  {  
    for (j = 0; propriete_physique_actionEAU_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_actionEAU_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_actionEAU_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_ACTION_AIR"))
  {  
    for (j = 0; propriete_physique_actionAIR_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_actionAIR_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_actionAIR_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_ACTION_ENERGIE"))
  {  
    for (j = 0; propriete_physique_actionENERGIE_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_actionENERGIE_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_actionENERGIE_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"PHY_ACTION_INTRUSION"))
  {  
    for (j = 0; propriete_physique_actionINTRUSION_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_physique_actionINTRUSION_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_physique_actionINTRUSION_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"ORGANISATION"))
  {  
    for (j = 0; propriete_organisation_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_organisation_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_organisation_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }
  if (0==strcmp(object_sissi->entite_type,"SYSTEME"))
  {  
    for (j = 0; propriete_systeme_data[j].label != NULL; j++) {
        GtkWidget *item = gtk_menu_item_new_with_label(_(propriete_systeme_data[j].label));
        gtk_object_set_user_data(GTK_OBJECT(item),GUINT_TO_POINTER(propriete_systeme_data[j].value));
        gtk_container_add(GTK_CONTAINER(menu_entite), item);
      	gtk_widget_show(item);
    }
  }

  gtk_option_menu_set_menu(GTK_OPTION_MENU(object_sissi->properties_dialog->entite), menu_entite);
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), object_sissi->properties_dialog->entite, 2, 4, 1, 2);
/********** selection menu of entity *********/




  /********** Label of board **********/
  label = gtk_label_new (_("Libelle"));
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), label, 0, 1, 2, 3);
  label = gtk_label_new (_("valeur"));
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), label, 1, 2, 2, 3);
  label = gtk_label_new (_("Description"));
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), label, 2, 3, 2, 3);

  /**** board of value ***************/
  label = gtk_label_new (_("Name"));
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), label, 0, 1, 3, 4);
  object_sissi->properties_dialog->name=gtk_entry_new();
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), (GtkWidget *)object_sissi->properties_dialog->name, 1,2,3,4);

  button = gtk_button_new_with_mnemonic (_("_New"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC(autres_new_callback),
		      object_sissi);
 
 gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), button, 2, 3, 3, 4);


  object_sissi->properties_dialog->nb_proprietes_autres=4;

  gtk_widget_show_all (prop_dialog->vbox_autres);
  gtk_widget_show (prop_dialog->page_label_autres);
  gtk_widget_show_all (pScroll_autres);

  gtk_notebook_append_page(notebook, pScroll_autres, prop_dialog->page_label_autres);

}

/******************************************
*             Liste des documents         *
*******************************************/

static void
document_new_callback(GtkWidget *button, ObjetSISSI *object_sissi)
{
    unsigned int i;
    Url_Docs_Widget *doc_widget;
    SISSIDialog *prop_dialog;
  /*DiaObject *obj;*/
  	prop_dialog = object_sissi->properties_dialog;    
	i=prop_dialog->nb_doc +1;
	
	doc_widget=g_malloc0(sizeof(Url_Docs_Widget));
	
	doc_widget->label = gtk_entry_new();
	doc_widget->url = gtk_entry_new();
	doc_widget->description= gtk_entry_new();
	
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), (GtkWidget *)doc_widget->label, 0, 1, i+1, i+2);
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), (GtkWidget *)doc_widget->url, 1,2,i+1,i+2);
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), (GtkWidget *)doc_widget->description, 2,3,i+1,i+2);
	/* after create we add element in the wideget list */
	prop_dialog->url_docs=g_list_append(prop_dialog->url_docs,doc_widget);
	
	gtk_widget_show (prop_dialog->table_document);
	gtk_widget_show_all (prop_dialog->vbox_document);
  	gtk_widget_show (prop_dialog->page_label_document);	
	prop_dialog->nb_doc=i+1;
}

static void
document_fill_in_dialog(ObjetSISSI *object_sissi)
{
  GList *list;
  SISSIDialog *prop_dialog;
  /*/DiaObject *obj;*/
  unsigned int i;
  
  prop_dialog = object_sissi->properties_dialog;
  /*/obj = &object_sissi->element.object;*/
   prop_dialog->url_docs=vidage_liste_url_doc_widget(prop_dialog->url_docs);

   g_list_free (prop_dialog->url_docs);
   prop_dialog->url_docs = NULL;  
  
   for (i=0;i<g_list_length(object_sissi->url_docs);i++)
   {
	Url_Docs_Widget *doc_widget;
	doc_widget=g_malloc0(sizeof(Url_Docs_Widget));
	doc_widget->label = gtk_entry_new();
	gtk_entry_set_text((GtkEntry *)doc_widget->label, (((Url_Docs *)(g_list_nth(object_sissi->url_docs,i)->data))->label));
	doc_widget->url = gtk_entry_new();
	gtk_entry_set_text((GtkEntry *)doc_widget->url, (((Url_Docs *)(g_list_nth(object_sissi->url_docs,i)->data))->url));
	doc_widget->description= gtk_entry_new();
	gtk_entry_set_text((GtkEntry *)doc_widget->description, (((Url_Docs *)(g_list_nth(object_sissi->url_docs,i)->data))->description));
	
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), (GtkWidget *)doc_widget->label, 0, 1, i+2, i+3);
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), (GtkWidget *)doc_widget->url, 1,2,i+2, i+3);
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), (GtkWidget *)doc_widget->description, 2,3,i+2, i+3);
	/************ idem ************/
	prop_dialog->url_docs=g_list_append(prop_dialog->url_docs,doc_widget);
   }
   prop_dialog->nb_doc=i;
   gtk_widget_show (prop_dialog->table_document);
   gtk_widget_show_all (prop_dialog->vbox_document);
   gtk_widget_show (prop_dialog->page_label_document);
}

static void document_read_from_dialog(ObjetSISSI *object_sissi, SISSIDialog *prop_dialog)
{
  GList *list;
  /*/DiaObject *obj;*/
  unsigned int i;
  /*/obj = &object_sissi->element.object;*/
  
  object_sissi->url_docs=vidage_liste_url_doc(object_sissi->url_docs);
   for (i=0;i<g_list_length(prop_dialog->url_docs);i++)
   {
      Url_Docs *doc;
      doc=g_malloc0(sizeof(Url_Docs));
      doc->label = g_strdup(gtk_entry_get_text((GtkEntry *)(((Url_Docs_Widget *)(g_list_nth(prop_dialog->url_docs,i)->data))->label)));
      doc->url = g_strdup(gtk_entry_get_text((GtkEntry *)(((Url_Docs_Widget *)(g_list_nth(prop_dialog->url_docs,i)->data))->url)));
      doc->description = g_strdup(gtk_entry_get_text((GtkEntry *)(((Url_Docs_Widget *)(g_list_nth(prop_dialog->url_docs,i)->data))->description)));
      if((strcmp(doc->label,"")==0)&&(strcmp(doc->url,"")==0)&&(strcmp(doc->description,"")==0))
      {
	g_free(doc->label);
	g_free(doc->url);
	g_free(doc->description);
	g_free(doc);
      }
      else
      {
      	object_sissi->url_docs=g_list_append(object_sissi->url_docs, doc);
      }
   }  
}

static void document_create_page(GtkNotebook *notebook, ObjetSISSI *object_sissi)
{
  SISSIDialog *prop_dialog;
  GtkWidget *label,*button;
  GtkWidget *menu_classification, *menu_integrite, *menu_disponibilite_echelle, *disponibilite_valeur;  
  GtkWidget *menu_entite;
 
  prop_dialog = object_sissi->properties_dialog;
  
  /* Other properties of page */
  prop_dialog->page_label_document = gtk_label_new_with_mnemonic (_("Documents"));
  
  prop_dialog->vbox_document = gtk_vbox_new(FALSE, 1);
  gtk_container_set_border_width (GTK_CONTAINER (prop_dialog->vbox_document), 0);
  
  prop_dialog->table_document = gtk_table_new (43, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (prop_dialog->vbox_document), prop_dialog->table_document, FALSE, FALSE, 0);
  
  
  button = gtk_button_new_with_mnemonic (_("_New"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC(document_new_callback),
		      object_sissi);
 
 gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), button, 0, 1, 0, 1);
    
  label = gtk_label_new (_("Document title"));
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), label, 0, 1, 1, 2);
  label = gtk_label_new (_("URL"));
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), label, 1, 2, 1, 2);
  label = gtk_label_new (_("Description"));
  gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_document), label, 2, 3, 1, 2);

  gtk_widget_show_all (prop_dialog->vbox_document);
  gtk_widget_show (prop_dialog->page_label_document);
  gtk_notebook_append_page(notebook, prop_dialog->vbox_document, prop_dialog->page_label_document);
  prop_dialog->nb_doc=0;
}


static void switch_page_callback(GtkNotebook *notebook, GtkNotebookPage *page)
{
  ObjetSISSI *object_sissi;
  SISSIDialog *prop_dialog;

  object_sissi = (ObjetSISSI *)
    gtk_object_get_user_data(GTK_OBJECT(notebook));

  prop_dialog = object_sissi->properties_dialog;

  if (prop_dialog != NULL) {
  }
}

static void destroy_properties_dialog (GtkWidget* widget, gpointer user_data)
{

  ObjetSISSI *object_sissi = (ObjetSISSI *)user_data;
  object_sissi->properties_dialog->proprietes_menaces=vidage_liste_propriete_menace_widget(object_sissi->properties_dialog->proprietes_menaces);
  object_sissi->properties_dialog->proprietes_autres=vidage_liste_propriete_widget(object_sissi->properties_dialog->proprietes_autres);
  object_sissi->properties_dialog->url_docs=vidage_liste_url_doc_widget(object_sissi->properties_dialog->url_docs);
  /*/g_list_free(object_sissi->properties_dialog->proprietes_menaces);*/
  gtk_widget_destroy(object_sissi->properties_dialog->confidentialite);
  gtk_widget_destroy(object_sissi->properties_dialog->integrite);
  gtk_widget_destroy(object_sissi->properties_dialog->disponibilite_echelle);
  gtk_widget_destroy(object_sissi->properties_dialog->disponibilite_valeur);
  gtk_widget_destroy(object_sissi->properties_dialog->entite);
  gtk_widget_destroy((GtkWidget *)object_sissi->properties_dialog->name);
  
  g_free(object_sissi->properties_dialog);
/*/   object_sissi->properties_dialog = NULL;*/
}

static void fill_in_dialog(ObjetSISSI *object_sissi)
{
  unsigned int i,pos=0;
  SISSIDialog   *prop_dialog;

  prop_dialog = object_sissi->properties_dialog;
/********* update the classification ***********/
  if (object_sissi->confidentialite!=NULL){
    for (i = 0; propriete_classification_data[i].label != NULL; i++) { 
      if (0==strcmp(propriete_classification_data[i].value,object_sissi->confidentialite)) {
	pos = i;
        break;
      }
    }
  }
  gtk_option_menu_set_history(GTK_OPTION_MENU(prop_dialog->confidentialite), pos);
  
  if (object_sissi->integrite!=NULL){
    for (i = 0; propriete_integrite_data[i].label != NULL; i++) { 
      if (0==strcmp(propriete_integrite_data[i].value,object_sissi->integrite)) {
	pos = i;
        break;
      }
    }
  }
  gtk_option_menu_set_history(GTK_OPTION_MENU(prop_dialog->integrite), pos);
  
  if (object_sissi->disponibilite_echelle!=NULL){
    for (i = 0; propriete_disponibilite_echelle_data[i].label != NULL; i++) { 
      if (0==strcmp(propriete_disponibilite_echelle_data[i].value,object_sissi->disponibilite_echelle)) {
	pos = i;
        break;
      }
    }
  }
  gtk_option_menu_set_history(GTK_OPTION_MENU(prop_dialog->disponibilite_echelle), pos);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(prop_dialog->disponibilite_valeur),object_sissi->disponibilite_valeur);
  
 /****** update the entity ******/
  if (object_sissi->entite!=NULL){
    /*** choice of list by rntite type */
    if (0==strcmp(object_sissi->entite_type,"SYSTEME")){
      for (i = 0; propriete_systeme_data[i].label != NULL; i++) { 
        if (0==strcmp(propriete_systeme_data[i].value,object_sissi->entite)) {
	  pos = i;
          break;
	}
      }
    }
    if (0==strcmp(object_sissi->entite_type,"ORGANISATION")){
      for (i = 0; propriete_organisation_data[i].label != NULL; i++) { 
        if (0==strcmp(propriete_organisation_data[i].value,object_sissi->entite)) {
	  pos = i;
          break;
	}
      }
    }
    if (0==strcmp(object_sissi->entite_type,"PHYSIQUE")){
      for (i = 0; propriete_physique_data[i].label != NULL; i++) { 
        if (0==strcmp(propriete_physique_data[i].value,object_sissi->entite)) {
	  pos = i;
          break;
	}
      }
    }
    if (0==strcmp(object_sissi->entite_type,"PERSONNE")){
      for (i = 0; propriete_personnel_data[i].label != NULL; i++) { 
        if (0==strcmp(propriete_personnel_data[i].value,object_sissi->entite)) {
	  pos = i;
          break;
	}
      }
    }
    if (0==strcmp(object_sissi->entite_type,"RESEAU")){
      for (i = 0; propriete_reseau_data[i].label != NULL; i++) { 
        if (0==strcmp(propriete_reseau_data[i].value,object_sissi->entite)) {
	  pos = i;
          break;
	}
      }
    }
    if (0==strcmp(object_sissi->entite_type,"LOGICIEL")){
      for (i = 0; propriete_logiciel_data[i].label != NULL; i++) { 
        if (0==strcmp(propriete_logiciel_data[i].value,object_sissi->entite)) {
	  pos = i;
          break;
	}
      }
    }
    if (0==strcmp(object_sissi->entite_type,"MATERIEL")){
      for (i = 0; propriete_materiel_data[i].label != NULL; i++) { 
        if (0==strcmp(propriete_materiel_data[i].value,object_sissi->entite)) {
	  pos = i;
          break;
	}
      }
    }
  }
  gtk_option_menu_set_history(GTK_OPTION_MENU(prop_dialog->entite), pos);
  
/*********** update the properties list **********/
  for (i=0;i<g_list_length(object_sissi->proprietes_menaces);i++)
  {
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(((Propriete_Menace_Widget *)(g_list_nth(prop_dialog->proprietes_menaces,i)->data))->action), (((Propriete_Menace *)(g_list_nth(object_sissi->proprietes_menaces,i)->data))->action));
	/**********************************/
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(((Propriete_Menace_Widget *)(g_list_nth(prop_dialog->proprietes_menaces,i)->data))->detection), (((Propriete_Menace *)(g_list_nth(object_sissi->proprietes_menaces,i)->data))->detection));
	/**********************************/
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(((Propriete_Menace_Widget *)(g_list_nth(prop_dialog->proprietes_menaces,i)->data))->vulnerability), (((Propriete_Menace *)(g_list_nth(object_sissi->proprietes_menaces,i)->data))->vulnerability));
	gtk_entry_set_text((GtkEntry *)((Propriete_Menace_Widget *)(g_list_nth(prop_dialog->proprietes_menaces,i)->data))->comments, (((Propriete_Menace *)(g_list_nth(object_sissi->proprietes_menaces,i)->data))->comments));
			/*fprintf(stderr,"espion fill 2\n");*/
  }

  if (object_sissi->name != NULL)
    gtk_entry_set_text((GtkEntry *)prop_dialog->name,(char *)object_sissi->name);
  else
    gtk_entry_set_text((GtkEntry *)prop_dialog->name, "");
    
    document_fill_in_dialog(object_sissi);

   prop_dialog->proprietes_autres=vidage_liste_propriete_widget(prop_dialog->proprietes_autres);
   for (i=0;i<g_list_length(object_sissi->proprietes_autres);i++)
   {
	Propriete_Widget *propriete_autres_widget;
	propriete_autres_widget=g_malloc0(sizeof(Propriete_Widget));
	if(i < object_sissi->nb_autres_fixes)
	{
	/* if the case is empty we put NULL for no have problem in traduction */
		if ((((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->label)!=NULL)
		{
			if (strcmp((((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->label),"")==0)
			{	propriete_autres_widget->label = gtk_label_new (NULL);}
			else
			{	propriete_autres_widget->label = gtk_label_new (_(((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->label));}
		}
		else
		{
			propriete_autres_widget->label = gtk_label_new (NULL);
		}
		
		if ((((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->description)!=NULL)
		{
			if (strcmp((((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->description),"")==0)
			{	propriete_autres_widget->description = gtk_label_new (NULL);}
			else
			{	propriete_autres_widget->description = gtk_label_new (_(((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->description));}
		}
		else
		{
			propriete_autres_widget->description = gtk_label_new (NULL);
		}

	}
	else
	{
		propriete_autres_widget->label = gtk_entry_new();
		gtk_entry_set_text((GtkEntry *)propriete_autres_widget->label, (((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->label));
		propriete_autres_widget->description= gtk_entry_new();
		gtk_entry_set_text((GtkEntry *)propriete_autres_widget->description, (((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->description));
	}
	propriete_autres_widget->value = gtk_entry_new();
	if ((((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->value)!=NULL)
	  gtk_entry_set_text((GtkEntry *)propriete_autres_widget->value, (((Propriete *)(g_list_nth(object_sissi->proprietes_autres,i)->data))->value));
	
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), (GtkWidget *)propriete_autres_widget->label, 0, 1, i+5, i+6);
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), (GtkWidget *)propriete_autres_widget->value, 1,2,i+5,i+6);
	gtk_table_attach_defaults (GTK_TABLE (prop_dialog->table_autres), (GtkWidget *)propriete_autres_widget->description, 2,3,i+5,i+6);
	prop_dialog->proprietes_autres=g_list_append(prop_dialog->proprietes_autres,propriete_autres_widget);
   }
   prop_dialog->nb_proprietes_autres=i;
  
   gtk_widget_show (prop_dialog->table_autres);
   gtk_widget_show_all (prop_dialog->vbox_autres);
   gtk_widget_show (prop_dialog->page_label_autres);

}

extern ObjectChange *object_sissi_apply_properties_dialog(ObjetSISSI *object_sissi)
{
  SISSIDialog *prop_dialog;
  DiaObject *obj;
  GList *added, *deleted, *disconnected;
  SISSIState *old_state = NULL;
  prop_dialog = object_sissi->properties_dialog;

  obj = &object_sissi->element.object;
    proprietes_menaces_read_from_dialog(object_sissi, prop_dialog);
    proprietes_autres_read_from_dialog(object_sissi, prop_dialog);
    document_read_from_dialog(object_sissi, prop_dialog);
    object_sissi_update_data(object_sissi, ANCHOR_MIDDLE, ANCHOR_MIDDLE);
   return new_sissi_change(object_sissi, old_state, added, deleted, disconnected);
}

static void create_dialog_pages(GtkNotebook *notebook, ObjetSISSI *object_sissi)
{
  proprietes_autres_create_page(notebook, object_sissi);
  proprietes_menaces_create_page(notebook, object_sissi);
  document_create_page(notebook, object_sissi);
}

extern GtkWidget *object_sissi_get_properties_dialog(ObjetSISSI *object_sissi, gboolean is_default)
{
  SISSIDialog *prop_dialog;
  GtkWidget *vbox;
  GtkWidget *notebook;
GtkObject *Adjust;

  if (object_sissi->properties_dialog == NULL) {
    prop_dialog = g_new(SISSIDialog, 1);
    object_sissi->properties_dialog = prop_dialog;
  
/**** initialisation of properties list **********/

    vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 0);

    gtk_object_ref(GTK_OBJECT(vbox));
    gtk_object_sink(GTK_OBJECT(vbox));

   prop_dialog->dialog = vbox;


/************ initialisation of data ****************/
    prop_dialog->proprietes_menaces=NULL;
    prop_dialog->proprietes_autres = NULL;
    prop_dialog->url_docs = NULL;

    notebook = gtk_notebook_new ();

    gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
    gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
/* fixing the width of dialog box */
    gtk_container_set_border_width (GTK_CONTAINER (notebook), 0);

    gtk_object_set_user_data(GTK_OBJECT(notebook), (gpointer) object_sissi);
    
    gtk_signal_connect (GTK_OBJECT (notebook),
			"switch_page",
			GTK_SIGNAL_FUNC(switch_page_callback),
			(gpointer) object_sissi);
    gtk_signal_connect (GTK_OBJECT (object_sissi->properties_dialog->dialog),
		        "destroy",
			GTK_SIGNAL_FUNC(destroy_properties_dialog),
			(gpointer) object_sissi);
    
    create_dialog_pages(GTK_NOTEBOOK( notebook ), object_sissi);

    gtk_widget_show (notebook);
  }

  fill_in_dialog(object_sissi);
  gtk_widget_show (object_sissi->properties_dialog->dialog);
  return object_sissi->properties_dialog->dialog;
}

static Propriete *propriete_copy(Propriete *prop)
{
  Propriete *newprop;
  newprop = g_new0(Propriete, 1);
  
  newprop->label = g_strdup(prop->label);
  newprop->value = g_strdup(prop->value);
  newprop->description = g_strdup(prop->description);
  return newprop;
};
