/* Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * Jackson diagram -  adapted by Christophe Ponsard
 * This class captures all kind of domains (given, designed, machine)
 * both for sissi_object problems and for problem frames (ie. with domain kinds)
 *
 * based on SADT diagrams copyright (C) 2000, 2001 Cyrille Chepelov
 *
 * Forked from Flowchart toolbox -- objects for drawing flowcharts.
 * Copyright (C) 1999 James Henstridge.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SISSI_H
#define SISSI_H

#include <stdio.h>
#include <assert.h>
#include <glib.h>

#include "dia_dirs.h"

#include "diatypes.h"
#include <gdk/gdktypes.h>

#include "geometry.h"
#include "polyshape.h"

#include "object.h"
#include "element.h"
#include "connectionpoint.h"
#include "widgets.h"
#include "dia_image.h"

#include "plug-ins.h"

#include "menace.h"
#include "properties.h"

/************** Start of "define" daclaration of SISSI **************/

#define ORDINATEUR_LINEWIDTH  0.1
#define ORDINATEUR_FONTHEIGHT 0.8
#define LEFT_SPACE 0.7
#define RIGHT_SPACE 0.3
#define DEFAULT_FONT 0.7
/************** End of "define" daclaration of SISSI **************/

typedef struct _ObjetSISSI ObjetSISSI;
typedef struct _SISSIDialog SISSIDialog;
typedef struct _SISSIState SISSIState;
typedef struct _SISSIChange SISSIChange;


struct _SISSIState {
  /* menaces: */

  /* others: */
	GList *proprietes_autres;
};

struct _SISSIChange {
  ObjectChange obj_change;
  
  ObjetSISSI *obj;
  SISSIState *saved_state;
  int applied;
};


typedef enum {
  ANCHOR_MIDDLE,
  ANCHOR_START,
  ANCHOR_END
} AnchorShape;

static struct _ImageProperties {
  gchar *file;
  gboolean draw_border;
  gboolean keep_aspect;
} default_properties = { "", FALSE, TRUE };


struct _ObjetSISSI {
  Element element;
  ConnectionPoint connections[9];
  /*/PolyShape poly;	*/	/* always 1st! */
  AnchorShape 		celltype;
  real 			radius;			/* pseudo-radius */
  int 			subscribers;		/* number of subscribers in this cell,*/
  gboolean 		show_background;
  Color 		fill_colour;
  Text 			*text;
  Color 		line_colour;
  LineStyle 		line_style;
  real 			dashlength;
  real 			line_width;

  DiaImage 		image;
  gchar 		*file;
  real 			border_width;
  Color 		border_color;
    
  gboolean 		draw_border;
  gboolean		keep_aspect;
 
  gchar 		*id_db;   /* this id is use by a external database and used only by there*/
	/*entite classification properties*/
  gchar 		*confidentialite,*integrite,*disponibilite_echelle;
  float 		disponibilite_valeur;
  gchar 		*name;
  gchar			*entite;
  gchar			*entite_type;
  gchar			*type_element;  /* name of object */
  /****** name of romm and site where is the object *******/
  gchar			*room,*site;
  
    /********* menaces *********/
  GList 		*proprietes_menaces;
  unsigned int			nb_autres_fixes;

  /*********** others properties ***************/
  GList 		*proprietes_autres;
  int			nb_propriete_fixe;
  /********** documents list ****************/ 
  GList 		*url_docs; 
  /*********** dialog box **********/
  SISSIDialog 		*properties_dialog;

};


struct _SISSIDialog {
  GtkWidget 	*dialog;
  GtkWidget	*confidentialite, *integrite, *disponibilite_echelle, *disponibilite_valeur;
  GtkWidget	*entite;
  GtkWidget	*name;
  GtkWidget 	*table_document,*page_label_document,*vbox_document;
  GtkWidget 	*table_autres,*page_label_autres,*vbox_autres;
  int		nb_doc;
  int		nb_proprietes_autres;
/*/   GtkList 		*document_list;*/
    /*********menaces *********/
  GList 	*proprietes_menaces;
  /************ others properties **************/
  GList 	*proprietes_autres;
  /**************** Documents list***************/
  GList 	*url_docs;
};

typedef struct _Url_Docs Url_Docs;
typedef struct _Url_Docs_Widget Url_Docs_Widget;

struct _Url_Docs {
  gchar *label, *url, *description;
};

struct _Url_Docs_Widget {
  GtkWidget 	*label,*url,*description;
};

typedef struct _Propriete Propriete;
typedef struct _Propriete_Widget Propriete_Widget;

struct _Propriete {
  gchar *label;
  gchar *value;
  gchar *description;
};

struct _Propriete_Widget {
  GtkWidget 	*label,*description;
  GtkWidget	*value;
};


extern Propriete *create_new_propriete_autre(gchar *label, gchar *description, gchar *value);
extern Url_Docs *create_new_url(gchar *label, gchar *description, gchar *value);
void propriete_url_write(AttributeNode attr_node, Url_Docs *url_docs);

extern real object_sissi_distance_from(ObjetSISSI *object_sissi, Point *point);
extern void object_sissi_select(ObjetSISSI *object_sissi, Point *clicked_point, DiaRenderer *interactive_renderer);
extern ObjectChange* object_sissi_move_handle(ObjetSISSI *object_sissi, Handle *handle, Point *to, ConnectionPoint *cp,
			    HandleMoveReason reason, ModifierKeys modifiers);
extern ObjectChange* object_sissi_move(ObjetSISSI *object_sissi, Point *to);
extern void object_sissi_draw(ObjetSISSI *object_sissi, DiaRenderer *renderer);
extern void object_sissi_update_data(ObjetSISSI *pc, AnchorShape horix, AnchorShape vert);

extern void object_sissi_destroy(ObjetSISSI *object_sissi);
void dialog_sissi_destroy(SISSIDialog *properties_dialog);
/*/extern DiaMenu *pc_get_object_menu(ObjetSISSI *pc, Point *clickedpoint);*/
extern ObjetSISSI *object_sissi_load(ObjectNode obj_node, int version, const char *filename, ObjetSISSI *object_sissi,Element *elem,DiaObject *obj);

extern GtkWidget *object_sissi_get_properties(ObjetSISSI *object_sissi, gboolean is_default);
extern void object_sissi_apply_properties(ObjetSISSI *object_sissi);

extern DiaObject *object_sissi_copy_using_properties(ObjetSISSI *object_sissi_origine);

extern void object_sissi_save(ObjetSISSI *object_sissi, ObjectNode obj_node, const char *filename);
extern void propriete_menace_write(AttributeNode attr_node, Propriete_Menace *proprietes_menaces);
Propriete_Menace *propriete_menace_read(DataNode composite);
extern void propriete_autre_write(AttributeNode attr_node, Propriete *proprietes_autre);
Propriete *propriete_autre_read(DataNode composite);
extern void url_doc_write(AttributeNode attr_node, Url_Docs *url_docs);
extern Url_Docs *url_doc_read(DataNode composite);
extern GList *vidage_liste_propriete (GList *list);
extern GList *vidage_liste_url_doc (GList *list);
extern void gestion_specificite(ObjetSISSI *object_sissi,int user_data);

static Propriete propriete_classification_data[] = {
  { N_("Non Protege"), "NON_PROTEGE" ,NULL},
  { N_("Diffusion Restreinte"), "DIFFUSION_RESTREINTE" ,NULL},
  { N_("Confidentiel special pays"), "CONFIDENTIEL_SPECIAL_COUNTRY" ,NULL},
  { N_("Confidentiel OTAN"), "CONFIDENTIEL_OTAN" ,NULL},
  { N_("Confidentiel Personnel"), "CONFIDENTIEL_PERSONNEL" ,NULL},
  { N_("Confidentiel Medical"), "CONFIDENTIEL_MEDICAL" ,NULL},
  { N_("Confidentiel Industrie"), "CONFIDENTIEL_INDUSTRIE" ,NULL},
  { N_("Secret"), "SECRET" ,NULL},
  { N_("Secret special pays"), "SECRET_SPECIAL_COUNTRY" ,NULL},
  { N_("Secret OTAN"), "SECRET_OTAN" ,NULL},
  { N_("Tres Secret"), "TRES_SECRET" ,NULL},
  { N_("Tres Secret OTAN"), "TRES SECRET_OTAN" ,NULL},
  { NULL,0,NULL}
};

static Propriete propriete_integrite_data[] = {
  { N_("No integrity"), "NULL" ,NULL},
  { N_("Low integrity"), "FAIBLE" ,NULL},
  { N_("Average sowtware integrity"), "INTEGRITE_LOGICIEL_MOYENNE" ,NULL},
  { N_("Hight sowtware integrity"), "INTEGRITE_LOGICIEL_FORTE" ,NULL},
  { N_("Average hardware integrity"), "INTEGRITE_MATERIEL_MOYENNE" ,NULL},
  { N_("Hight hardware integrity"), "INTEGRITE_MATERIEL_FORTE" ,NULL},
  { NULL,0,NULL}
};

static Propriete propriete_disponibilite_echelle_data[] = {
  { N_("Millisecond"), "MILLISECOND" ,NULL},
  { N_("Seconde"), "SECONDE" ,NULL},
  { N_("Minute"), "MINUTE" ,NULL},
  { N_("Hour"), "HEURE" ,NULL},
  { N_("Day"), "JOURNEE" ,NULL},
  { N_("Week"), "SEMAINE" ,NULL},
  { NULL,0,NULL}
};

static Propriete propriete_systeme_data[] = {
  { N_("SYSTEME"), "SYS",NULL},
  { N_("Dispositif d'Acces Internet"), "SYS_INT",NULL},
  { N_("Messagerie"), "SYS_MES",NULL},
  { N_("Intranet"), "SYS_ITR",NULL},
  { N_("Annuaire d'Entreprise"), "SYS_ANU",NULL},
  { NULL,0,NULL}
};

static Propriete propriete_organisation_data[] = {
  { N_("ORGANISATION"), "ORG",NULL},
     { N_("Organisation dont depend L'organisme"), "ORG_DEP",NULL},
     { N_("Organisation de L'organisme"), "ORG_GEN",NULL},
     { N_("Organisation de Projet ou d'un systeme"), "ORG_PRO",NULL},
     { N_("Sous-Traitants/Fournisseurs/Industriels"),"ORG_EXT",NULL},
  { NULL,0,NULL}
};

static Propriete propriete_physique_data[] = {
  { N_("SITE"), "PHY",NULL},
   { N_("Lieu"), "PHY_LIE",NULL},
     { N_("Externe"), "PHY_LIE1",NULL},
     { N_("Locaux"), "PHY_LIE2",NULL},
     { N_("Zone"), "PHY_LIE3",NULL},
   { N_("Service Essentiel"), "PHY_SRV",NULL},
     { N_("Communication"), "PHY_SRV1",NULL},
     { N_("Energie"), "PHY_SRV2",NULL},
     { N_("Refroidissement/Pollution"), "PHY_SRV3",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_detecTHERMIQUE_data[] = {
  { N_("DETECTION THERMIQUE"), "PHY_DETECTION_THERMIQUE",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_detecFEU_data[] = {
  { N_("DETECTION FEU"), "PHY_DETECTION_FEU",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_detecEAU_data[] = {
  { N_("DETECTION EAU"), "PHY_DETECTION_EAU",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_detecAIR_data[] = {
  { N_("DETECTION AIR"), "PHY_DETECTION_AIR",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_detecENERGIE_data[] = {
  { N_("DETECTION ENERGIE"), "PHY_DETECTION_ENERGIE",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_detecINTRUSION_data[] = {
  { N_("DETECTION INTRUSION"), "PHY_DETECTION_INTRUSION",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_actionTHERMIQUE_data[] = {
  { N_("ACTION THERMIQUE"), "PHY_ACTION_THERMIQUE",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_actionFEU_data[] = {
  { N_("ACTION FEU"), "PHY_ACTION_FEU",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_actionEAU_data[] = {
 { N_("ACTION EAU"), "PHY_ACTION_EAU",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_actionAIR_data[] = {
  { N_("ACTION AIR"), "PHY_ACTION_AIR",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_actionENERGIE_data[] = {
  { N_("ACTION ENERGIE"), "PHY_ACTION_ENERGIE",NULL},
  { NULL, 0,NULL}
};
static Propriete propriete_physique_actionINTRUSION_data[] = {
  { N_("ACTION INTRUSION"), "PHY_ACTION_INTRUSION",NULL},
  { NULL, 0,NULL}
};

static Propriete propriete_personnel_data[] = {
  { N_("PERSONNEL"), "PER",NULL},
   { N_("Decisionnel"), "PER_DEC",NULL},
   { N_("Responsable SSI"), "PER_RESP_SSI",NULL},
   { N_("Utilisateurs"), "PER_UTI",NULL},
   { N_("Administrateur fonctionnel"), "PER_ADMIN_FONC",NULL},
   { N_("Administrateur technique"), "PER_ADMIN_TECH",NULL},
   { N_("Administrateur SSI"), "PER_EXP_SSI",NULL},
   { N_("Developpeur"), "PER_DEV",NULL},
  { NULL, 0,NULL}
};

static Propriete propriete_reseau_data[] = {
  { N_("RESEAU"), "RES",NULL},
   { N_("Medium et Supports"), "RES_INF",NULL},
   { N_("Relais Passif ou Actif"), "RES_REL",NULL},
   { N_("Interface de Communication"), "RES_INT",NULL},
  { NULL, 0,NULL}
};

static Propriete propriete_logiciel_data[] = {
  { N_("LOGICIEL"), "LOG",NULL},
    { N_("Systeme d'Exploitation"), "LOG_OS",NULL},
    { N_("Logiciel de Service-Maintenance ou administration"), "LOG_SRV",NULL},
    { N_("Progiciel ou Logiciel Standard"), "LOG_STD",NULL},
    { N_("Application Metier"), "LOG_APP",NULL},
      { N_("Application metier standard"), "LOG_APP1",NULL},
      { N_("Application metier specifique"), "LOG_APP2",NULL},
  { NULL, 0,NULL}
};

static Propriete propriete_materiel_data[] = {
  { N_("MATERIEL"), "MAT",NULL},
  { N_("Support de Traitement de Donnees (actif)"), "MAT_ACT",NULL},
  { N_("Materiel transportable"), "MAT_ACT1",NULL},
  { N_("Materiel fixe"), "MAT_ACT2",NULL},
  { N_("Peripherique de traitement"), "MAT_ACT3",NULL},
  { N_("Support electronique"), "MAT_PAS1",NULL},
  { N_("Autres supports"), "MAT_PAS2",NULL},  
  { N_("Support de Donnees (passif)"), "MAT_PAS",NULL},
  { NULL, 0,NULL}
};


/*///////////////d�inition des type de couleur  ////////////////*/
static Color color_red = { 1.0f, 0.0f, 0.0f };
static Color color_gris = { 0.5f, 0.5f, 0.5f };
static Color color_gris_clear = { 0.95f, 0.95f, 0.95f };
static Color color_green = { 0.0f, 1.0f, 0.0f };
static Color color_green_clear = { 0.87, 0.98f, 0.91 };

/*
static Color color_blue = { 0.0f, 0.0f, 1.0f };
static Color color_brown = { 0.54f, 0.08f, 0.08f };
static Color color_pink = { 1.0f, 0.75f, 0.80f };
static Color color_yellow = { 1.0f, 1.0f, 0.0f };
static Color color_orange = { 1.0f, 0.65f, 0.0f };
*/

#endif /* SISSI_H */
