using System;

using FSpot;
using FSpot.Extensions;

namespace FSpot.Extensions {

	public class SendMailExtension: FSpot.Extensions.ExportExtension
	{
		protected override string ConfigurationName { get { return "SendMailExtension"; } }
		public override string DisplayName { get { return "Send Email Extension"; } }
		public override string Description { get { return "This extension reimplement the basic send mail as a extension"; } }
		public override string MenuEntryName { get { return "Send as email"; } }
		public override ExtensionRevision Revision { get { return new ExtensionRevision(0, 1, 0); } }
		public override string [] Authors {
			get { 
				return new string [] {
					"Stephane Delcroix <stephane@delcroix.org>"
				};
			} 
		}

		public SendMailExtension () : base()
		{
			Console.WriteLine("new SendMailExtension instanciated !");	
		}

		protected override void Run()
		{
			System.Text.StringBuilder url = new System.Text.StringBuilder ("mailto:?subject=my%20photos");
			foreach (Photo p in photos.Items) {
				url.Append ("&attach=" + UriList.EscapeString (p.DefaultVersionUri.LocalPath, true, true, true));
			}
			Gnome.Url.Show (url.ToString ());
			Console.WriteLine ("Exporting {0} pictures", photos.Count);	
		}

		protected override void ExtensionInitialize()
		{
			Console.WriteLine("Initializing SendMailExtension");	
		}

		protected override void ExtensionDispose()
		{
			Console.WriteLine("Disposing SendMailExtension");
		}
	}
}
