using System;

using FSpot;
using FSpot.Plugins;

namespace FSpot.Plugins {

	public class SendMailPlugin: FSpot.Plugins.ExportPlugin
	{
		protected override string ConfigurationName { get { return "SendMailPlugin"; } }
		public override string DisplayName { get { return "Send Email Plugin"; } }
		public override string Description { get { return "This plugin reimplement the basic send mail as a plugin"; } }
		public override string MenuEntryName { get { return "Send as email"; }}
		public override string [] Authors {
			get { 
				return new string [] {
					"Stephane Delcroix <stephane@delcroix.org>"
				};
			} 
		}

		public SendMailPlugin () : base()
		{
			Console.WriteLine("new SendMailPlugin instanciated !");	
		}

		protected override void Run()
		{
			System.Text.StringBuilder url = new System.Text.StringBuilder ("mailto:?subject=my%20photos");
			foreach (Photo p in photos.Items) {
				url.Append ("&attach=" + UriList.EscapeString (p.DefaultVersionUri.LocalPath, true, true, true));
			}
			Gnome.Url.Show (url.ToString ());
			Console.WriteLine ("Exporting {0} pictures", photos.Count);	
		}

		protected override void PluginInitialize()
		{
			Console.WriteLine("Initializing SendMailPlugin");	
		}

		protected override void PluginDispose()
		{
			Console.WriteLine("Disposing SendMailPlugin");
		}
	}
}
