/*
 * PluginDialogPlugin.cs
 *
 * Authors:
 *   Stephane Delcroix <stephane@delcroix.org>
 *
 * Copyright (C) 2006 Stephane Delcroix
 */


using System;
using Gtk;
using Mono.Posix;

using FSpot;
using FSpot.Plugins;

namespace FSpot.Plugins {

	public class PluginDialogPlugin: FSpot.Plugins.Plugin
	{
		protected override string ConfigurationName { get { return "PluginDialogPlugin"; } }
		public override string DisplayName { get { return "Plugin Dialog Plugin"; } }
		public override string Description { get { return "This plugin creates a dialog to enable/disable plugins"; } }
		public override PluginCategory Category { get { return PluginCategory.Misc; } }
		public override string [] Authors {
			get { 
				return new string [] {
					"Stephane Delcroix"
				};
			} 
		}

		public PluginDialogPlugin () : base()
		{
			Console.WriteLine("new PDP instanciated !");	
			Preferences.Get("Enabled", true);
		}


		protected override void PluginInitialize()
		{
			Console.WriteLine("Initializing PDP");	
			try {
				new PluginDialog();
			} catch (Exception e) {
				Console.WriteLine(e);
			}
		}

		protected override void PluginDispose()
		{
			Console.WriteLine("Disposing PDP");
		}
	}

	public class PluginDialog
	{
		private string dialog_name = "plugin_dialog";
		private Glade.XML xml;
		private Gtk.Dialog dialog;

		[Glade.Widget] Gtk.Label plugins_label;
		[Glade.Widget] Gtk.Label loaded_label;
		[Glade.Widget] Gtk.VBox plugins_vbox;

		public PluginDialog()
		{
			CreateDialog();
			Dialog.Modal = false;
			Dialog.TransientFor = null;
			Populate();
			Dialog.ShowAll();
			Dialog.Response += HandleResponse;
		}

		private void Populate()
		{
			int plugins = 0;
			int loaded = 0;

			foreach (Plugin p in PluginCore.Factory) {
				PluginCheck cb = new PluginCheck(p.DisplayName);
				plugins ++;
				if ((bool)p.Preferences.Get("Enabled", false)) {
					cb.Active = true;
					loaded++;
				}
				cb.Plugin = p;
				cb.Toggled += HandleToggled;
				plugins_vbox.Add(cb);
			}
			plugins_label.Text = plugins.ToString();
			loaded_label.Text = loaded.ToString();
		}

		private void ApplyChanges ()
		{
			PluginCore.Reload();
			Populate();
		}

		private void CreateDialog()
		{
			xml = new Glade.XML (null, "plugindialog.glade", dialog_name, "f-spot");
			xml.Autoconnect (this);
		}

		private Gtk.Dialog Dialog {
			get {
				if (dialog == null)
					dialog = (Gtk.Dialog) xml.GetWidget (dialog_name);
				return dialog;
			}
		}

		private void HandleToggled (object sender, EventArgs args)
		{
			if (((PluginCheck)sender).Active)
				((PluginCheck)sender).Plugin.Preferences.Set("Enabled", true);
			else
				((PluginCheck)sender).Plugin.Preferences.Set("Enabled", false);

		}

		private void HandleResponse (object sender, Gtk.ResponseArgs args)
		{
			if (args.ResponseId != Gtk.ResponseType.Apply){
				Dialog.Destroy();
				return;
			}

			ApplyChanges();

			return;
		}

		private class PluginCheck : CheckButton
		{
			Plugin plugin;

			public PluginCheck(string label) : base(label)
			{
			}

			public Plugin Plugin {
				get {
					return plugin;
				}
				set {
					plugin = value;
				}
			}
		}
	}
}
