#include <windows.h>
#include <tchar.h>

#define CM_COPY 100
#define CM_PASTE 101


LRESULT CALLBACK
WndProc (HWND   hWnd,
         UINT   uMsg,
         WPARAM wParam,
         LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case CM_COPY:
              {
                HGLOBAL hGlobal;
                LPWSTR lpszGlobal;
                WCHAR szText[] =
                {'T', 'e', 's', 't', ' ', 'S', 't', 'r', 'i', 'n', 'g', ' ',
                 'F', 'r', 'o', 'm', ' ', 'W', 'i', 'n', '3', '2', '\r', '\n',
                 0x5ca9, 0x672c, 0x4e00, 0x6a39, '\r', '\n', '\0'};

                hGlobal = GlobalAlloc (GMEM_MOVEABLE, (lstrlenW (szText) + 1)
                                                            * sizeof (WCHAR));
                lpszGlobal = GlobalLock (hGlobal);
                lstrcpyW (lpszGlobal, szText);
                GlobalUnlock (hGlobal);
                OpenClipboard (hWnd);
                EmptyClipboard ();
                SetClipboardData (CF_UNICODETEXT, hGlobal);
                CloseClipboard ();
              }
              return 0;
            case CM_PASTE:
              OpenClipboard (hWnd);
              if (IsClipboardFormatAvailable (CF_UNICODETEXT))
                {
                  int i;
                  HGLOBAL hGlobal;
                  LPWSTR lpszText;

                  hGlobal = GetClipboardData (CF_UNICODETEXT);
                  lpszText = GlobalLock (hGlobal);
                  for (i = 0; lpszText[i] != '\0'; i++)
                    {
                      printf ("%04x", lpszText[i]);
                      if (lpszText[i + 1] != '\0')
                        putchar (' ');
                    }
                  puts ("\n");
                  GlobalUnlock (hGlobal);
                }
              CloseClipboard ();
              return 0;
          }
        break;
      case WM_DESTROY:
        PostQuitMessage (0);
        return 0;
    }
  return DefWindowProc (hWnd, uMsg, wParam, lParam);
}


int
main (int   argc,
      char *argv[])
{
  HMENU hMenu, hPopup;
  HWND hWnd;
  MSG msg;
  WNDCLASSEX wcex;

  hPopup = CreatePopupMenu ();
  InsertMenu (hPopup, 0, MF_BYPOSITION | MF_STRING,
                                                CM_COPY, _T("Copy (Win32)"));
  InsertMenu (hPopup, 1, MF_BYPOSITION | MF_STRING,
                                                CM_PASTE, _T("Paste (Win32)"));
  hMenu = CreateMenu ();
  InsertMenu (hMenu, 0, MF_BYPOSITION | MF_STRING | MF_POPUP,
                                                hPopup, _T("Edit"));
  ZeroMemory (&wcex, sizeof (WNDCLASSEX));
  wcex.cbSize        = sizeof (WNDCLASSEX);
  wcex.lpfnWndProc   = WndProc;
  wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
  wcex.lpszClassName = _T("CBW32");
  RegisterClassEx (&wcex);
  hWnd = CreateWindow (_T("CBW32"), NULL, WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, hMenu, NULL, NULL);
  ShowWindow (hWnd, SW_SHOWDEFAULT);
  UpdateWindow (hWnd);
  while (GetMessage (&msg, NULL, 0, 0))
    {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
    }
  return 0;
}