#include <gtk/gtk.h>


enum
{
  TARGET_STRING,
  TARGET_TEXT,
  TARGET_COMPOUND_TEXT,
  TARGET_UTF8
};


static GdkAtom atom_utf8;


void
window_selection_get (GtkWidget        *widget,
                      GtkSelectionData *data,
                      guint             info,
                      guint             time,
                      gpointer          user_data)
{
  if (data->selection == GDK_SELECTION_CLIPBOARD)
    gtk_selection_data_set_text (data,
                    g_object_get_data (G_OBJECT (widget), "user_data"), -1);
}


void
window_selection_received (GtkWidget        *widget,
                           GtkSelectionData *data,
                           guint             time,
                           gpointer          user_data)
{
  gchar *text;

  if (data->selection == GDK_SELECTION_CLIPBOARD
                                && (text = gtk_selection_data_get_text (data)))
    {
      gint i;

      for (i = 0; text[i] != '\0'; i++)
        {
          g_print ("%02x", (guchar)text[i]);
          if (text[i + 1] != '\0')
            g_print (" ");
        }
      g_print ("\n\n");
      g_free (text);
    }

}


void
menu_item_activate_copy (GtkMenuItem *menu_item,
                         GtkWidget   *window)
{
  g_object_set_data (G_OBJECT (window), "user_data",
                        g_object_get_data (G_OBJECT (menu_item), "user_data"));
  gtk_selection_owner_set (window, GDK_SELECTION_CLIPBOARD, GDK_CURRENT_TIME);
}


void
menu_item_activate_paste (GtkMenuItem *menu_item,
                          GtkWidget   *window)
{
  gtk_selection_convert (window, GDK_SELECTION_CLIPBOARD, atom_utf8,
                                                            GDK_CURRENT_TIME);
}


int
main (int   argc,
      char *argv[])
{
  GtkTargetEntry targets[4] = {
    {"STRING",        0, TARGET_STRING},
    {"TEXT",          0, TARGET_TEXT}, 
    {"COMPOUND_TEXT", 0, TARGET_COMPOUND_TEXT},
    {"UTF8_STRING",   0, TARGET_UTF8}};
  GtkWidget *menu_bar, *menu_pop, *menu_item, *window;

  gtk_init (&argc, &argv);

  atom_utf8 = gdk_atom_intern ("UTF8_STRING", FALSE);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_realize (window);
  gtk_selection_add_targets (window, GDK_SELECTION_CLIPBOARD, targets, 4);
  g_signal_connect (G_OBJECT (window), "selection-clear-event",
                                G_CALLBACK (gtk_true), NULL);
  g_signal_connect (G_OBJECT (window), "selection-get",
                                G_CALLBACK (window_selection_get), NULL);
  g_signal_connect (G_OBJECT (window), "selection-received",
                                G_CALLBACK (window_selection_received), NULL);
  g_signal_connect (G_OBJECT (window), "destroy",
                                G_CALLBACK (gtk_main_quit), NULL);

  menu_bar = gtk_menu_bar_new ();
  gtk_container_add (GTK_CONTAINER (window), menu_bar);

  menu_pop = gtk_menu_new ();

  menu_item = gtk_menu_item_new_with_label ("Edit");
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_item), menu_pop);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_bar), menu_item);

  menu_item = gtk_menu_item_new_with_label ("Copy (LF)");
  g_signal_connect (G_OBJECT (menu_item), "activate",
                                G_CALLBACK (menu_item_activate_copy), window);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_pop), menu_item);
  g_object_set_data (G_OBJECT (menu_item), "user_data",
                                        "Test String From GTK+ (LF)\n");

  menu_item = gtk_menu_item_new_with_label ("Copy (CRLF)");
  g_signal_connect (G_OBJECT (menu_item), "activate",
                                G_CALLBACK (menu_item_activate_copy), window);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_pop), menu_item);
  g_object_set_data (G_OBJECT (menu_item), "user_data",
                                        "Test String From GTK+ (CRLF)\r\n");

  menu_item = gtk_menu_item_new_with_label ("Copy Japanese (LF)");
  g_signal_connect (G_OBJECT (menu_item), "activate",
                                G_CALLBACK (menu_item_activate_copy), window);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_pop), menu_item);
  g_object_set_data (G_OBJECT (menu_item), "user_data",
                    "Test String From GTK+ (LF)\n"
                    "\xe5\xb2\xa9\xe6\x9c\xac\xe4\xb8\x80\xe6\xa8\xb9\n");

  menu_item = gtk_menu_item_new_with_label ("Copy Japanese (CRLF)");
  g_signal_connect (G_OBJECT (menu_item), "activate",
                                G_CALLBACK (menu_item_activate_copy), window);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_pop), menu_item);
  g_object_set_data (G_OBJECT (menu_item), "user_data",
                    "Test String From GTK+ (CRLF)\r\n"
                    "\xe5\xb2\xa9\xe6\x9c\xac\xe4\xb8\x80\xe6\xa8\xb9\r\n");

  menu_item = gtk_menu_item_new_with_label ("Paste (GTK+)");
  g_signal_connect (G_OBJECT (menu_item), "activate",
                                G_CALLBACK (menu_item_activate_paste), window);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_pop), menu_item);

  gtk_widget_show_all (window);

  gtk_main ();

  return 0;
}
