/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * The DrawingArea widget is used for creating custom user interface elements.
 * It's essentially a blank widget you can draw on.
 */
public class DrawingArea extends Widget {
    public DrawingArea() {
        super(gtk_drawing_area_new());
    }

    /**
     * Construct a DrawingArea using a handle to a native resource.
     */
    public DrawingArea(Handle handle) {
        super(handle);
    }

    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    public static DrawingArea getDrawingArea(Handle handle) {
        if (handle == null) {
            return null;
        }

        DrawingArea obj = (DrawingArea) GObject.getGObjectFromHandle(handle);

        if (obj == null) {
            obj = new DrawingArea(handle);
        }

        return obj;
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gtk_drawing_area_get_type());
    }

    native static final protected int gtk_drawing_area_get_type();

    native static final protected Handle gtk_drawing_area_new();

    /*
     * Deprecated functions. native static final private void
     * gtk_drawing_area_size(Handle darea, int width, int height);
     */
}
