/*
 * =====================================================================================
 * 
 *        Filename:  selector.c
 * 
 *     Description:  e_source_selector demo 
 * 
 *         Version:  1.0
 *         Created:  02/13/06 13:01:57 CST
 *        Revision:  none
 *        Compiler:  gcc
 * 
 *          Author:  Boby.Wolf (BW), boby.wolf@sun.com
 *         Company:  ERI Of Sun, China
 * 
 * =====================================================================================
 */

#include "treeitem.h"


static GtkTreeModel *model1 = NULL;

static GtkTreeModel *
create_model (void)
{
	GtkTreeStore *model;
	GtkTreeIter iter;
	GtkTreeIter child_iter;
	GObject *calendar[6];
	calendar[0] = tree_item_new ("On This Computer", FALSE, FALSE, FALSE);
	calendar[1] = tree_item_new ("Personal", TRUE, TRUE, TRUE);
	calendar[2] = tree_item_new ("On The Web", FALSE, FALSE, FALSE);
	calendar[3] = tree_item_new ("Contacts", FALSE, FALSE, FALSE);
	calendar[4] = tree_item_new ("Birthday & Anniversaries", FALSE, TRUE, FALSE);
	calendar[5] = tree_item_new ("Weather", FALSE, FALSE, FALSE);

	/* create tree store */
	model = gtk_tree_store_new (1, G_TYPE_OBJECT);

	/* number 1 */
	gtk_tree_store_append (model, &iter, NULL);
	gtk_tree_store_set (model, &iter, 0, calendar[0], -1);
	gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0, calendar[1], -1);

	/* number 2 */
	gtk_tree_store_append (model, &iter, NULL);
	gtk_tree_store_set (model, &iter, 0, calendar[2], -1);

	/* number 3 */
	gtk_tree_store_append (model, &iter, NULL);
	gtk_tree_store_set (model, &iter, 0, calendar[3], -1);
	gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0, calendar[4], -1);

	/* number 4 */
	gtk_tree_store_append (model, &iter, NULL);
	gtk_tree_store_set (model, &iter, 0, calendar[5], -1);

	return GTK_TREE_MODEL (model);
}

static void
item_toggled (GtkCellRendererToggle *cell,
				gchar *path_str,
				gpointer data1)
{
	GtkTreeModel *model = (GtkTreeModel *)model1;
	GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
	GtkTreeIter iter;
	TreeItem *item;
	
	void* data;

	if (! gtk_tree_model_get_iter (model, &iter, path)) {
		gtk_tree_path_free (path);
		return;
	}

	gtk_tree_model_get (model, &iter, 0, &data, -1);
	g_assert (E_IS_TREE_ITEM (data));
	item = E_TREE_ITEM (data);

	tree_item_set_toggle (item);
	gtk_tree_model_row_changed (model, path, &iter);
	
	/* clean up */
	gtk_tree_path_free (path);

	g_object_unref (data);
}

static void
pixbuf_cell_data_func (GtkTreeViewColumn *column,
		GtkCellRenderer *renderer,
		GtkTreeModel *model,
		GtkTreeIter *iter,
		gpointer data1)
{
	void* data;
	guint32 color = 0xFF0000FF;
	GdkPixbuf* pixbuf = NULL;
	TreeItem *item;

	gtk_tree_model_get (model, iter, 0, &data, -1);
	g_assert (E_IS_TREE_ITEM (data));
	item = E_TREE_ITEM (data);

	if (tree_item_have_image (item))
	{
		pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 16, 16);
		gdk_pixbuf_fill (pixbuf, color);

		g_object_set (renderer,
				"visible", pixbuf != NULL,
				"pixbuf", pixbuf,
				NULL);

		if (pixbuf)
			g_object_unref (pixbuf);
	}
	else g_object_set (renderer, "visible", FALSE, NULL);
	g_object_unref (data);
}

static void
toggle_cell_data_func (GtkTreeViewColumn *column,
		GtkCellRenderer *renderer,
		GtkTreeModel *model,
		GtkTreeIter *iter,
		gpointer data1)
{
	void* data;
	TreeItem* item;

	gtk_tree_model_get (model, iter, 0, &data, -1);
	g_assert (E_IS_TREE_ITEM (data));
	item = E_TREE_ITEM (data);

	if (tree_item_check_visible (item))
	{
		g_object_set (renderer, "visible", TRUE, NULL);
		if (tree_item_toggle_last (item))
			g_object_set (renderer, "active", TRUE, NULL);
		else
			g_object_set (renderer, "active", FALSE, NULL);
	}
	else g_object_set (renderer, "visible", FALSE, NULL);
	g_object_unref (data);
}

static void
text_cell_data_func (GtkTreeViewColumn *column,
		GtkCellRenderer *renderer,
		GtkTreeModel *model,
		GtkTreeIter *iter,
		gpointer data1)
{
	void* data;
	TreeItem* item;
	gtk_tree_model_get (model, iter, 0, &data, -1);
	g_assert (E_IS_TREE_ITEM (data));
	item = E_TREE_ITEM (data);

	const char* label = tree_item_get_label (item);
	if (label)
	{
		if ( !tree_item_have_image (item) && !tree_item_check_visible (item))
			g_object_set (renderer,
					"text", label,
					"weight", PANGO_WEIGHT_BOLD,
					"foreground_set", FALSE,
					NULL);
		else
			g_object_set (renderer,
					"text", label,
					"weight", PANGO_WEIGHT_NORMAL,
					"foreground_set", FALSE,
					NULL);
	}
	else
		g_object_set (renderer,
				"text", "Boby.Wolf",
				"weight", PANGO_WEIGHT_NORMAL,
				"foreground_set", FALSE,
				NULL);
	g_object_unref (data);
}

static void
add_columns (GtkTreeView *treeview)
{
	GtkTreeViewColumn *column;
	GtkCellRenderer *cell_renderer;
	
	column = gtk_tree_view_column_new ();
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	cell_renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (G_OBJECT (cell_renderer), "mode", GTK_CELL_RENDERER_MODE_ACTIVATABLE, NULL);
	gtk_tree_view_column_pack_start (column, cell_renderer, FALSE);
	gtk_tree_view_column_set_cell_data_func (column, cell_renderer,
			(GtkTreeCellDataFunc) pixbuf_cell_data_func, NULL, NULL);

	cell_renderer = gtk_cell_renderer_toggle_new ();
	gtk_tree_view_column_pack_start (column, cell_renderer, FALSE);
	gtk_tree_view_column_set_cell_data_func (column, cell_renderer,
			(GtkTreeCellDataFunc) toggle_cell_data_func, NULL, NULL);
	g_signal_connect (cell_renderer, "toggled", G_CALLBACK (item_toggled), NULL);

	cell_renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (column, cell_renderer, FALSE);
	gtk_tree_view_column_set_cell_data_func (column, cell_renderer,
			(GtkTreeCellDataFunc) text_cell_data_func, NULL, NULL);

	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview), FALSE);
}

gint delete_event (GtkWidget *widget,
				GdkEvent *event,
				gpointer data)
{
	gtk_main_quit();
	return FALSE;
}

int main (int argc, char* argv[])
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *sw;
	GtkWidget *treeview;

	gtk_init (&argc, &argv);

	/* create window, etc */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window), "e_source_selector demo");
	g_signal_connect (window, "delete_event",
			G_CALLBACK (delete_event), &window);

	vbox = gtk_vbox_new (FALSE, 8);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 8);
	gtk_container_add (GTK_CONTAINER (window), vbox);

	gtk_box_pack_start (GTK_BOX (vbox),
			gtk_label_new ("Boby's selector area"),
			FALSE, FALSE, 0);

	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
			GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
			GTK_POLICY_AUTOMATIC,
			GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);

	/* create model */
	model1 = create_model ();

	/* create tree view */
	treeview = gtk_tree_view_new_with_model (model1);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
	gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)),
			GTK_SELECTION_MULTIPLE);

	add_columns (GTK_TREE_VIEW (treeview));

	g_object_unref (model1);

	gtk_container_add (GTK_CONTAINER (sw), treeview);

	/* expand all rows after the treeview widget has been realized */
	g_signal_connect (treeview, "realize",
			G_CALLBACK (gtk_tree_view_expand_all), NULL);
	gtk_window_set_default_size (GTK_WINDOW (window), 650, 400);

	gtk_widget_show_all (window);
	gtk_main ();

	return 0;
}

