#ifndef TREE_ITEM_H_
#define TREE_ITEM_H_

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define E_TYPE_TREE_ITEM (tree_item_get_type())
#define E_TREE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), E_TYPE_TREE_ITEM, TreeItem))
#define E_TREE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), E_TYPE_TREE_ITEM, TreeItemClass))
#define E_IS_TREE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E_TYPE_TREE_ITEM))
#define E_IS_TREE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((kclass), E_TYPE_TREE_ITEM))

typedef struct _TreeItem TreeItem;
typedef struct _TreeItemPrivate TreeItemPrivate;
typedef struct _TreeItemClass TreeItemClass;

struct _TreeItem {
	GObject parent;

	TreeItemPrivate *priv;
};

struct _TreeItemClass {
	GObjectClass parent_class;
};

GType tree_item_get_type (void);
GObject* tree_item_new (const gchar*, gboolean, gboolean, gboolean);

const gchar* tree_item_get_label (TreeItem *);
gboolean tree_item_have_image (TreeItem *);
gboolean tree_item_check_visible (TreeItem *);
gboolean tree_item_toggle_last (TreeItem *);
void tree_item_set_toggle (TreeItem*);
#endif
