<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:param name="object">undefined</xsl:param>
<xsl:param name="host">undefined</xsl:param>
<xsl:param name="user_id">undefined</xsl:param>
<xsl:param name="user_name">undefined</xsl:param>
<xsl:param name="selection">undefined</xsl:param>
<xsl:param name="port_http">undefined</xsl:param>
<xsl:param name="port_ftp">undefined</xsl:param>
<xsl:param name="prev">undefined</xsl:param>
<xsl:param name="active">7255</xsl:param>
<xsl:param name="client">undefined</xsl:param>
<xsl:param name="domain"/>

<xsl:output method="html" encoding="iso-8859-1"/>

<xsl:variable name="AnnDesc">
<xsl:if test="/Object/@type='Messageboard'">Message</xsl:if>
<xsl:if test="/Object/@type!='Messageboard'">Annotation</xsl:if>
</xsl:variable>

<xsl:template match="Object">
<HTML>
<HEAD>
<SCRIPT LANGUAGE="JavaScript" SRC="/gui_js/main.js" TYPE="text/javascript"/>
<SCRIPT LANGUAGE="JavaScript" SRC="/gui_js/annotations.js" TYPE="text/javascript"/>
    <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1"/>
    <META http-equiv="expires" content="0"/>
	<TITLE>sTeam cooperative learning</TITLE>
    <xsl:call-template name="browsercss"/>
</HEAD>
<BODY CLASS="subdialogue" BGCOLOR="#FFFFFF" LINK="#000000" VLINK="#000000" ALINK="#000000">

<FORM name="browser" action="browser.pike" ENCTYPE="multipart/form-data" METHOD="POST">
<INPUT type="hidden" name="id" value="{$object}"/>
<INPUT type="hidden" name="active" value="{$active}"/>
<INPUT type="hidden" name="_action" value="annotation"/>
<INPUT type="hidden" name="treenodes" value=""/>
<INPUT type="hidden" name="type" value="annotations"/>
<INPUT type="hidden" name="todelete" value=""/>

<TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="770" ALIGN="CENTER" CLASS="bginfotext">
<TR VALIGN="TOP"><TD><BR/><BR/>&#160;&lt;&lt; back to 

<xsl:choose>
<xsl:when test="/Object/@type='Messageboard'">
<A href="navigate.pike?object={environment/object/id}"><xsl:value-of select="environment/object/name"/></A><BR/><BR/><BR/><SPAN CLASS="text2bb">&#160;Messages in forum '<xsl:value-of select="name"/>'</SPAN>
</xsl:when>
<xsl:when test="/Object/@type='Document'">
<A href="navigate.pike?object={environment/object/id}">
<xsl:value-of select="environment/object/name"/></A><BR/><BR/><BR/><SPAN CLASS="text2bb">&#160;Annotations for <A href="get.pike?object={id}"><xsl:value-of select="name"/></A></SPAN>
</xsl:when>
<xsl:when test="/Object/@type='Room'">
<A href="navigate.pike?object={id}"><xsl:value-of select="name"/></A><BR/><BR/><BR/><SPAN CLASS="text2bb">&#160;Annotations for <xsl:value-of select="name"/></SPAN>
</xsl:when>
<xsl:otherwise>
<A href="navigate.pike?object={environment/object/id}"><xsl:value-of select="environment/object/name"/></A><BR/><BR/><BR/><SPAN CLASS="text2bb">&#160;Annotations for <xsl:value-of select="name"/></SPAN>
</xsl:otherwise>
</xsl:choose>

<BR/><BR/></TD></TR>
</TABLE>

<TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="770" ALIGN="CENTER" CLASS="bgbrowser">
<TR VALIGN="BOTTOM" CLASS="tabhead"><TD CLASS="header" WIDTH="470"><BR/>Entries</TD><TD WIDTH="10">&#160;&#160;</TD><TD CLASS="header" WIDTH="250">Add/Delete your <xsl:value-of select="$AnnDesc"/></TD></TR>
<xsl:apply-templates select="annotations"/>
</TABLE>
</FORM>
</BODY>
</HTML>
</xsl:template>

<xsl:template match="thread">
<script language="javascript">
<xsl:if test="position()=last()">
indent_last(<xsl:value-of select="depth"/>);
</xsl:if>
<xsl:if test="position()!=last()">
indent_list(<xsl:value-of select="depth"/>);
</xsl:if>
</script>
<xsl:if test="id=$active"><IMG src="/images/treenode_collapse.gif" width="13" height="13" border="0" vspace="2" alt="annotation showed" align="left"/>&#160;<B><xsl:value-of select="subject"/></B>
</xsl:if>
<xsl:if test="id!=$active"><a href="navigate.pike?object={$object}&amp;type=annotations&amp;active={id}"><IMG src="/images/treenode_expand.gif" width="13" height="13" alt="expand tree / annotation" border="0" vspace="2" align="left"/></a>&#160;<a href="navigate.pike?object={$object}&amp;type=annotations&amp;active={id}"><xsl:value-of select="subject"/></a></xsl:if>&#160;(by <I><a href="JavaScript:open_userdetails('{author/object/id}')"><xsl:value-of select="author/object/name"/></a></I>
<xsl:if test="read=0"> *</xsl:if>)<BR CLEAR="ALL"/>
<xsl:apply-templates select="thread"/>
</xsl:template>


<xsl:template match="annotations" name="annotations">
<xsl:variable name="annonsubject">
re: <xsl:value-of select="/Object/annotations/Object[id=$active]/name"/>
</xsl:variable>

<TR VALIGN="TOP"><TD>
<xsl:if test="@size!=0">
  <xsl:for-each select="Object">
      <xsl:if test="$active=id"><TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%" class="bgbrowser2">
<TR VALIGN="TOP"><TD WIDTH="62"><BR/><A HREF="JavaScript:open_userdetails('{modified-by/object/id}')"><IMG SRC="get.pike?object={modified-by/object/id}" WIDTH="60" HEIGHT="70" ALT="{modified-by/object/name}" BORDER="1" HSPACE="1"/></A><BR/><BR/><BR/></TD><TD WIDTH="5">&#160;</TD><TD WIDTH="403"><BR/><B><xsl:value-of select="name"/></B><BR/>by <A HREF="navigate.pike?object={modified-by/object/id}"><xsl:value-of select="modified-by/object/name"/></A> on <xsl:value-of select="last-modified/date"/><BR CLEAR="ALL"/><BR/>
	<xsl:choose>
	<xsl:when test="content/mime-type='text/plain'">	
	      <xsl:value-of select="/Object/active-content"/>
	</xsl:when>
	<xsl:when test="content/mime-type='text/html'">
              <xsl:value-of select="/Object/active-content" disable-output-escaping="yes"/>
	</xsl:when>
        <xsl:otherwise>
              <A href="get.pike?object={id}">Download Attachement</A>
	</xsl:otherwise>
	</xsl:choose>
      <BR/><BR/><BR/></TD></TR>

<xsl:if test="not(/Object/user/id=/Object/owner/object/id or owner/object/id=/Object/user/id)">
ERROR!!!!!!<BR/><BR/>
ERROR!!!
ERROR!!
THIS SHOULD NOT HAPPEN BECAUSE:
<xsl:value-of select="owner/object/id"/>:<xsl:value-of select="/Object/user/id"/>
----------------------------------------------------------------------
</xsl:if>
</TABLE>
</xsl:if>
</xsl:for-each>
<HR NOSHADE="true" WIDTH="100%"/><SPAN CLASS="text1sb"><B><xsl:value-of select="$AnnDesc"/>-Thread:</B></SPAN>&#160;<SPAN CLASS="text0sc">(* marks an unread message)<BR/></SPAN>
<SPAN CLASS="text1sb"><xsl:apply-templates select="thread"/></SPAN>
<BR/><BR/>
</xsl:if>

<xsl:if test="@size=0">
<CENTER><BR/><B>There are no <xsl:value-of select="$AnnDesc"/>s yet. Feel free to write one.</B></CENTER>
</xsl:if>
</TD>
<TD class="bgbrowser2">&#160;</TD>
<xsl:choose>
<xsl:when test="parent::Object/annotateable/@user='false'">
<TD><BR/><B>Sorry, but you have no permission<BR/>to annotate this object!<BR/>But you can always read any message.</B></TD>
</xsl:when>
<xsl:otherwise>
<TD class="bgbrowser2"><BR/><B>Subject:</B><BR/>
<xsl:if test="@size!=0">
<INPUT TYPE="TEXT" NAME="annottitel" SIZE="30" MAXLENGTH="30" VALUE="{$annonsubject}" CLASS="formtext"/><BR/>as <INPUT type="RADIO" name="annottype" value="1" checked="true"/>reply&#160;&#160;<INPUT type="RADIO" name="annottype" value="0"/>
</xsl:if>
<xsl:if test="@size=0">
<INPUT TYPE="TEXT" NAME="annottitel" SIZE="30" MAXLENGTH="30" CLASS="formtext"/><BR/>as <INPUT type="RADIO" name="annottype" value="0" checked="true"/>
</xsl:if>new thread<BR/><BR/><SPAN CLASS="text1sb"><B><xsl:value-of select="$AnnDesc"/>:</B><BR/></SPAN>(<SPAN CLASS="text0sc">HTML: please enter well-formed tags)<BR/></SPAN><SPAN CLASS="formtext"><TEXTAREA NAME="annotbody" ROWS="6" COLS="29" WRAP="VIRTUAL" CLASS="formtext"></TEXTAREA></SPAN><BR/><BR/><SPAN CLASS="text1sb"><B>Attachement:</B><BR/></SPAN><SPAN CLASS="text0sc">(e.g. Audio, Video, Image)<BR/></SPAN><INPUT TYPE="FILE" NAME="annotfile" SIZE="14" CLASS="formtext"/><BR/><BR/><BR/><INPUT TYPE="BUTTON" VALUE="&#160;&#160;Add {$AnnDesc}&#160;&#160;" OnClick="check_annot(this.form)"/><BR/><BR/><BR/></TD>
</xsl:otherwise>
</xsl:choose>
</TR>
</xsl:template>

<xsl:template match="text() | @*">
<xsl:copy><xsl:apply-templates /></xsl:copy>
</xsl:template>

<xsl:template match="TABLE | TR | TD | SELECT | OPTION | MAP | AREA | A | a | BR">
  <xsl:copy><xsl:apply-templates select="@* | * | text()"/></xsl:copy>
</xsl:template>

</xsl:stylesheet>

