<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >

<xsl:template match="/">
  <xsl:apply-templates select="//author"/>
</xsl:template>

<xsl:template match="author">
<xsl:variable name="name">
  <xsl:call-template name="mysql-escape-string">
    <xsl:with-param  name="unescaped" select="@name"/>
  </xsl:call-template>
</xsl:variable>
</xsl:template>

<xsl:template name="mysql-escape-string">
  <xsl:param name="unescaped"/>
  <xsl:variable name="escaper">
    <xsl:choose>
      <xsl:when test='contains($unescaped, "something")'>
        <xsl:value-of select='string("something")'/>
      </xsl:when>
    </xsl:choose>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="$escaper">
      <xsl:message>n<xsl:value-of select="string-length($escaper)"/>n</xsl:message>

      <xsl:variable name="aescape">
      <xsl:call-template name="mysql-escape-string">
        <xsl:with-param name="unescaped">
          <xsl:value-of select='substring-after($unescaped, $escaper)'/>
        </xsl:with-param>
      </xsl:call-template>
      </xsl:variable>

    </xsl:when>
    <xsl:otherwise>
      <xsl:message>z<xsl:value-of select="$unescaped"/>z</xsl:message>
      <xsl:value-of select="$unescaped"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>