#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>


static void
get_lines (GtkTextView  *text_view,
           gint          first_y,
           gint          last_y,
           GArray       *buffer_coords,
           GArray       *numbers,
           gint         *countp)
{
  GtkTextIter iter;
  gint count;
  gint size;

  g_array_set_size (buffer_coords, 0);
  g_array_set_size (numbers, 0);

  /* Get iter at first y */
  gtk_text_view_get_line_at_y (text_view, &iter, first_y, NULL);

  /* For each iter, get its location and add it to the arrays.
   * Stop when we pass last_y
   */
  count = 0;
  size = 0;

  while (!gtk_text_iter_is_end (&iter))
    {
      gint y, height;
      gint line_num;

      gtk_text_view_get_line_yrange (text_view, &iter, &y, &height);

      g_array_append_val (buffer_coords, y);
      line_num = gtk_text_iter_get_line (&iter);
      g_array_append_val (numbers, line_num);

      ++count;

      if ((y + height) >= last_y)
        break;

      gtk_text_iter_forward_line (&iter);
    }
  *countp = count;
}

static gint
line_numbers_expose (GtkWidget      *widget,
                     GdkEventExpose *event,
                     gpointer        user_data)
{
  gint count;
  GArray *numbers;
  GArray *pixels;
  gint first_y;
  gint last_y;
  gint i;
  GdkWindow *left_win;
  GdkWindow *right_win;
  PangoLayout *layout;
  GtkTextView *text_view;
  GtkTextWindowType type;
  GdkDrawable *target;

  text_view = GTK_TEXT_VIEW (widget);


  /* See if this expose is on the line numbers window */
  left_win = gtk_text_view_get_window (text_view,
                                       GTK_TEXT_WINDOW_LEFT);

  right_win = gtk_text_view_get_window (text_view,
                                        GTK_TEXT_WINDOW_RIGHT);

  if (event->window == left_win)
    {

      type = GTK_TEXT_WINDOW_RIGHT;
      target = right_win;
    }
  else
    return FALSE;

  first_y = event->area.y;
  last_y = first_y + event->area.height;

  gtk_text_view_window_to_buffer_coords (text_view,
                                         type,
                                         0,
                                         first_y,
                                         NULL,
                                         &first_y);

  gtk_text_view_window_to_buffer_coords (text_view,
                                         type,
                                         0,
                                         last_y,
                                         NULL,
                                         &last_y);

  numbers = g_array_new (FALSE, FALSE, sizeof (gint));
  pixels = g_array_new (FALSE, FALSE, sizeof (gint));

  get_lines (text_view,
             first_y,
             last_y,
             pixels,
             numbers,
             &count);

  /* Draw fully internationalized numbers! */

  layout = gtk_widget_create_pango_layout (widget, "");

  i = 0;
  while (i < count)
    {
      gint pos;
      gchar *str;


gtk_text_view_buffer_to_window_coords (text_view,
                                             type,
                                             0,
                                             g_array_index (pixels, gint, i),
                                             NULL,
                                             &pos);

      str = g_strdup_printf ("%d", g_array_index (numbers, gint, i));

      pango_layout_set_text (layout, str, -1);

      gtk_paint_layout (widget->style,
                        target,
                        GTK_WIDGET_STATE (widget),
                        FALSE,
                        NULL,
                        widget,
                        NULL,
                        2, pos + 2,
                        layout);

      g_free (str);

      ++i;
    }

  g_array_free (pixels, TRUE);
  g_array_free (numbers, TRUE);

  g_object_unref (layout);

  /* don't stop emission, need to draw children */
  return FALSE;
}

int main(int argc, char **argv)
{
 GtkWidget *window;
 GtkWidget *sv;
 GtkWidget *sw;
 PangoFontDescription *pfd;
 gtk_init(&argc, &argv);

 window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (window, 500,500);
 gtk_window_set_title (GTK_WINDOW(window), "test sourceview window");
 sv = gtk_text_view_new();
 pfd = pango_font_description_from_string("1Courier 8");
 gtk_widget_modify_font (sv, pfd);


  gtk_text_view_set_border_window_size (GTK_TEXT_VIEW (sv),
                                        GTK_TEXT_WINDOW_RIGHT,
                                        30);

  gtk_text_view_set_border_window_size (GTK_TEXT_VIEW (sv),
                                        GTK_TEXT_WINDOW_LEFT,
                                        30);


  g_signal_connect (sv,
                    "expose_event",
                    G_CALLBACK (line_numbers_expose),
                    NULL);

 // gtk_source_view_set_show_line_numbers (GTK_SOURCE_VIEW(sv), TRUE);

 sw = gtk_scrolled_window_new (NULL, NULL);
 gtk_container_add (GTK_CONTAINER(window), sw);
 gtk_container_add (GTK_CONTAINER(sw), sv);
 gtk_widget_show_all (window);
 pango_font_description_free (pfd);

 gtk_main();
return 0;
}



