// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// This Softwar shows a icon in your notification area when desktop is
// viewable or remotable without prompt or authentication
// 12.06.2005 by Sven Jaborek

// complilation:
// mcs -pkg:gtk-sharp -pkg:gconf-sharp TrayLib.cs VinoTray.cs -out:VinoTray.exe

using Gtk;
using System;
using GConf;
 
public class VinoTray
{
	// gconf keys we use
	static string REMOTE_ENABLED = "/desktop/gnome/remote_access/enabled";
	static string VIEW_ONLY = "/desktop/gnome/remote_access/view_only";
	static string PROMPT = "/desktop/gnome/remote_access/prompt_enabled";
	static string AUTH_METHOD = "/desktop/gnome/remote_access/authentication_methods";
	static GConf.Client gconfClient;
	static Egg.TrayIcon icon;
	static EventBox eb;
		
	public static void Main()
	{
		// initialises the application
		Application.Init();
		// creates the tray icon
		VinoTray test = new VinoTray();
		// runs application
		Application.Run();
		
	}
 
	public VinoTray()
	{	
		// opening a gconf client
		gconfClient = new GConf.Client ();
		
		gconfClient.AddNotify(REMOTE_ENABLED, new GConf.NotifyEventHandler(OnGConfkeychanged1));
		gconfClient.AddNotify(VIEW_ONLY, new GConf.NotifyEventHandler(OnGConfkeychanged2));
		gconfClient.AddNotify(PROMPT, new GConf.NotifyEventHandler(OnGConfkeychanged3));
		gconfClient.AddNotify(AUTH_METHOD, new GConf.NotifyEventHandler(OnGConfkeychanged4));
		
		icon = new Egg.TrayIcon("VinoTray");
				
		// showing the trayicon
		SetIcon();
	}
	
	/* Receive the Remote Desktop Status From GConf
	return 0 means Desktop is not remotable
	return 1 means Desktop is open viewable
	return 2 means Desktop is open remotable */
	private int GetRemoteStatus()
	{		
		bool gconfKeyRemoteEnabled_value = true;
		bool gconfKeyRemoteViewOnly_value = false;
		bool gconfKeyRemotePrompt_value = false;
		// no auth is "none" and that means we are false
		bool bGconfKeyRemoteAuthMethod = true; 
		string[] gconfAuth;
		
		// receiving values from the gconf
		try
		{			
			gconfKeyRemoteEnabled_value=(bool) gconfClient.Get (REMOTE_ENABLED);
			gconfKeyRemoteViewOnly_value=(bool) gconfClient.Get (VIEW_ONLY);
			gconfKeyRemotePrompt_value=(bool) gconfClient.Get (PROMPT);
			gconfAuth=(string[] )gconfClient.Get (AUTH_METHOD);
			if(gconfAuth[0]=="none") bGconfKeyRemoteAuthMethod = false;
		}
		catch (GConf.NoSuchKeyException)
		{
			  Console.WriteLine("no such key");
		}
		
		if(	gconfKeyRemoteEnabled_value &&  
			!gconfKeyRemotePrompt_value &&
			!bGconfKeyRemoteAuthMethod && 
			gconfKeyRemoteViewOnly_value ) return 1;		
		else if ( 	
			gconfKeyRemoteEnabled_value &&  
			!gconfKeyRemotePrompt_value &&
			!bGconfKeyRemoteAuthMethod &&
			!gconfKeyRemoteViewOnly_value ) return 2;
		else return 0;
	}
	
	private void OnImageClick (object o, ButtonPressEventArgs args) // handler for mouse click
	{
   		if (args.Event.Button == 3) //right click
   		 {
      		Menu popupMenu = new Menu(); // creates the menu  
                // creates a menu item with no image as default
      		ImageMenuItem menuPopup1 = new ImageMenuItem ("Quit");
                // creates a image for the menu item
      		Image appimg = new Image(Stock.Quit, IconSize.Menu);
      		menuPopup1.Image = appimg; // sets the menu item's image
      		popupMenu.Add(menuPopup1); // adds the menu item to the menu
                // hooks a event when the user clicks the icon
      		menuPopup1.Activated += new EventHandler(this.OnPopupClick);
		popupMenu.ShowAll(); // shows everything
                // pops up the actual menu when the user right clicks
      		popupMenu.Popup(null, null, null, IntPtr.Zero, args.Event.Button, args.Event.Time);
   		}
	}
	private void OnPopupClick(object o, EventArgs args)
	{
		Application.Quit(); // quits the application when the users clicks the popup menu
	}
	
	private void OnGConfkeychanged1(object o, NotifyEventArgs args){
		SetIcon();
	}

	private void OnGConfkeychanged2(object o, NotifyEventArgs args){
		SetIcon();
	}

	private void OnGConfkeychanged3(object o, NotifyEventArgs args){
		SetIcon();
	}

	private void OnGConfkeychanged4(object o, NotifyEventArgs args){
		SetIcon();
	}
	
	private void SetIcon(){
		int st = (int) GetRemoteStatus();
		
		if(st==1) {
			if(eb!=null) icon.Remove(eb);
			eb = new EventBox();
			eb.Add(new Image("/usr/share/pixmaps/desk_viewable.png"));
			eb.ButtonPressEvent += new ButtonPressEventHandler (this.OnImageClick);
			icon.Add(eb);		
			icon.ShowAll();
		}	
		if(st==2) {
			if(eb!=null) icon.Remove(eb);
			eb = new EventBox();
			eb.Add(new Image("/usr/share/pixmaps/desk_remotable.png"));
			eb.ButtonPressEvent += new ButtonPressEventHandler (this.OnImageClick);
			icon.Add(eb);		
			icon.ShowAll();
		}	
		if(st==0) icon.Hide();
	
	}

}