using System;
using System.Runtime.InteropServices;
using System.Collections;
public class Tag
{
   IntPtr raw;
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_load (string filename);
   public Tag (string filename)
   {
      raw = tag_data_load (filename);
      if (raw == IntPtr.Zero)
         throw new Exception ("File could not be opened.");
   }
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_free (IntPtr tag);
   ~Tag ()
   {
      tag_data_free (raw);
   }
   
   [DllImport ("libmuinetagger")]
      private static extern bool tag_data_save (IntPtr tag);
   public bool Save ()
   {
      return tag_data_save (raw);
   }
   
   
   
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_get_title (IntPtr tag);
   [DllImport ("libmuinetagger")]
      private static extern void tag_data_set_title (IntPtr tag, string val);
   public string Title
   {
      get
      {
         return Marshal.PtrToStringAnsi (tag_data_get_title (raw)).Trim ();
      }
      set
      {
         tag_data_set_title (raw, value);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_get_album (IntPtr tag);
   [DllImport ("libmuinetagger")]
      private static extern void tag_data_set_album (IntPtr tag, string val);
   public string Album
   {
      get
      {
         return Marshal.PtrToStringAnsi (tag_data_get_album(raw)).Trim ();
      }
      set
      {
         tag_data_set_album (raw, value);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern uint tag_data_get_disc_number (IntPtr tag);
   [DllImport ("libmuinetagger")]
      private static extern void tag_data_set_disc_number (IntPtr tag, uint val);
   public uint Disc
   {
      get
      {
         return tag_data_get_disc_number(raw);
      }
      set
      {
         tag_data_set_disc_number (raw, value);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_get_artist (IntPtr tag);
   [DllImport ("libmuinetagger")]
      private static extern void tag_data_set_artist (IntPtr tag, string val);
   public string Artist
   {
      get
      {
         return Marshal.PtrToStringAnsi (tag_data_get_artist(raw)).Trim ();
      }
      set
      {
         tag_data_set_artist (raw, value);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_get_performers (IntPtr tag);
   [DllImport ("libmuinetagger")]
      private static extern void tag_data_set_performers (IntPtr tag, string val);
   public string Performers
   {
      get
      {
         return Marshal.PtrToStringAnsi (tag_data_get_performers(raw)).Trim ();
      }
      set
      {
         tag_data_set_performers (raw, value);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_get_comment (IntPtr tag);
   [DllImport ("libmuinetagger")]
      private static extern void tag_data_set_comment (IntPtr tag, string val);
   public string Comment
   {
      get
      {
         return Marshal.PtrToStringAnsi (tag_data_get_comment(raw)).Trim ();
      }
      set
      {
         tag_data_set_comment (raw, value);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_get_genre (IntPtr tag);
   [DllImport ("libmuinetagger")]
      private static extern void tag_data_set_genre (IntPtr tag, string val);
   public string Genre
   {
      get
      {
         return Marshal.PtrToStringAnsi (tag_data_get_genre(raw)).Trim ();
      }
      set
      {
         tag_data_set_genre (raw, value);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern uint tag_data_get_year (IntPtr tag);
   [DllImport ("libmuinetagger")]
      private static extern void tag_data_set_year (IntPtr tag, uint val);
   public uint Year
   {
      get
      {
         return tag_data_get_year(raw);
      }
      set
      {
         tag_data_set_year (raw, value);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern uint tag_data_get_track (IntPtr tag);
   [DllImport ("libmuinetagger")]
      private static extern void tag_data_set_track (IntPtr tag, uint val1, uint val2);
   public uint Track
   {
      get
      {
         return tag_data_get_track(raw);
      }
      set
      {
         tag_data_set_track (raw, value, Tracks);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern uint tag_data_get_track_count (IntPtr tag);
   public uint Tracks
   {
      get
      {
         return tag_data_get_track_count(raw);
      }
      set
      {
         tag_data_set_track (raw, Track, value);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern uint tag_data_get_duration (IntPtr tag);
   public uint Duration
   {
      get
      {
         return tag_data_get_duration (raw);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern float tag_data_get_gain (IntPtr tag);
   public float Gain
   {
      get
      {
         return tag_data_get_gain (raw);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern float tag_data_get_peak (IntPtr tag);
   public float Peak
   {
      get
      {
         return tag_data_get_peak (raw);
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_get_cover (IntPtr tag, out uint len);
   public Gdk.Pixbuf AlbumCover
   {
      get
      {
         uint len;
         IntPtr rawdata = tag_data_get_cover (raw, out len);
         if (len == 0) return null;
         byte [] data = new byte [len];
         Marshal.Copy (rawdata, data, 0, (int)len);
         Gdk.PixbufLoader loader = new Gdk.PixbufLoader ();
         if (!loader.Write (data))
            return null;
         if (!loader.Close ())
            return null;
         return loader.Pixbuf;
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern IntPtr tag_data_get_mime (IntPtr tag);
   public string MimeType
   {
      get
      {
         return Marshal.PtrToStringAnsi (tag_data_get_mime(raw)).Trim ();
      }
   }
   
   
   [DllImport ("libmuinetagger")]
      private static extern int tag_data_get_mtime (IntPtr tag);
   public int MTime
   {
      get
      {
         return tag_data_get_mtime(raw);
      }
   }
}
