/*
 * Test case for simulating the transmission of extra data after closing a compressed connection
 * Compile with
 *    gcc -Wall -O3 $(pkg-config --cflags gio-2.0) test-comp.c -o test-comp $(pkg-config --libs gio-2.0)
 * Written by (c) Albrecht Dreß <albrecht.dress@arcor.de> 2018
 */


#include <string.h>
#include <gio/gio.h>


#define SIM_ERROR		1


int main(int argc, char **argv)
{
	GSocketClient *sock;
	GSocketConnection *conn;
	GDataInputStream *istream;
	GInputStream *comp_istream;
	GOutputStream *ostream;
	GZlibCompressor *comp;
	GZlibDecompressor *decomp;
	gchar *line_buf;
	gsize length;

	sock = g_socket_client_new();
	conn = g_socket_client_connect_to_host(sock, "localhost", 65000, NULL, NULL);
	istream = g_data_input_stream_new(g_io_stream_get_input_stream(G_IO_STREAM(conn)));
	g_data_input_stream_set_newline_type(istream, G_DATA_STREAM_NEWLINE_TYPE_CR_LF);
	ostream = g_io_stream_get_output_stream(G_IO_STREAM(conn));

	g_output_stream_write_all(ostream, "COMPRESS\r\n", 10U, NULL, NULL, NULL);
	g_output_stream_flush(ostream, NULL, NULL);
	line_buf = g_data_input_stream_read_line(istream, &length, NULL, NULL);
	g_message("Read %lu:\t%s", length, line_buf);
	g_free(line_buf);

	comp = g_zlib_compressor_new(G_ZLIB_COMPRESSOR_FORMAT_RAW, -1);
	decomp = g_zlib_decompressor_new(G_ZLIB_COMPRESSOR_FORMAT_RAW);
	g_filter_input_stream_set_close_base_stream(G_FILTER_INPUT_STREAM(istream), FALSE);
	g_object_unref(istream);
	comp_istream = g_converter_input_stream_new(g_io_stream_get_input_stream(G_IO_STREAM(conn)), G_CONVERTER(decomp));
	istream = g_data_input_stream_new(comp_istream);
	g_data_input_stream_set_newline_type(istream, G_DATA_STREAM_NEWLINE_TYPE_CR_LF);
	ostream = g_converter_output_stream_new(ostream, G_CONVERTER(comp));

	g_output_stream_write_all(ostream, "DISCONNECT\r\n", 12U, NULL, NULL, NULL);
	g_output_stream_flush(ostream, NULL, NULL);
	g_usleep(10000);

#if SIM_ERROR != 0
	g_object_unref(G_OBJECT(ostream));
	g_object_unref(G_OBJECT(comp));
#endif
	g_object_unref(G_OBJECT(decomp));
	g_object_unref(G_OBJECT(comp_istream));;
	g_object_unref(G_OBJECT(istream));
	g_object_unref(G_OBJECT(conn));
#if SIM_ERROR == 0
	g_object_unref(G_OBJECT(ostream));
	g_object_unref(G_OBJECT(comp));
#endif
	g_object_unref(G_OBJECT(sock));

	return 0;
}
