/* Testcase for GStreamer bug:
 * When two threads are connected with a queue, pausing the input thread breaks the scheduler.
 * (c) Mark Kretschmann (markey)
 */

#include <stdlib.h>
#include <gst/gst.h>

int
main (int argc, char *argv[])
{
  GstElement *threadInput, *threadOutput, *src, *queue, *sink;

  gst_init (&argc, &argv);

  threadInput = gst_thread_new ("threadInput");
  threadOutput = gst_thread_new ("threadOutput");

  src = gst_element_factory_make ("sinesrc", NULL );
  queue = gst_element_factory_make ("queue", NULL );
  sink = gst_element_factory_make ("osssink", NULL );
  /* Reduce latency a bit */
  gst_element_set( queue, "max-size-buffers", 50, NULL );

  gst_bin_add (GST_BIN (threadInput), src);
  gst_bin_add (GST_BIN (threadOutput), queue);
  gst_bin_add (GST_BIN (threadOutput), sink);

  gst_element_link_many (src, queue, sink, NULL);

  gst_element_set_state (GST_ELEMENT (threadOutput), GST_STATE_PLAYING);
  gst_element_set_state (GST_ELEMENT (threadInput), GST_STATE_PLAYING);

  g_print("\nTestcase for GStreamer bug: \n");
  g_print("When two threads are connected with a queue, pausing the input thread breaks the scheduler.\n");
  g_print("\nNow playing pipeline: {sinesrc} ! {queue ! osssink}\n\n");
  g_print("Press return to set input thread to PAUSED\n");
  getchar();

  gst_element_set_state (GST_ELEMENT (threadInput), GST_STATE_PAUSED);

  g_print("Press return to set input thread to PLAYING. This will crash the scheduler.\n");
  getchar();

  gst_element_set_state (GST_ELEMENT (threadInput), GST_STATE_PLAYING);

  g_print("Now the pipeline is drowning in interrupt events. Playback is distorted.\n");
  g_print("Press return to stop playback and exit.");
  getchar();

  /* Destroy all elements */
  gst_element_set_state (GST_ELEMENT (threadInput), GST_STATE_NULL);
  gst_element_set_state (GST_ELEMENT (threadOutput), GST_STATE_NULL);
  gst_object_unref (GST_OBJECT(threadInput));
  gst_object_unref (GST_OBJECT(threadOutput));

  exit (0);
}
