import gettext
import locale
import ctypes
import ctypes.util
import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk

_ = gettext.gettext
locale.setlocale(locale.LC_ALL, '')

libintl_path = ctypes.util.find_library('libintl-8')
print(libintl_path)
if libintl_path is None:
    print('NOT FOUND')
libintl = ctypes.cdll.LoadLibrary(libintl_path)
libintl.bindtextdomain('trans', './locale')
libintl.bind_textdomain_codeset('trans', 'UTF-8')

gettext.bindtextdomain('trans', './locale')
gettext.textdomain('trans')


class MyWindow(Gtk.Window):

    def __init__(self):
        Gtk.Window.__init__(self)
        self.set_default_size(100, 100)
        builder = self.get_gtk_builder()

        box = builder.get_object('box')
        label = Gtk.Label(_('not translated'))
        box.add(label)
        self.add(box)
        self.show_all()

    def get_gtk_builder(self):
        builder = Gtk.Builder()
        builder.set_translation_domain('trans')
        builder.add_from_file('./label.glade')
        return builder

win = MyWindow()
win.connect("delete-event", Gtk.main_quit)
win.show_all()
Gtk.main()