#include <gtk/gtk.h>
#include "os_custom.h"
#include <cairo.h>

void set_region(GtkWidget *button, GtkWidget *fixed)
{
  cairo_rectangle_int_t rect;
  rect.x = 0;
  rect.y = 0;
  rect.height = 20;
  rect.width = 50;
  cairo_region_t *reg = cairo_region_create_rectangle (&rect);
  gtk_widget_realize(fixed);
  GdkWindow *window = gtk_widget_get_window(fixed);

  // This call is needed to get the region drawn on X11.
  // Unfortunately it breaks on Wayland.
  //gdk_window_ensure_native(window);

  gdk_window_shape_combine_region(window, reg, 0, 0);
  return;
}

void clicked (GtkButton *button, gpointer user_data)
{
  printf("Button was clicked\n");
  return;
}

static void
activate (GtkApplication *app,
          gpointer        user_data)
{

  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *vbox;
  GtkWidget *fixed;
  GtkWidget *scrolled;

  window = gtk_application_window_new (app);
  gtk_window_set_title (GTK_WINDOW (window), "Window");
  gtk_window_set_default_size (GTK_WINDOW (window), 200, 200);

  vbox = gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
  scrolled = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (vbox), scrolled);

  fixed = swt_fixed_new ();
  gtk_container_add (GTK_CONTAINER (scrolled), fixed);

  button = gtk_button_new_with_label ("Test Button");
  gtk_container_add (GTK_CONTAINER (fixed), button);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  set_region(button, fixed);

  gtk_widget_show_all (window);
  g_signal_connect (button, "clicked", G_CALLBACK(clicked), NULL);
}

int
main (int    argc,
      char **argv)
{

  GtkApplication *app;
  int status;

  app = gtk_application_new ("org.gtk.example", G_APPLICATION_FLAGS_NONE);
  g_signal_connect (app, "activate", G_CALLBACK (activate), NULL);
  status = g_application_run (G_APPLICATION (app), argc, argv);
  g_object_unref (app);

  return status;
}
