/* balistica_application.c generated by valac 0.36.6, the Vala compiler
 * generated from balistica_application.vala, do not modify */

/* Copyright 2012-2017 Steven Oliver <oliver.steven@gmail.com>
 *
 * This file is part of balística.
 *
 * balística is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * balística is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with balística.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Defined by cmake build script.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "lib-balistica.h"
#include <float.h>
#include <math.h>


#define BALISTICA_TYPE_APPLICATION (balistica_application_get_type ())
#define BALISTICA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BALISTICA_TYPE_APPLICATION, BalisticaApplication))
#define BALISTICA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BALISTICA_TYPE_APPLICATION, BalisticaApplicationClass))
#define BALISTICA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BALISTICA_TYPE_APPLICATION))
#define BALISTICA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BALISTICA_TYPE_APPLICATION))
#define BALISTICA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BALISTICA_TYPE_APPLICATION, BalisticaApplicationClass))

typedef struct _BalisticaApplication BalisticaApplication;
typedef struct _BalisticaApplicationClass BalisticaApplicationClass;
typedef struct _BalisticaApplicationPrivate BalisticaApplicationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _BalisticaApplication {
	GtkApplication parent_instance;
	BalisticaApplicationPrivate * priv;
};

struct _BalisticaApplicationClass {
	GtkApplicationClass parent_class;
};

struct _BalisticaApplicationPrivate {
	GSettings* settings;
	GtkWindow* main_window;
	GtkBuilder* drag_builder;
	GtkBuilder* twist_builder;
	GtkBuilder* stability_builder;
	GtkEntry* calc_name;
	GtkEntry* drag_coefficient;
	GtkEntry* projectile_weight;
	GtkEntry* initial_velocity;
	GtkEntry* zero_range;
	GtkEntry* sight_height;
	GtkEntry* shooting_angle;
	GtkEntry* wind_velocity;
	GtkEntry* wind_angle;
	GtkEntry* altitude;
	GtkEntry* temp;
	GtkEntry* bar_press;
	GtkEntry* rela_humid;
	GtkCheckButton* enable_atmosphere;
	GtkTextView* drag_results;
	LibBalisticaSolution* lsln;
	GtkButton* reset_drag;
	GtkButton* solve_drag;
	GtkButton* export_results;
	GtkButton* calc_pbr;
	GtkRadioButton* rad_g1;
	GtkRadioButton* rad_g2;
	GtkRadioButton* rad_g5;
	GtkRadioButton* rad_g6;
	GtkRadioButton* rad_g7;
	GtkRadioButton* rad_g8;
	GtkRadioButton* rad_s10;
	GtkRadioButton* rad_s50;
	GtkRadioButton* rad_s100;
	GtkEntry* miller_diameter;
	GtkEntry* miller_length;
	GtkEntry* miller_mass;
	GtkEntry* miller_safe_value;
	GtkEntry* greenhill_diameter;
	GtkEntry* greenhill_length;
	GtkEntry* greenhill_spec_gravity;
	GtkEntry* greenhill_c;
	GtkEntry* twist_results;
	GtkButton* reset_twist;
	GtkButton* solve_twist;
	GtkRadioButton* rad_greenhill;
	GtkRadioButton* rad_miller;
	GtkEntry* miller_sta_diameter;
	GtkEntry* miller_sta_length;
	GtkEntry* miller_sta_mass;
	GtkEntry* miller_sta_safe_value;
	GtkEntry* stability_results;
	GtkButton* reset_stability;
	GtkButton* solve_stability;
};

struct _Block1Data {
	int _ref_count_;
	BalisticaApplication* self;
	GtkDialog* dialog;
};


static gpointer balistica_application_parent_class = NULL;

#define BALISTICA_NAME "balística"
#define BALISTICA_VERSION_MAJOR _VERSION_MAJOR
#define BALISTICA_VERSION_MINOR _VERSION_MINOR
#define BALISTICA_VERSION_COMMIT _VERSION_COMMIT
#define BALISTICA_VERSION_DESC _VERSION_DESC
#define BALISTICA_GSETTINGS_DIR _GSETTINGS_DIR
GType balistica_application_get_type (void) G_GNUC_CONST;
#define BALISTICA_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BALISTICA_TYPE_APPLICATION, BalisticaApplicationPrivate))
enum  {
	BALISTICA_APPLICATION_DUMMY_PROPERTY
};
BalisticaApplication* balistica_application_new (void);
BalisticaApplication* balistica_application_construct (GType object_type);
static void balistica_application_real_startup (GApplication* base);
static void __lambda4_ (BalisticaApplication* self);
static void balistica_application_populate_demo_selected (BalisticaApplication* self);
static void ___lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda5_ (BalisticaApplication* self);
static void balistica_application_quit_selected (BalisticaApplication* self);
static void ___lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda6_ (BalisticaApplication* self);
static void balistica_application_help_selected (BalisticaApplication* self);
static void ___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda8_ (BalisticaApplication* self);
static void balistica_application_about_selected (BalisticaApplication* self);
static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
GtkBuilder* balistica_create_builder (const gchar* ui_filename);
void balistica_application_connect_entries (BalisticaApplication* self);
static void balistica_application_real_activate (GApplication* base);
static void balistica_application_setExampleCalculation (BalisticaApplication* self);
static void __lambda9_ (BalisticaApplication* self);
static void ___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void balistica_application_setDefaultAtmosphere (BalisticaApplication* self);
static void __lambda10_ (BalisticaApplication* self);
void balistica_application_btnSolveDrag_clicked (BalisticaApplication* self);
static void ___lambda10__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda11_ (BalisticaApplication* self);
void balistica_application_btnResetDrag_clicked (BalisticaApplication* self);
static void ___lambda11__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda12_ (BalisticaApplication* self);
void balistica_application_btnResetTwist_clicked (BalisticaApplication* self);
static void ___lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda13_ (BalisticaApplication* self);
void balistica_application_btnSolveTwist_clicked (BalisticaApplication* self);
static void ___lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda14_ (BalisticaApplication* self);
static void ___lambda14__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda15_ (BalisticaApplication* self);
static void ___lambda15__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda16_ (BalisticaApplication* self);
void balistica_application_btnResetStability_clicked (BalisticaApplication* self);
static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda17_ (BalisticaApplication* self);
void balistica_application_btnSolveStability_clicked (BalisticaApplication* self);
static void ___lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
LibBalisticaSolution* balistica_calculate_drag (gdouble bc, gdouble v, gdouble sh, gdouble weight, gdouble angle, gdouble zero, gdouble wspeed, gdouble wangle, gdouble alt, gdouble bar, gdouble tp, gdouble rh, const gchar* name, gint df);
static void balistica_application_display_error (BalisticaApplication* self, const gchar* error_msg, GError* err);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda7_ (Block1Data* _data1_);
static void ___lambda7__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void balistica_application_finalize (GObject * obj);

const gchar* BALISTICA_AUTHORS[2] = {"Steven Oliver <oliver.steven@gmail.com>", NULL};

/**
   * Constructor
   */
BalisticaApplication* balistica_application_construct (GType object_type) {
	BalisticaApplication * self = NULL;
	self = (BalisticaApplication*) g_object_new (object_type, "application-id", "org.gnome.balistica", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	return self;
}


BalisticaApplication* balistica_application_new (void) {
	return balistica_application_construct (BALISTICA_TYPE_APPLICATION);
}


/**
   * Override the default GTK startup procedure
   */
static void __lambda4_ (BalisticaApplication* self) {
	balistica_application_populate_demo_selected (self);
}


static void ___lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda4_ ((BalisticaApplication*) self);
}


static void __lambda5_ (BalisticaApplication* self) {
	balistica_application_quit_selected (self);
}


static void ___lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda5_ ((BalisticaApplication*) self);
}


static void __lambda6_ (BalisticaApplication* self) {
	balistica_application_help_selected (self);
}


static void ___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda6_ ((BalisticaApplication*) self);
}


static void __lambda8_ (BalisticaApplication* self) {
	balistica_application_about_selected (self);
}


static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda8_ ((BalisticaApplication*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void balistica_application_real_startup (GApplication* base) {
	BalisticaApplication * self;
	GSettings* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp5_;
	GtkMenuBar* menubar = NULL;
	GtkMenuBar* _tmp6_;
	GtkMenuItem* item_file = NULL;
	GtkMenuItem* _tmp7_;
	GtkMenu* filemenu = NULL;
	GtkMenu* _tmp8_;
	GtkMenuItem* sub_item_demo = NULL;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* sub_item_quit = NULL;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* item_help = NULL;
	GtkMenuItem* _tmp11_;
	GtkMenu* helpmenu = NULL;
	GtkMenu* _tmp12_;
	GtkMenuItem* sub_item_about = NULL;
	GtkMenuItem* _tmp13_;
	GtkMenuItem* sub_item_help = NULL;
	GtkMenuItem* _tmp14_;
	GtkNotebook* notebook = NULL;
	GtkNotebook* _tmp15_;
	GtkBuilder* _tmp16_;
	GtkBuilder* _tmp17_;
	GtkBox* drag_content = NULL;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GtkBox* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkBuilder* _tmp23_;
	GtkBuilder* _tmp24_;
	GtkBox* twist_content = NULL;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_;
	GtkBox* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkBuilder* _tmp30_;
	GtkBuilder* _tmp31_;
	GtkBox* stability_content = NULL;
	GtkBuilder* _tmp32_;
	GObject* _tmp33_;
	GtkBox* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkWindow* _tmp37_;
	GtkWindow* _tmp38_;
	GtkWindow* _tmp39_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, BALISTICA_TYPE_APPLICATION, BalisticaApplication);
	G_APPLICATION_CLASS (balistica_application_parent_class)->startup (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	_tmp0_ = g_settings_new ("org.gnome.balistica");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp1_;
	g_set_application_name (BALISTICA_NAME);
	_tmp2_ = self->priv->main_window;
	gtk_window_set_title (_tmp2_, BALISTICA_NAME);
	_tmp3_ = self->priv->main_window;
	g_object_set (_tmp3_, "window-position", GTK_WIN_POS_CENTER, NULL);
	_tmp4_ = self->priv->main_window;
	gtk_window_set_default_size (_tmp4_, 735, 750);
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp5_);
	grid = _tmp5_;
	_tmp6_ = (GtkMenuBar*) gtk_menu_bar_new ();
	g_object_ref_sink (_tmp6_);
	menubar = _tmp6_;
	_tmp7_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("File");
	g_object_ref_sink (_tmp7_);
	item_file = _tmp7_;
	_tmp8_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp8_);
	filemenu = _tmp8_;
	_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Populate Demo");
	g_object_ref_sink (_tmp9_);
	sub_item_demo = _tmp9_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (filemenu, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (sub_item_demo, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Quit");
	g_object_ref_sink (_tmp10_);
	sub_item_quit = _tmp10_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (filemenu, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (sub_item_quit, gtk_widget_get_type (), GtkWidget));
	gtk_menu_item_set_submenu (item_file, G_TYPE_CHECK_INSTANCE_CAST (filemenu, gtk_widget_get_type (), GtkWidget));
	g_signal_connect_object (sub_item_demo, "activate", (GCallback) ___lambda4__gtk_menu_item_activate, self, 0);
	g_signal_connect_object (sub_item_quit, "activate", (GCallback) ___lambda5__gtk_menu_item_activate, self, 0);
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Help");
	g_object_ref_sink (_tmp11_);
	item_help = _tmp11_;
	_tmp12_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp12_);
	helpmenu = _tmp12_;
	_tmp13_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("About");
	g_object_ref_sink (_tmp13_);
	sub_item_about = _tmp13_;
	_tmp14_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Help");
	g_object_ref_sink (_tmp14_);
	sub_item_help = _tmp14_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (helpmenu, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (sub_item_about, gtk_widget_get_type (), GtkWidget));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (helpmenu, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (sub_item_help, gtk_widget_get_type (), GtkWidget));
	gtk_menu_item_set_submenu (item_help, G_TYPE_CHECK_INSTANCE_CAST (helpmenu, gtk_widget_get_type (), GtkWidget));
	g_signal_connect_object (sub_item_help, "activate", (GCallback) ___lambda6__gtk_menu_item_activate, self, 0);
	g_signal_connect_object (sub_item_about, "activate", (GCallback) ___lambda8__gtk_menu_item_activate, self, 0);
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (menubar, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (item_file, gtk_widget_get_type (), GtkWidget));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (menubar, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (item_help, gtk_widget_get_type (), GtkWidget));
	gtk_grid_attach (grid, G_TYPE_CHECK_INSTANCE_CAST (menubar, gtk_widget_get_type (), GtkWidget), 0, 0, 1, 1);
	_tmp15_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp15_);
	notebook = _tmp15_;
	_tmp16_ = balistica_create_builder ("drag.glade");
	_g_object_unref0 (self->priv->drag_builder);
	self->priv->drag_builder = _tmp16_;
	_tmp17_ = self->priv->drag_builder;
	gtk_builder_connect_signals (_tmp17_, NULL);
	_tmp18_ = self->priv->drag_builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "drag_main");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_box_get_type ()) ? ((GtkBox*) _tmp19_) : NULL);
	drag_content = _tmp20_;
	_tmp21_ = (GtkLabel*) gtk_label_new ("Drag");
	g_object_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	gtk_notebook_append_page (notebook, G_TYPE_CHECK_INSTANCE_CAST (drag_content, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp22_);
	_tmp23_ = balistica_create_builder ("twist.glade");
	_g_object_unref0 (self->priv->twist_builder);
	self->priv->twist_builder = _tmp23_;
	_tmp24_ = self->priv->twist_builder;
	gtk_builder_connect_signals (_tmp24_, NULL);
	_tmp25_ = self->priv->twist_builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "twist_main");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gtk_box_get_type ()) ? ((GtkBox*) _tmp26_) : NULL);
	twist_content = _tmp27_;
	_tmp28_ = (GtkLabel*) gtk_label_new ("Twist");
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	gtk_notebook_append_page (notebook, G_TYPE_CHECK_INSTANCE_CAST (twist_content, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp29_);
	_tmp30_ = balistica_create_builder ("stability.glade");
	_g_object_unref0 (self->priv->stability_builder);
	self->priv->stability_builder = _tmp30_;
	_tmp31_ = self->priv->stability_builder;
	gtk_builder_connect_signals (_tmp31_, NULL);
	_tmp32_ = self->priv->stability_builder;
	_tmp33_ = gtk_builder_get_object (_tmp32_, "stability_main");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, gtk_box_get_type ()) ? ((GtkBox*) _tmp33_) : NULL);
	stability_content = _tmp34_;
	_tmp35_ = (GtkLabel*) gtk_label_new ("Stability");
	g_object_ref_sink (_tmp35_);
	_tmp36_ = _tmp35_;
	gtk_notebook_append_page (notebook, G_TYPE_CHECK_INSTANCE_CAST (stability_content, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp36_);
	gtk_grid_attach (grid, G_TYPE_CHECK_INSTANCE_CAST (notebook, gtk_widget_get_type (), GtkWidget), 0, 1, 1, 1);
	_tmp37_ = self->priv->main_window;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_widget_get_type (), GtkWidget));
	_tmp38_ = self->priv->main_window;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
	_tmp39_ = self->priv->main_window;
	gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp39_);
	balistica_application_connect_entries (self);
	_g_object_unref0 (stability_content);
	_g_object_unref0 (twist_content);
	_g_object_unref0 (drag_content);
	_g_object_unref0 (notebook);
	_g_object_unref0 (sub_item_help);
	_g_object_unref0 (sub_item_about);
	_g_object_unref0 (helpmenu);
	_g_object_unref0 (item_help);
	_g_object_unref0 (sub_item_quit);
	_g_object_unref0 (sub_item_demo);
	_g_object_unref0 (filemenu);
	_g_object_unref0 (item_file);
	_g_object_unref0 (menubar);
	_g_object_unref0 (grid);
}


/**
   * Present the existing main window, or create a new one.
   */
static void balistica_application_real_activate (GApplication* base) {
	BalisticaApplication * self;
	GtkWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, BALISTICA_TYPE_APPLICATION, BalisticaApplication);
	G_APPLICATION_CLASS (balistica_application_parent_class)->activate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	_tmp0_ = self->priv->main_window;
	gtk_window_present (_tmp0_);
}


/**
   * Connect the GUI elements to our code so we can play with them
   */
static void __lambda9_ (BalisticaApplication* self) {
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->enable_atmosphere;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkEntry* _tmp3_;
		GtkEntry* _tmp4_;
		GtkEntry* _tmp5_;
		GtkEntry* _tmp6_;
		_tmp3_ = self->priv->altitude;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp4_ = self->priv->temp;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp5_ = self->priv->bar_press;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp6_ = self->priv->rela_humid;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), TRUE);
	} else {
		GtkEntry* _tmp7_;
		GtkEntry* _tmp8_;
		GtkEntry* _tmp9_;
		GtkEntry* _tmp10_;
		_tmp7_ = self->priv->altitude;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp8_ = self->priv->temp;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp9_ = self->priv->bar_press;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp10_ = self->priv->rela_humid;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
}


static void ___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda9_ ((BalisticaApplication*) self);
}


static void __lambda10_ (BalisticaApplication* self) {
	balistica_application_btnSolveDrag_clicked (self);
}


static void ___lambda10__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda10_ ((BalisticaApplication*) self);
}


static void __lambda11_ (BalisticaApplication* self) {
	balistica_application_btnResetDrag_clicked (self);
}


static void ___lambda11__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda11_ ((BalisticaApplication*) self);
}


static void __lambda12_ (BalisticaApplication* self) {
	balistica_application_btnResetTwist_clicked (self);
}


static void ___lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda12_ ((BalisticaApplication*) self);
}


static void __lambda13_ (BalisticaApplication* self) {
	balistica_application_btnSolveTwist_clicked (self);
}


static void ___lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda13_ ((BalisticaApplication*) self);
}


static void __lambda14_ (BalisticaApplication* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	_tmp0_ = self->priv->miller_diameter;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp1_ = self->priv->miller_length;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp2_ = self->priv->miller_mass;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp3_ = self->priv->miller_safe_value;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp4_ = self->priv->greenhill_diameter;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp5_ = self->priv->greenhill_length;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp6_ = self->priv->greenhill_spec_gravity;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp7_ = self->priv->greenhill_c;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), FALSE);
}


static void ___lambda14__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda14_ ((BalisticaApplication*) self);
}


static void __lambda15_ (BalisticaApplication* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	_tmp0_ = self->priv->miller_diameter;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp1_ = self->priv->miller_length;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->miller_mass;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp3_ = self->priv->miller_safe_value;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp4_ = self->priv->greenhill_diameter;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp5_ = self->priv->greenhill_length;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp6_ = self->priv->greenhill_spec_gravity;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp7_ = self->priv->greenhill_c;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda15__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda15_ ((BalisticaApplication*) self);
}


static void __lambda16_ (BalisticaApplication* self) {
	balistica_application_btnResetStability_clicked (self);
}


static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda16_ ((BalisticaApplication*) self);
}


static void __lambda17_ (BalisticaApplication* self) {
	balistica_application_btnSolveStability_clicked (self);
}


static void ___lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda17_ ((BalisticaApplication*) self);
}


void balistica_application_connect_entries (BalisticaApplication* self) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkEntry* _tmp2_;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_;
	GtkEntry* _tmp5_;
	GtkBuilder* _tmp6_;
	GObject* _tmp7_;
	GtkEntry* _tmp8_;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_;
	GtkEntry* _tmp11_;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_;
	GtkEntry* _tmp14_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_;
	GtkEntry* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GtkEntry* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_;
	GtkEntry* _tmp23_;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_;
	GtkEntry* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_;
	GtkCheckButton* _tmp29_;
	GtkCheckButton* _tmp30_;
	GtkBuilder* _tmp31_;
	GObject* _tmp32_;
	GtkEntry* _tmp33_;
	GtkBuilder* _tmp34_;
	GObject* _tmp35_;
	GtkEntry* _tmp36_;
	GtkBuilder* _tmp37_;
	GObject* _tmp38_;
	GtkEntry* _tmp39_;
	GtkBuilder* _tmp40_;
	GObject* _tmp41_;
	GtkEntry* _tmp42_;
	GtkBuilder* _tmp43_;
	GObject* _tmp44_;
	GtkTextView* _tmp45_;
	GtkBuilder* _tmp46_;
	GObject* _tmp47_;
	GtkRadioButton* _tmp48_;
	GtkBuilder* _tmp49_;
	GObject* _tmp50_;
	GtkRadioButton* _tmp51_;
	GtkBuilder* _tmp52_;
	GObject* _tmp53_;
	GtkRadioButton* _tmp54_;
	GtkBuilder* _tmp55_;
	GObject* _tmp56_;
	GtkRadioButton* _tmp57_;
	GtkBuilder* _tmp58_;
	GObject* _tmp59_;
	GtkRadioButton* _tmp60_;
	GtkBuilder* _tmp61_;
	GObject* _tmp62_;
	GtkRadioButton* _tmp63_;
	GtkRadioButton* _tmp64_;
	GtkBuilder* _tmp65_;
	GObject* _tmp66_;
	GtkRadioButton* _tmp67_;
	GtkBuilder* _tmp68_;
	GObject* _tmp69_;
	GtkRadioButton* _tmp70_;
	GtkBuilder* _tmp71_;
	GObject* _tmp72_;
	GtkRadioButton* _tmp73_;
	GtkRadioButton* _tmp74_;
	GtkBuilder* _tmp75_;
	GObject* _tmp76_;
	GtkButton* _tmp77_;
	GtkButton* _tmp78_;
	GtkBuilder* _tmp79_;
	GObject* _tmp80_;
	GtkButton* _tmp81_;
	GtkButton* _tmp82_;
	GtkBuilder* _tmp83_;
	GObject* _tmp84_;
	GtkEntry* _tmp85_;
	GtkBuilder* _tmp86_;
	GObject* _tmp87_;
	GtkEntry* _tmp88_;
	GtkBuilder* _tmp89_;
	GObject* _tmp90_;
	GtkEntry* _tmp91_;
	GtkBuilder* _tmp92_;
	GObject* _tmp93_;
	GtkEntry* _tmp94_;
	GtkBuilder* _tmp95_;
	GObject* _tmp96_;
	GtkEntry* _tmp97_;
	GtkBuilder* _tmp98_;
	GObject* _tmp99_;
	GtkEntry* _tmp100_;
	GtkBuilder* _tmp101_;
	GObject* _tmp102_;
	GtkEntry* _tmp103_;
	GtkBuilder* _tmp104_;
	GObject* _tmp105_;
	GtkEntry* _tmp106_;
	GtkBuilder* _tmp107_;
	GObject* _tmp108_;
	GtkEntry* _tmp109_;
	GtkBuilder* _tmp110_;
	GObject* _tmp111_;
	GtkButton* _tmp112_;
	GtkButton* _tmp113_;
	GtkBuilder* _tmp114_;
	GObject* _tmp115_;
	GtkButton* _tmp116_;
	GtkButton* _tmp117_;
	GtkBuilder* _tmp118_;
	GObject* _tmp119_;
	GtkRadioButton* _tmp120_;
	GtkBuilder* _tmp121_;
	GObject* _tmp122_;
	GtkRadioButton* _tmp123_;
	GtkRadioButton* _tmp124_;
	GtkRadioButton* _tmp125_;
	GtkRadioButton* _tmp126_;
	GtkBuilder* _tmp127_;
	GObject* _tmp128_;
	GtkEntry* _tmp129_;
	GtkBuilder* _tmp130_;
	GObject* _tmp131_;
	GtkEntry* _tmp132_;
	GtkBuilder* _tmp133_;
	GObject* _tmp134_;
	GtkEntry* _tmp135_;
	GtkBuilder* _tmp136_;
	GObject* _tmp137_;
	GtkEntry* _tmp138_;
	GtkBuilder* _tmp139_;
	GObject* _tmp140_;
	GtkEntry* _tmp141_;
	GtkBuilder* _tmp142_;
	GObject* _tmp143_;
	GtkButton* _tmp144_;
	GtkButton* _tmp145_;
	GtkBuilder* _tmp146_;
	GObject* _tmp147_;
	GtkButton* _tmp148_;
	GtkButton* _tmp149_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = self->priv->drag_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "txtName");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp1_) : NULL);
	_g_object_unref0 (self->priv->calc_name);
	self->priv->calc_name = _tmp2_;
	_tmp3_ = self->priv->drag_builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "txtDrag_coefficient");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp4_) : NULL);
	_g_object_unref0 (self->priv->drag_coefficient);
	self->priv->drag_coefficient = _tmp5_;
	_tmp6_ = self->priv->drag_builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "txtProjectile_weight");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp7_) : NULL);
	_g_object_unref0 (self->priv->projectile_weight);
	self->priv->projectile_weight = _tmp8_;
	_tmp9_ = self->priv->drag_builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "txtIntial_velocity");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp10_) : NULL);
	_g_object_unref0 (self->priv->initial_velocity);
	self->priv->initial_velocity = _tmp11_;
	_tmp12_ = self->priv->drag_builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "txtZero_range");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp13_) : NULL);
	_g_object_unref0 (self->priv->zero_range);
	self->priv->zero_range = _tmp14_;
	_tmp15_ = self->priv->drag_builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "txtSight_height");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp16_) : NULL);
	_g_object_unref0 (self->priv->sight_height);
	self->priv->sight_height = _tmp17_;
	_tmp18_ = self->priv->drag_builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "txtShooting_angle");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp19_) : NULL);
	_g_object_unref0 (self->priv->shooting_angle);
	self->priv->shooting_angle = _tmp20_;
	_tmp21_ = self->priv->drag_builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "txtWind_velocity");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp22_) : NULL);
	_g_object_unref0 (self->priv->wind_velocity);
	self->priv->wind_velocity = _tmp23_;
	_tmp24_ = self->priv->drag_builder;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "txtWind_angle");
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp25_) : NULL);
	_g_object_unref0 (self->priv->wind_angle);
	self->priv->wind_angle = _tmp26_;
	balistica_application_setExampleCalculation (self);
	_tmp27_ = self->priv->drag_builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "ckbAtmosCorr");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, gtk_check_button_get_type ()) ? ((GtkCheckButton*) _tmp28_) : NULL);
	_g_object_unref0 (self->priv->enable_atmosphere);
	self->priv->enable_atmosphere = _tmp29_;
	_tmp30_ = self->priv->enable_atmosphere;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) ___lambda9__gtk_toggle_button_toggled, self, 0);
	_tmp31_ = self->priv->drag_builder;
	_tmp32_ = gtk_builder_get_object (_tmp31_, "txtAltitude");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp32_) : NULL);
	_g_object_unref0 (self->priv->altitude);
	self->priv->altitude = _tmp33_;
	_tmp34_ = self->priv->drag_builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "txtTemp");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp35_) : NULL);
	_g_object_unref0 (self->priv->temp);
	self->priv->temp = _tmp36_;
	_tmp37_ = self->priv->drag_builder;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "txtBarPress");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp38_) : NULL);
	_g_object_unref0 (self->priv->bar_press);
	self->priv->bar_press = _tmp39_;
	_tmp40_ = self->priv->drag_builder;
	_tmp41_ = gtk_builder_get_object (_tmp40_, "txtRelaHumid");
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp41_) : NULL);
	_g_object_unref0 (self->priv->rela_humid);
	self->priv->rela_humid = _tmp42_;
	balistica_application_setDefaultAtmosphere (self);
	_tmp43_ = self->priv->drag_builder;
	_tmp44_ = gtk_builder_get_object (_tmp43_, "txtViewDragResults");
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, gtk_text_view_get_type ()) ? ((GtkTextView*) _tmp44_) : NULL);
	_g_object_unref0 (self->priv->drag_results);
	self->priv->drag_results = _tmp45_;
	_tmp46_ = self->priv->drag_builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "radG1");
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp47_) : NULL);
	_g_object_unref0 (self->priv->rad_g1);
	self->priv->rad_g1 = _tmp48_;
	_tmp49_ = self->priv->drag_builder;
	_tmp50_ = gtk_builder_get_object (_tmp49_, "radG2");
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp50_) : NULL);
	_g_object_unref0 (self->priv->rad_g2);
	self->priv->rad_g2 = _tmp51_;
	_tmp52_ = self->priv->drag_builder;
	_tmp53_ = gtk_builder_get_object (_tmp52_, "radG5");
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp53_) : NULL);
	_g_object_unref0 (self->priv->rad_g5);
	self->priv->rad_g5 = _tmp54_;
	_tmp55_ = self->priv->drag_builder;
	_tmp56_ = gtk_builder_get_object (_tmp55_, "radG6");
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp56_) : NULL);
	_g_object_unref0 (self->priv->rad_g6);
	self->priv->rad_g6 = _tmp57_;
	_tmp58_ = self->priv->drag_builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "radG7");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp59_) : NULL);
	_g_object_unref0 (self->priv->rad_g7);
	self->priv->rad_g7 = _tmp60_;
	_tmp61_ = self->priv->drag_builder;
	_tmp62_ = gtk_builder_get_object (_tmp61_, "radG8");
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp62_) : NULL);
	_g_object_unref0 (self->priv->rad_g8);
	self->priv->rad_g8 = _tmp63_;
	_tmp64_ = self->priv->rad_g1;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	_tmp65_ = self->priv->drag_builder;
	_tmp66_ = gtk_builder_get_object (_tmp65_, "radS10");
	_tmp67_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp66_) : NULL);
	_g_object_unref0 (self->priv->rad_s10);
	self->priv->rad_s10 = _tmp67_;
	_tmp68_ = self->priv->drag_builder;
	_tmp69_ = gtk_builder_get_object (_tmp68_, "radS50");
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp69_) : NULL);
	_g_object_unref0 (self->priv->rad_s50);
	self->priv->rad_s50 = _tmp70_;
	_tmp71_ = self->priv->drag_builder;
	_tmp72_ = gtk_builder_get_object (_tmp71_, "radS100");
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp72_) : NULL);
	_g_object_unref0 (self->priv->rad_s100);
	self->priv->rad_s100 = _tmp73_;
	_tmp74_ = self->priv->rad_s10;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	_tmp75_ = self->priv->drag_builder;
	_tmp76_ = gtk_builder_get_object (_tmp75_, "btnSolveDrag");
	_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, gtk_button_get_type ()) ? ((GtkButton*) _tmp76_) : NULL);
	_g_object_unref0 (self->priv->solve_drag);
	self->priv->solve_drag = _tmp77_;
	_tmp78_ = self->priv->solve_drag;
	g_signal_connect_object (_tmp78_, "clicked", (GCallback) ___lambda10__gtk_button_clicked, self, 0);
	_tmp79_ = self->priv->drag_builder;
	_tmp80_ = gtk_builder_get_object (_tmp79_, "btnResetDrag");
	_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, gtk_button_get_type ()) ? ((GtkButton*) _tmp80_) : NULL);
	_g_object_unref0 (self->priv->reset_drag);
	self->priv->reset_drag = _tmp81_;
	_tmp82_ = self->priv->reset_drag;
	g_signal_connect_object (_tmp82_, "clicked", (GCallback) ___lambda11__gtk_button_clicked, self, 0);
	_tmp83_ = self->priv->twist_builder;
	_tmp84_ = gtk_builder_get_object (_tmp83_, "txtMDiameter");
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp84_) : NULL);
	_g_object_unref0 (self->priv->miller_diameter);
	self->priv->miller_diameter = _tmp85_;
	_tmp86_ = self->priv->twist_builder;
	_tmp87_ = gtk_builder_get_object (_tmp86_, "txtMLength");
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp87_) : NULL);
	_g_object_unref0 (self->priv->miller_length);
	self->priv->miller_length = _tmp88_;
	_tmp89_ = self->priv->twist_builder;
	_tmp90_ = gtk_builder_get_object (_tmp89_, "txtMass");
	_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp90_) : NULL);
	_g_object_unref0 (self->priv->miller_mass);
	self->priv->miller_mass = _tmp91_;
	_tmp92_ = self->priv->twist_builder;
	_tmp93_ = gtk_builder_get_object (_tmp92_, "txtSafeValue");
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp93_) : NULL);
	_g_object_unref0 (self->priv->miller_safe_value);
	self->priv->miller_safe_value = _tmp94_;
	_tmp95_ = self->priv->twist_builder;
	_tmp96_ = gtk_builder_get_object (_tmp95_, "txtGDiameter");
	_tmp97_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp96_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp96_) : NULL);
	_g_object_unref0 (self->priv->greenhill_diameter);
	self->priv->greenhill_diameter = _tmp97_;
	_tmp98_ = self->priv->twist_builder;
	_tmp99_ = gtk_builder_get_object (_tmp98_, "txtGLength");
	_tmp100_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp99_) : NULL);
	_g_object_unref0 (self->priv->greenhill_length);
	self->priv->greenhill_length = _tmp100_;
	_tmp101_ = self->priv->twist_builder;
	_tmp102_ = gtk_builder_get_object (_tmp101_, "txtSpecificGravity");
	_tmp103_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp102_) : NULL);
	_g_object_unref0 (self->priv->greenhill_spec_gravity);
	self->priv->greenhill_spec_gravity = _tmp103_;
	_tmp104_ = self->priv->twist_builder;
	_tmp105_ = gtk_builder_get_object (_tmp104_, "txtC");
	_tmp106_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp105_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp105_) : NULL);
	_g_object_unref0 (self->priv->greenhill_c);
	self->priv->greenhill_c = _tmp106_;
	_tmp107_ = self->priv->twist_builder;
	_tmp108_ = gtk_builder_get_object (_tmp107_, "txtResult");
	_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp108_) : NULL);
	_g_object_unref0 (self->priv->twist_results);
	self->priv->twist_results = _tmp109_;
	_tmp110_ = self->priv->twist_builder;
	_tmp111_ = gtk_builder_get_object (_tmp110_, "btnReset");
	_tmp112_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp111_, gtk_button_get_type ()) ? ((GtkButton*) _tmp111_) : NULL);
	_g_object_unref0 (self->priv->reset_twist);
	self->priv->reset_twist = _tmp112_;
	_tmp113_ = self->priv->reset_twist;
	g_signal_connect_object (_tmp113_, "clicked", (GCallback) ___lambda12__gtk_button_clicked, self, 0);
	_tmp114_ = self->priv->twist_builder;
	_tmp115_ = gtk_builder_get_object (_tmp114_, "btnCalculate");
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, gtk_button_get_type ()) ? ((GtkButton*) _tmp115_) : NULL);
	_g_object_unref0 (self->priv->solve_twist);
	self->priv->solve_twist = _tmp116_;
	_tmp117_ = self->priv->solve_twist;
	g_signal_connect_object (_tmp117_, "clicked", (GCallback) ___lambda13__gtk_button_clicked, self, 0);
	_tmp118_ = self->priv->twist_builder;
	_tmp119_ = gtk_builder_get_object (_tmp118_, "radMiller");
	_tmp120_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp119_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp119_) : NULL);
	_g_object_unref0 (self->priv->rad_miller);
	self->priv->rad_miller = _tmp120_;
	_tmp121_ = self->priv->twist_builder;
	_tmp122_ = gtk_builder_get_object (_tmp121_, "radGreenhill");
	_tmp123_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp122_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp122_) : NULL);
	_g_object_unref0 (self->priv->rad_greenhill);
	self->priv->rad_greenhill = _tmp123_;
	_tmp124_ = self->priv->rad_miller;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) ___lambda14__gtk_toggle_button_toggled, self, 0);
	_tmp125_ = self->priv->rad_greenhill;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) ___lambda15__gtk_toggle_button_toggled, self, 0);
	_tmp126_ = self->priv->rad_miller;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	_tmp127_ = self->priv->stability_builder;
	_tmp128_ = gtk_builder_get_object (_tmp127_, "txtMDiameter");
	_tmp129_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp128_) : NULL);
	_g_object_unref0 (self->priv->miller_sta_diameter);
	self->priv->miller_sta_diameter = _tmp129_;
	_tmp130_ = self->priv->stability_builder;
	_tmp131_ = gtk_builder_get_object (_tmp130_, "txtMLength");
	_tmp132_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp131_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp131_) : NULL);
	_g_object_unref0 (self->priv->miller_sta_length);
	self->priv->miller_sta_length = _tmp132_;
	_tmp133_ = self->priv->stability_builder;
	_tmp134_ = gtk_builder_get_object (_tmp133_, "txtMass");
	_tmp135_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp134_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp134_) : NULL);
	_g_object_unref0 (self->priv->miller_sta_mass);
	self->priv->miller_sta_mass = _tmp135_;
	_tmp136_ = self->priv->stability_builder;
	_tmp137_ = gtk_builder_get_object (_tmp136_, "txtSafeValue");
	_tmp138_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp137_) : NULL);
	_g_object_unref0 (self->priv->miller_sta_safe_value);
	self->priv->miller_sta_safe_value = _tmp138_;
	_tmp139_ = self->priv->stability_builder;
	_tmp140_ = gtk_builder_get_object (_tmp139_, "txtResult");
	_tmp141_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp140_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp140_) : NULL);
	_g_object_unref0 (self->priv->stability_results);
	self->priv->stability_results = _tmp141_;
	_tmp142_ = self->priv->stability_builder;
	_tmp143_ = gtk_builder_get_object (_tmp142_, "btnReset");
	_tmp144_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp143_, gtk_button_get_type ()) ? ((GtkButton*) _tmp143_) : NULL);
	_g_object_unref0 (self->priv->reset_stability);
	self->priv->reset_stability = _tmp144_;
	_tmp145_ = self->priv->reset_stability;
	g_signal_connect_object (_tmp145_, "clicked", (GCallback) ___lambda16__gtk_button_clicked, self, 0);
	_tmp146_ = self->priv->stability_builder;
	_tmp147_ = gtk_builder_get_object (_tmp146_, "btnCalculate");
	_tmp148_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, gtk_button_get_type ()) ? ((GtkButton*) _tmp147_) : NULL);
	_g_object_unref0 (self->priv->solve_stability);
	self->priv->solve_stability = _tmp148_;
	_tmp149_ = self->priv->solve_stability;
	g_signal_connect_object (_tmp149_, "clicked", (GCallback) ___lambda17__gtk_button_clicked, self, 0);
}


/**
   * Reset the front end to prepare for a new drag calculation
   */
void balistica_application_btnResetDrag_clicked (BalisticaApplication* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkCheckButton* _tmp9_;
	GtkTextView* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkRadioButton* _tmp13_;
	GtkRadioButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = self->priv->calc_name;
	gtk_entry_set_text (_tmp0_, "");
	_tmp1_ = self->priv->drag_coefficient;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->projectile_weight;
	gtk_entry_set_text (_tmp2_, "");
	_tmp3_ = self->priv->initial_velocity;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->zero_range;
	gtk_entry_set_text (_tmp4_, "");
	_tmp5_ = self->priv->sight_height;
	gtk_entry_set_text (_tmp5_, "");
	_tmp6_ = self->priv->shooting_angle;
	gtk_entry_set_text (_tmp6_, "");
	_tmp7_ = self->priv->wind_velocity;
	gtk_entry_set_text (_tmp7_, "");
	_tmp8_ = self->priv->wind_angle;
	gtk_entry_set_text (_tmp8_, "");
	balistica_application_setDefaultAtmosphere (self);
	_tmp9_ = self->priv->enable_atmosphere;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_toggle_button_get_type (), GtkToggleButton), FALSE);
	_tmp10_ = self->priv->drag_results;
	_tmp11_ = gtk_text_view_get_buffer (_tmp10_);
	_tmp12_ = _tmp11_;
	g_object_set (_tmp12_, "text", "", NULL);
	_tmp13_ = self->priv->rad_g1;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	_tmp14_ = self->priv->rad_s10;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	_tmp15_ = self->priv->export_results;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp16_ = self->priv->calc_pbr;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE);
}


/**
   * Set atmosphere settings back to the default
   */
static void balistica_application_setDefaultAtmosphere (BalisticaApplication* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = self->priv->altitude;
	gtk_entry_set_text (_tmp0_, "0");
	_tmp1_ = self->priv->temp;
	gtk_entry_set_text (_tmp1_, "59.0");
	_tmp2_ = self->priv->bar_press;
	gtk_entry_set_text (_tmp2_, "29.53");
	_tmp3_ = self->priv->rela_humid;
	gtk_entry_set_text (_tmp3_, "78.0");
}


/**
   * Setup an example calculation
   */
static void balistica_application_setExampleCalculation (BalisticaApplication* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = self->priv->calc_name;
	gtk_entry_set_text (_tmp0_, "308 Win Match, 168gr Sierra Match King");
	_tmp1_ = self->priv->drag_coefficient;
	gtk_entry_set_text (_tmp1_, "0.465");
	_tmp2_ = self->priv->projectile_weight;
	gtk_entry_set_text (_tmp2_, "168");
	_tmp3_ = self->priv->initial_velocity;
	gtk_entry_set_text (_tmp3_, "2650");
	_tmp4_ = self->priv->zero_range;
	gtk_entry_set_text (_tmp4_, "200");
	_tmp5_ = self->priv->sight_height;
	gtk_entry_set_text (_tmp5_, "1.6");
	_tmp6_ = self->priv->shooting_angle;
	gtk_entry_set_text (_tmp6_, "0");
	_tmp7_ = self->priv->wind_velocity;
	gtk_entry_set_text (_tmp7_, "0");
	_tmp8_ = self->priv->wind_angle;
	gtk_entry_set_text (_tmp8_, "0");
}


/**
   * Solve the drag function
   */
static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_;
	gdouble _tmp1_;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


void balistica_application_btnSolveDrag_clicked (BalisticaApplication* self) {
	gchar* name = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gdouble bc = 0.0;
	GtkEntry* _tmp3_;
	const gchar* _tmp4_;
	gdouble _tmp5_;
	gdouble v = 0.0;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	gdouble _tmp8_;
	gdouble sh = 0.0;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_;
	gdouble _tmp11_;
	gdouble w = 0.0;
	GtkEntry* _tmp12_;
	const gchar* _tmp13_;
	gdouble _tmp14_;
	gdouble angle = 0.0;
	GtkEntry* _tmp15_;
	const gchar* _tmp16_;
	gdouble _tmp17_;
	gdouble zero = 0.0;
	GtkEntry* _tmp18_;
	const gchar* _tmp19_;
	gdouble _tmp20_;
	gdouble windspeed = 0.0;
	GtkEntry* _tmp21_;
	const gchar* _tmp22_;
	gdouble _tmp23_;
	gdouble windangle = 0.0;
	GtkEntry* _tmp24_;
	const gchar* _tmp25_;
	gdouble _tmp26_;
	gdouble alt = 0.0;
	gdouble bar = 0.0;
	gdouble tp = 0.0;
	gdouble rh = 0.0;
	gint df = 0;
	GtkRadioButton* _tmp27_;
	gboolean _tmp28_;
	LibBalisticaSolution* _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	gdouble _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	gdouble _tmp49_;
	const gchar* _tmp50_;
	gint _tmp51_;
	LibBalisticaSolution* _tmp52_;
	LibBalisticaSolution* _tmp53_;
	gint _tmp54_;
	GtkTextView* _tmp58_;
	GtkTextBuffer* _tmp59_;
	GtkTextBuffer* _tmp60_;
	GtkTextView* _tmp61_;
	GtkTextBuffer* _tmp62_;
	GtkTextBuffer* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	LibBalisticaSolution* _tmp67_;
	gdouble _tmp68_;
	LibBalisticaSolution* _tmp69_;
	gdouble _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	GtkTextView* _tmp75_;
	GtkTextBuffer* _tmp76_;
	GtkTextBuffer* _tmp77_;
	GtkTextView* _tmp78_;
	GtkTextBuffer* _tmp79_;
	GtkTextBuffer* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	LibBalisticaSolution* _tmp84_;
	gdouble _tmp85_;
	LibBalisticaSolution* _tmp86_;
	gdouble _tmp87_;
	LibBalisticaSolution* _tmp88_;
	gdouble _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	GtkTextView* _tmp94_;
	GtkTextBuffer* _tmp95_;
	GtkTextBuffer* _tmp96_;
	GtkTextView* _tmp97_;
	GtkTextBuffer* _tmp98_;
	GtkTextBuffer* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	LibBalisticaSolution* _tmp103_;
	gdouble _tmp104_;
	LibBalisticaSolution* _tmp105_;
	gdouble _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	GtkTextView* _tmp111_;
	GtkTextBuffer* _tmp112_;
	GtkTextBuffer* _tmp113_;
	GtkTextView* _tmp114_;
	GtkTextBuffer* _tmp115_;
	GtkTextBuffer* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gdouble r = 0.0;
	gdouble d = 0.0;
	gdouble m = 0.0;
	gdouble wi = 0.0;
	gdouble wm = 0.0;
	gdouble t = 0.0;
	gdouble e = 0.0;
	gint max = 0;
	LibBalisticaSolution* _tmp122_;
	gint _tmp123_;
	gint _tmp124_;
	gint step = 0;
	GtkRadioButton* _tmp125_;
	gboolean _tmp126_;
	GtkButton* _tmp182_;
	GtkButton* _tmp183_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = self->priv->calc_name;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->drag_coefficient;
	_tmp4_ = gtk_entry_get_text (_tmp3_);
	_tmp5_ = double_parse (_tmp4_);
	bc = _tmp5_;
	_tmp6_ = self->priv->initial_velocity;
	_tmp7_ = gtk_entry_get_text (_tmp6_);
	_tmp8_ = double_parse (_tmp7_);
	v = _tmp8_;
	_tmp9_ = self->priv->sight_height;
	_tmp10_ = gtk_entry_get_text (_tmp9_);
	_tmp11_ = double_parse (_tmp10_);
	sh = _tmp11_;
	_tmp12_ = self->priv->projectile_weight;
	_tmp13_ = gtk_entry_get_text (_tmp12_);
	_tmp14_ = double_parse (_tmp13_);
	w = _tmp14_;
	_tmp15_ = self->priv->shooting_angle;
	_tmp16_ = gtk_entry_get_text (_tmp15_);
	_tmp17_ = double_parse (_tmp16_);
	angle = _tmp17_;
	_tmp18_ = self->priv->zero_range;
	_tmp19_ = gtk_entry_get_text (_tmp18_);
	_tmp20_ = double_parse (_tmp19_);
	zero = _tmp20_;
	_tmp21_ = self->priv->wind_velocity;
	_tmp22_ = gtk_entry_get_text (_tmp21_);
	_tmp23_ = double_parse (_tmp22_);
	windspeed = _tmp23_;
	_tmp24_ = self->priv->wind_angle;
	_tmp25_ = gtk_entry_get_text (_tmp24_);
	_tmp26_ = double_parse (_tmp25_);
	windangle = _tmp26_;
	alt = 0.0;
	bar = 29.53;
	tp = 59.0;
	rh = 78.0;
	_tmp27_ = self->priv->rad_g1;
	_tmp28_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_toggle_button_get_type (), GtkToggleButton));
	if (_tmp28_) {
		df = 1;
	} else {
		GtkRadioButton* _tmp29_;
		gboolean _tmp30_;
		_tmp29_ = self->priv->rad_g2;
		_tmp30_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_toggle_button_get_type (), GtkToggleButton));
		if (_tmp30_) {
			df = 2;
		} else {
			GtkRadioButton* _tmp31_;
			gboolean _tmp32_;
			_tmp31_ = self->priv->rad_g5;
			_tmp32_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_toggle_button_get_type (), GtkToggleButton));
			if (_tmp32_) {
				df = 5;
			} else {
				GtkRadioButton* _tmp33_;
				gboolean _tmp34_;
				_tmp33_ = self->priv->rad_g6;
				_tmp34_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_toggle_button_get_type (), GtkToggleButton));
				if (_tmp34_) {
					df = 6;
				} else {
					GtkRadioButton* _tmp35_;
					gboolean _tmp36_;
					_tmp35_ = self->priv->rad_g7;
					_tmp36_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_toggle_button_get_type (), GtkToggleButton));
					if (_tmp36_) {
						df = 7;
					} else {
						df = 8;
					}
				}
			}
		}
	}
	_tmp37_ = lib_balistica_solution_new ();
	_g_object_unref0 (self->priv->lsln);
	self->priv->lsln = _tmp37_;
	_tmp38_ = bc;
	_tmp39_ = v;
	_tmp40_ = sh;
	_tmp41_ = w;
	_tmp42_ = angle;
	_tmp43_ = zero;
	_tmp44_ = windspeed;
	_tmp45_ = windangle;
	_tmp46_ = alt;
	_tmp47_ = bar;
	_tmp48_ = tp;
	_tmp49_ = rh;
	_tmp50_ = name;
	_tmp51_ = df;
	_tmp52_ = balistica_calculate_drag (_tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_, _tmp48_, _tmp49_, _tmp50_, _tmp51_);
	_g_object_unref0 (self->priv->lsln);
	self->priv->lsln = _tmp52_;
	_tmp53_ = self->priv->lsln;
	_tmp54_ = lib_balistica_solution_getSolutionSize (_tmp53_);
	if (_tmp54_ == -1) {
		balistica_application_display_error (self, "ERROR creating solution results", NULL);
		_g_free0 (name);
		return;
	} else {
		GtkTextView* _tmp55_;
		GtkTextBuffer* _tmp56_;
		GtkTextBuffer* _tmp57_;
		_tmp55_ = self->priv->drag_results;
		_tmp56_ = gtk_text_view_get_buffer (_tmp55_);
		_tmp57_ = _tmp56_;
		g_object_set (_tmp57_, "text", "", NULL);
	}
	_tmp58_ = self->priv->drag_results;
	_tmp59_ = gtk_text_view_get_buffer (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = self->priv->drag_results;
	_tmp62_ = gtk_text_view_get_buffer (_tmp61_);
	_tmp63_ = _tmp62_;
	g_object_get (_tmp63_, "text", &_tmp64_, NULL);
	_tmp65_ = _tmp64_;
	_tmp66_ = _tmp65_;
	_tmp67_ = self->priv->lsln;
	_tmp68_ = lib_balistica_solution_getBc (_tmp67_);
	_tmp69_ = self->priv->lsln;
	_tmp70_ = lib_balistica_solution_getWeight (_tmp69_);
	_tmp71_ = g_strdup_printf ("Drag Coefficient: %.3f  Projectile Weight: %.2f grains\n", _tmp68_, _tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = g_strconcat (_tmp66_, _tmp72_, NULL);
	_tmp74_ = _tmp73_;
	g_object_set (_tmp63_, "text", _tmp74_, NULL);
	_g_free0 (_tmp74_);
	_g_free0 (_tmp72_);
	_g_free0 (_tmp66_);
	_tmp75_ = self->priv->drag_results;
	_tmp76_ = gtk_text_view_get_buffer (_tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = self->priv->drag_results;
	_tmp79_ = gtk_text_view_get_buffer (_tmp78_);
	_tmp80_ = _tmp79_;
	g_object_get (_tmp80_, "text", &_tmp81_, NULL);
	_tmp82_ = _tmp81_;
	_tmp83_ = _tmp82_;
	_tmp84_ = self->priv->lsln;
	_tmp85_ = lib_balistica_solution_getMv (_tmp84_);
	_tmp86_ = self->priv->lsln;
	_tmp87_ = lib_balistica_solution_getZerorange (_tmp86_);
	_tmp88_ = self->priv->lsln;
	_tmp89_ = lib_balistica_solution_getAngle (_tmp88_);
	_tmp90_ = g_strdup_printf ("Initial Velocity: %.2f ft/s  Zero Range: %.2f yards  Shooting Angle %." \
"2f degrees\n", _tmp85_, _tmp87_, _tmp89_);
	_tmp91_ = _tmp90_;
	_tmp92_ = g_strconcat (_tmp83_, _tmp91_, NULL);
	_tmp93_ = _tmp92_;
	g_object_set (_tmp80_, "text", _tmp93_, NULL);
	_g_free0 (_tmp93_);
	_g_free0 (_tmp91_);
	_g_free0 (_tmp83_);
	_tmp94_ = self->priv->drag_results;
	_tmp95_ = gtk_text_view_get_buffer (_tmp94_);
	_tmp96_ = _tmp95_;
	_tmp97_ = self->priv->drag_results;
	_tmp98_ = gtk_text_view_get_buffer (_tmp97_);
	_tmp99_ = _tmp98_;
	g_object_get (_tmp99_, "text", &_tmp100_, NULL);
	_tmp101_ = _tmp100_;
	_tmp102_ = _tmp101_;
	_tmp103_ = self->priv->lsln;
	_tmp104_ = lib_balistica_solution_getWindspeed (_tmp103_);
	_tmp105_ = self->priv->lsln;
	_tmp106_ = lib_balistica_solution_getWindangle (_tmp105_);
	_tmp107_ = g_strdup_printf ("Wind Velocity: %.2f mph  Wind Direction: %.2f degrees\n", _tmp104_, _tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = g_strconcat (_tmp102_, _tmp108_, NULL);
	_tmp110_ = _tmp109_;
	g_object_set (_tmp99_, "text", _tmp110_, NULL);
	_g_free0 (_tmp110_);
	_g_free0 (_tmp108_);
	_g_free0 (_tmp102_);
	_tmp111_ = self->priv->drag_results;
	_tmp112_ = gtk_text_view_get_buffer (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = self->priv->drag_results;
	_tmp115_ = gtk_text_view_get_buffer (_tmp114_);
	_tmp116_ = _tmp115_;
	g_object_get (_tmp116_, "text", &_tmp117_, NULL);
	_tmp118_ = _tmp117_;
	_tmp119_ = _tmp118_;
	_tmp120_ = g_strconcat (_tmp119_, "Range\tDropI\tDropM\tVelocity  Energy  Drift\tWindage\tTime\n", NULL);
	_tmp121_ = _tmp120_;
	g_object_set (_tmp116_, "text", _tmp121_, NULL);
	_g_free0 (_tmp121_);
	_g_free0 (_tmp119_);
	_tmp122_ = self->priv->lsln;
	_tmp123_ = lib_balistica_solution_getSolutionSize (_tmp122_);
	max = _tmp123_;
	_tmp124_ = max;
	if (_tmp124_ > 1000) {
		max = 1000;
	}
	step = 1;
	_tmp125_ = self->priv->rad_s10;
	_tmp126_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, gtk_toggle_button_get_type (), GtkToggleButton));
	if (_tmp126_) {
		step = 10;
	} else {
		GtkRadioButton* _tmp127_;
		gboolean _tmp128_;
		_tmp127_ = self->priv->rad_s50;
		_tmp128_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp127_, gtk_toggle_button_get_type (), GtkToggleButton));
		if (_tmp128_) {
			step = 50;
		} else {
			GtkRadioButton* _tmp129_;
			gboolean _tmp130_;
			_tmp129_ = self->priv->rad_s100;
			_tmp130_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, gtk_toggle_button_get_type (), GtkToggleButton));
			if (_tmp130_) {
				step = 100;
			}
		}
	}
	{
		gint n = 0;
		n = 0;
		{
			gboolean _tmp131_ = FALSE;
			_tmp131_ = TRUE;
			while (TRUE) {
				gint _tmp134_;
				gint _tmp135_;
				LibBalisticaSolution* _tmp136_;
				gint _tmp137_;
				gdouble _tmp138_;
				LibBalisticaSolution* _tmp139_;
				gint _tmp140_;
				gdouble _tmp141_;
				LibBalisticaSolution* _tmp142_;
				gint _tmp143_;
				gdouble _tmp144_;
				LibBalisticaSolution* _tmp145_;
				gint _tmp146_;
				gdouble _tmp147_;
				LibBalisticaSolution* _tmp148_;
				gint _tmp149_;
				gdouble _tmp150_;
				LibBalisticaSolution* _tmp151_;
				gint _tmp152_;
				gdouble _tmp153_;
				LibBalisticaSolution* _tmp154_;
				gint _tmp155_;
				gdouble _tmp156_;
				LibBalisticaSolution* _tmp157_;
				gdouble _tmp158_;
				gdouble _tmp159_;
				gdouble _tmp160_;
				GtkTextView* _tmp161_;
				GtkTextBuffer* _tmp162_;
				GtkTextBuffer* _tmp163_;
				GtkTextView* _tmp164_;
				GtkTextBuffer* _tmp165_;
				GtkTextBuffer* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				gdouble _tmp170_;
				gdouble _tmp171_;
				gdouble _tmp172_;
				gdouble _tmp173_;
				gdouble _tmp174_;
				gdouble _tmp175_;
				gdouble _tmp176_;
				gdouble _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				gchar* _tmp181_;
				if (!_tmp131_) {
					gint _tmp132_;
					gint _tmp133_;
					_tmp132_ = n;
					_tmp133_ = step;
					n = _tmp132_ + _tmp133_;
				}
				_tmp131_ = FALSE;
				_tmp134_ = n;
				_tmp135_ = max;
				if (!(_tmp134_ <= _tmp135_)) {
					break;
				}
				_tmp136_ = self->priv->lsln;
				_tmp137_ = n;
				_tmp138_ = lib_balistica_solution_getRange (_tmp136_, _tmp137_);
				r = _tmp138_;
				_tmp139_ = self->priv->lsln;
				_tmp140_ = n;
				_tmp141_ = lib_balistica_solution_getDrop (_tmp139_, _tmp140_);
				d = _tmp141_;
				_tmp142_ = self->priv->lsln;
				_tmp143_ = n;
				_tmp144_ = lib_balistica_solution_getMOA (_tmp142_, _tmp143_);
				m = _tmp144_;
				_tmp145_ = self->priv->lsln;
				_tmp146_ = n;
				_tmp147_ = lib_balistica_solution_getVelocity (_tmp145_, _tmp146_);
				v = _tmp147_;
				_tmp148_ = self->priv->lsln;
				_tmp149_ = n;
				_tmp150_ = lib_balistica_solution_getWindage (_tmp148_, _tmp149_);
				wi = _tmp150_;
				_tmp151_ = self->priv->lsln;
				_tmp152_ = n;
				_tmp153_ = lib_balistica_solution_getWindageMOA (_tmp151_, _tmp152_);
				wm = _tmp153_;
				_tmp154_ = self->priv->lsln;
				_tmp155_ = n;
				_tmp156_ = lib_balistica_solution_getTime (_tmp154_, _tmp155_);
				t = _tmp156_;
				_tmp157_ = self->priv->lsln;
				_tmp158_ = lib_balistica_solution_getWeight (_tmp157_);
				_tmp159_ = v;
				_tmp160_ = v;
				e = ((_tmp158_ * _tmp159_) * _tmp160_) / 450436;
				_tmp161_ = self->priv->drag_results;
				_tmp162_ = gtk_text_view_get_buffer (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = self->priv->drag_results;
				_tmp165_ = gtk_text_view_get_buffer (_tmp164_);
				_tmp166_ = _tmp165_;
				g_object_get (_tmp166_, "text", &_tmp167_, NULL);
				_tmp168_ = _tmp167_;
				_tmp169_ = _tmp168_;
				_tmp170_ = r;
				_tmp171_ = d;
				_tmp172_ = m;
				_tmp173_ = v;
				_tmp174_ = e;
				_tmp175_ = wi;
				_tmp176_ = wm;
				_tmp177_ = t;
				_tmp178_ = g_strdup_printf ("%.0f\t%.2f\t%.2f\t%.0f      %.0f    %.2f\t%.2f\t%.2f\n", _tmp170_, _tmp171_, _tmp172_, _tmp173_, _tmp174_, _tmp175_, _tmp176_, _tmp177_);
				_tmp179_ = _tmp178_;
				_tmp180_ = g_strconcat (_tmp169_, _tmp179_, NULL);
				_tmp181_ = _tmp180_;
				g_object_set (_tmp166_, "text", _tmp181_, NULL);
				_g_free0 (_tmp181_);
				_g_free0 (_tmp179_);
				_g_free0 (_tmp169_);
			}
		}
	}
	_tmp182_ = self->priv->export_results;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp182_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp183_ = self->priv->calc_pbr;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp183_, gtk_widget_get_type (), GtkWidget), TRUE);
	_g_free0 (name);
}


/**
   * Reset the front end to prepare for a new twist calculation
   */
void balistica_application_btnResetTwist_clicked (BalisticaApplication* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = self->priv->miller_diameter;
	gtk_entry_set_text (_tmp0_, "");
	_tmp1_ = self->priv->miller_length;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->miller_mass;
	gtk_entry_set_text (_tmp2_, "");
	_tmp3_ = self->priv->miller_safe_value;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->greenhill_diameter;
	gtk_entry_set_text (_tmp4_, "");
	_tmp5_ = self->priv->greenhill_length;
	gtk_entry_set_text (_tmp5_, "");
	_tmp6_ = self->priv->greenhill_spec_gravity;
	gtk_entry_set_text (_tmp6_, "");
	_tmp7_ = self->priv->greenhill_c;
	gtk_entry_set_text (_tmp7_, "");
	_tmp8_ = self->priv->twist_results;
	gtk_entry_set_text (_tmp8_, "");
}


/**
   * Solve the twist calculation for the selected formula
   */
static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}


void balistica_application_btnSolveTwist_clicked (BalisticaApplication* self) {
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = self->priv->rad_miller;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
	if (_tmp1_) {
		LibBalisticaMiller* m = NULL;
		LibBalisticaMiller* _tmp2_;
		LibBalisticaMiller* _tmp3_;
		GtkEntry* _tmp4_;
		const gchar* _tmp5_;
		gdouble _tmp6_;
		LibBalisticaMiller* _tmp7_;
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
		gdouble _tmp10_;
		LibBalisticaMiller* _tmp11_;
		GtkEntry* _tmp12_;
		const gchar* _tmp13_;
		gdouble _tmp14_;
		LibBalisticaMiller* _tmp15_;
		GtkEntry* _tmp16_;
		const gchar* _tmp17_;
		gint _tmp18_;
		GtkEntry* _tmp19_;
		LibBalisticaMiller* _tmp20_;
		gdouble _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp2_ = lib_balistica_miller_new ();
		m = _tmp2_;
		_tmp3_ = m;
		_tmp4_ = self->priv->miller_diameter;
		_tmp5_ = gtk_entry_get_text (_tmp4_);
		_tmp6_ = double_parse (_tmp5_);
		lib_balistica_miller_set_diameter (_tmp3_, _tmp6_);
		_tmp7_ = m;
		_tmp8_ = self->priv->miller_length;
		_tmp9_ = gtk_entry_get_text (_tmp8_);
		_tmp10_ = double_parse (_tmp9_);
		lib_balistica_miller_set_length (_tmp7_, _tmp10_);
		_tmp11_ = m;
		_tmp12_ = self->priv->miller_mass;
		_tmp13_ = gtk_entry_get_text (_tmp12_);
		_tmp14_ = double_parse (_tmp13_);
		lib_balistica_miller_set_mass (_tmp11_, _tmp14_);
		_tmp15_ = m;
		_tmp16_ = self->priv->miller_safe_value;
		_tmp17_ = gtk_entry_get_text (_tmp16_);
		_tmp18_ = atoi (_tmp17_);
		lib_balistica_miller_set_safe_value (_tmp15_, _tmp18_);
		_tmp19_ = self->priv->twist_results;
		_tmp20_ = m;
		_tmp21_ = lib_balistica_miller_calc_twist (_tmp20_);
		_tmp22_ = double_to_string (_tmp21_);
		_tmp23_ = _tmp22_;
		gtk_entry_set_text (_tmp19_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_object_unref0 (m);
	} else {
		LibBalisticaGreenhill* g = NULL;
		LibBalisticaGreenhill* _tmp24_;
		LibBalisticaGreenhill* _tmp25_;
		GtkEntry* _tmp26_;
		const gchar* _tmp27_;
		gdouble _tmp28_;
		LibBalisticaGreenhill* _tmp29_;
		GtkEntry* _tmp30_;
		const gchar* _tmp31_;
		gdouble _tmp32_;
		LibBalisticaGreenhill* _tmp33_;
		GtkEntry* _tmp34_;
		const gchar* _tmp35_;
		gdouble _tmp36_;
		LibBalisticaGreenhill* _tmp37_;
		GtkEntry* _tmp38_;
		const gchar* _tmp39_;
		gint _tmp40_;
		GtkEntry* _tmp41_;
		LibBalisticaGreenhill* _tmp42_;
		gdouble _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp24_ = lib_balistica_greenhill_new ();
		g = _tmp24_;
		_tmp25_ = g;
		_tmp26_ = self->priv->greenhill_diameter;
		_tmp27_ = gtk_entry_get_text (_tmp26_);
		_tmp28_ = double_parse (_tmp27_);
		lib_balistica_greenhill_set_diameter (_tmp25_, _tmp28_);
		_tmp29_ = g;
		_tmp30_ = self->priv->greenhill_length;
		_tmp31_ = gtk_entry_get_text (_tmp30_);
		_tmp32_ = double_parse (_tmp31_);
		lib_balistica_greenhill_set_length (_tmp29_, _tmp32_);
		_tmp33_ = g;
		_tmp34_ = self->priv->greenhill_spec_gravity;
		_tmp35_ = gtk_entry_get_text (_tmp34_);
		_tmp36_ = double_parse (_tmp35_);
		lib_balistica_greenhill_set_specific_gravity (_tmp33_, _tmp36_);
		_tmp37_ = g;
		_tmp38_ = self->priv->greenhill_c;
		_tmp39_ = gtk_entry_get_text (_tmp38_);
		_tmp40_ = atoi (_tmp39_);
		lib_balistica_greenhill_set_C (_tmp37_, _tmp40_);
		_tmp41_ = self->priv->twist_results;
		_tmp42_ = g;
		_tmp43_ = lib_balistica_greenhill_calc_twist (_tmp42_);
		_tmp44_ = double_to_string (_tmp43_);
		_tmp45_ = _tmp44_;
		gtk_entry_set_text (_tmp41_, _tmp45_);
		_g_free0 (_tmp45_);
		_g_object_unref0 (g);
	}
}


/**
   * Reset the front end to prepare for a new stability calculation
   */
void balistica_application_btnResetStability_clicked (BalisticaApplication* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = self->priv->miller_sta_diameter;
	gtk_entry_set_text (_tmp0_, "");
	_tmp1_ = self->priv->miller_sta_length;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->miller_sta_mass;
	gtk_entry_set_text (_tmp2_, "");
	_tmp3_ = self->priv->miller_sta_safe_value;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->stability_results;
	gtk_entry_set_text (_tmp4_, "");
}


/**
   * Solve the stability calculation
   */
void balistica_application_btnSolveStability_clicked (BalisticaApplication* self) {
	LibBalisticaMiller* m = NULL;
	LibBalisticaMiller* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gdouble _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	gdouble _tmp6_;
	GtkEntry* _tmp7_;
	const gchar* _tmp8_;
	gdouble _tmp9_;
	GtkEntry* _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	GtkEntry* _tmp13_;
	gdouble _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = lib_balistica_miller_new ();
	m = _tmp0_;
	_tmp1_ = self->priv->miller_sta_diameter;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = double_parse (_tmp2_);
	lib_balistica_miller_set_diameter (m, _tmp3_);
	_tmp4_ = self->priv->miller_sta_length;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = double_parse (_tmp5_);
	lib_balistica_miller_set_length (m, _tmp6_);
	_tmp7_ = self->priv->miller_sta_mass;
	_tmp8_ = gtk_entry_get_text (_tmp7_);
	_tmp9_ = double_parse (_tmp8_);
	lib_balistica_miller_set_mass (m, _tmp9_);
	_tmp10_ = self->priv->miller_sta_safe_value;
	_tmp11_ = gtk_entry_get_text (_tmp10_);
	_tmp12_ = atoi (_tmp11_);
	lib_balistica_miller_set_safe_value (m, _tmp12_);
	_tmp13_ = self->priv->stability_results;
	_tmp14_ = lib_balistica_miller_calc_stability (m);
	_tmp15_ = double_to_string (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_entry_set_text (_tmp13_, _tmp16_);
	_g_free0 (_tmp16_);
	_g_object_unref0 (m);
}


/**
   * Populate the drag field with the demostration values
   */
static void balistica_application_populate_demo_selected (BalisticaApplication* self) {
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	balistica_application_setExampleCalculation (self);
}


/**
   * Quit application
   */
static void balistica_application_quit_selected (BalisticaApplication* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	_tmp0_ = self->priv->main_window;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}


/**
   * Show help browser
   */
static void balistica_application_help_selected (BalisticaApplication* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_;
		guint32 _tmp2_;
		_tmp0_ = self->priv->main_window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "ghelp:balistica", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		balistica_application_display_error (self, "Error showing help", _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * Show about dialog
   */
static void balistica_application_about_selected (BalisticaApplication* self) {
	gchar* version = NULL;
	GtkWindow* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	if (g_strcmp0 (BALISTICA_VERSION_DESC, "Release") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (BALISTICA_VERSION_MAJOR "." BALISTICA_VERSION_MINOR);
		_g_free0 (version);
		version = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (BALISTICA_VERSION_MAJOR "." BALISTICA_VERSION_MINOR "-" BALISTICA_VERSION_COMMIT);
		_g_free0 (version);
		version = _tmp1_;
	}
	_tmp2_ = self->priv->main_window;
	_tmp3_ = version;
	gtk_show_about_dialog (_tmp2_, "authors", BALISTICA_AUTHORS, "comments", "An open source external ballistics calculator.", "copyright", "Copyright \xc2\xa9 2012-2017 Steven Oliver", "license-type", GTK_LICENSE_GPL_3_0, "program-name", BALISTICA_NAME, "website", "http://steveno.github.io/balistica/", "website-label", "balística Website", "version", _tmp3_, NULL);
	_g_free0 (version);
}


/**
   * Display an error dialog to the user
   */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BalisticaApplication* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda7_ (Block1Data* _data1_) {
	BalisticaApplication* self;
	GtkDialog* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->dialog;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}


static void ___lambda7__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda7_ (self);
}


static void balistica_application_display_error (BalisticaApplication* self, const gchar* error_msg, GError* err) {
	Block1Data* _data1_;
	GtkWindow* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	GError* _tmp3_;
	GtkDialog* _tmp20_;
	GtkDialog* _tmp21_;
	g_return_if_fail (BALISTICA_IS_APPLICATION (self));
	g_return_if_fail (error_msg != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = (GtkDialog*) gtk_dialog_new_with_buttons ("Error", _tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, "OK", GTK_RESPONSE_CLOSE, NULL, NULL);
	g_object_ref_sink (_tmp1_);
	_data1_->dialog = _tmp1_;
	_tmp2_ = _data1_->dialog;
	g_signal_connect_data (_tmp2_, "response", (GCallback) ___lambda7__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp3_ = err;
	if (_tmp3_ != NULL) {
		GtkDialog* _tmp4_;
		GtkBox* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GtkLabel* _tmp13_;
		GtkLabel* _tmp14_;
		_tmp4_ = _data1_->dialog;
		_tmp5_ = (GtkBox*) gtk_dialog_get_content_area (_tmp4_);
		_tmp6_ = error_msg;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strdup_printf (": %s", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
		g_object_ref_sink (_tmp13_);
		_tmp14_ = _tmp13_;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
	} else {
		GtkDialog* _tmp15_;
		GtkBox* _tmp16_;
		const gchar* _tmp17_;
		GtkLabel* _tmp18_;
		GtkLabel* _tmp19_;
		_tmp15_ = _data1_->dialog;
		_tmp16_ = (GtkBox*) gtk_dialog_get_content_area (_tmp15_);
		_tmp17_ = error_msg;
		_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
		g_object_ref_sink (_tmp18_);
		_tmp19_ = _tmp18_;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (_tmp19_);
	}
	_tmp20_ = _data1_->dialog;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
	_tmp21_ = _data1_->dialog;
	gtk_dialog_run (_tmp21_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void balistica_application_class_init (BalisticaApplicationClass * klass) {
	balistica_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BalisticaApplicationPrivate));
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) balistica_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) balistica_application_real_activate;
	G_OBJECT_CLASS (klass)->finalize = balistica_application_finalize;
}


static void balistica_application_instance_init (BalisticaApplication * self) {
	self->priv = BALISTICA_APPLICATION_GET_PRIVATE (self);
}


static void balistica_application_finalize (GObject * obj) {
	BalisticaApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BALISTICA_TYPE_APPLICATION, BalisticaApplication);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->main_window);
	_g_object_unref0 (self->priv->drag_builder);
	_g_object_unref0 (self->priv->twist_builder);
	_g_object_unref0 (self->priv->stability_builder);
	_g_object_unref0 (self->priv->calc_name);
	_g_object_unref0 (self->priv->drag_coefficient);
	_g_object_unref0 (self->priv->projectile_weight);
	_g_object_unref0 (self->priv->initial_velocity);
	_g_object_unref0 (self->priv->zero_range);
	_g_object_unref0 (self->priv->sight_height);
	_g_object_unref0 (self->priv->shooting_angle);
	_g_object_unref0 (self->priv->wind_velocity);
	_g_object_unref0 (self->priv->wind_angle);
	_g_object_unref0 (self->priv->altitude);
	_g_object_unref0 (self->priv->temp);
	_g_object_unref0 (self->priv->bar_press);
	_g_object_unref0 (self->priv->rela_humid);
	_g_object_unref0 (self->priv->enable_atmosphere);
	_g_object_unref0 (self->priv->drag_results);
	_g_object_unref0 (self->priv->lsln);
	_g_object_unref0 (self->priv->reset_drag);
	_g_object_unref0 (self->priv->solve_drag);
	_g_object_unref0 (self->priv->export_results);
	_g_object_unref0 (self->priv->calc_pbr);
	_g_object_unref0 (self->priv->rad_g1);
	_g_object_unref0 (self->priv->rad_g2);
	_g_object_unref0 (self->priv->rad_g5);
	_g_object_unref0 (self->priv->rad_g6);
	_g_object_unref0 (self->priv->rad_g7);
	_g_object_unref0 (self->priv->rad_g8);
	_g_object_unref0 (self->priv->rad_s10);
	_g_object_unref0 (self->priv->rad_s50);
	_g_object_unref0 (self->priv->rad_s100);
	_g_object_unref0 (self->priv->miller_diameter);
	_g_object_unref0 (self->priv->miller_length);
	_g_object_unref0 (self->priv->miller_mass);
	_g_object_unref0 (self->priv->miller_safe_value);
	_g_object_unref0 (self->priv->greenhill_diameter);
	_g_object_unref0 (self->priv->greenhill_length);
	_g_object_unref0 (self->priv->greenhill_spec_gravity);
	_g_object_unref0 (self->priv->greenhill_c);
	_g_object_unref0 (self->priv->twist_results);
	_g_object_unref0 (self->priv->reset_twist);
	_g_object_unref0 (self->priv->solve_twist);
	_g_object_unref0 (self->priv->rad_greenhill);
	_g_object_unref0 (self->priv->rad_miller);
	_g_object_unref0 (self->priv->miller_sta_diameter);
	_g_object_unref0 (self->priv->miller_sta_length);
	_g_object_unref0 (self->priv->miller_sta_mass);
	_g_object_unref0 (self->priv->miller_sta_safe_value);
	_g_object_unref0 (self->priv->stability_results);
	_g_object_unref0 (self->priv->reset_stability);
	_g_object_unref0 (self->priv->solve_stability);
	G_OBJECT_CLASS (balistica_application_parent_class)->finalize (obj);
}


GType balistica_application_get_type (void) {
	static volatile gsize balistica_application_type_id__volatile = 0;
	if (g_once_init_enter (&balistica_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BalisticaApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) balistica_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BalisticaApplication), 0, (GInstanceInitFunc) balistica_application_instance_init, NULL };
		GType balistica_application_type_id;
		balistica_application_type_id = g_type_register_static (gtk_application_get_type (), "BalisticaApplication", &g_define_type_info, 0);
		g_once_init_leave (&balistica_application_type_id__volatile, balistica_application_type_id);
	}
	return balistica_application_type_id__volatile;
}



