//
// BeagleWebSvc.cs
//
// Copyright (C) 2005 Novell, Inc.
//
// Authors:
//   Vijay K. Nanjundaswamy (knvijay@novell.com)
//

// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//

using System;
using System.Threading;
using System.Collections;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;

using Beagle;
using Beagle.Daemon;
using Beagle.websvc;

namespace BeagleWebSvc {

	[WebService(Description = "Web Service Interface to beagled",
	 Namespace = "http://www.gnome.org/projects/beagle/webservices",
	 Name = "beagledWebService")]
	public class beagledWebService: System.Web.Services.WebService {
	   
	//.Net Remoting channel to beagledBridge within beagled
	static bool registerChannelDone = false;

	[WebMethod(Description = "Full interface to beagled")]
	[System.Web.Services.Protocols.SoapDocumentMethodAttribute(
	"http://www.gnome.org/projects/beagle/webservices/beagledQuery",
	RequestNamespace="http://www.gnome.org/projects/beagle/webservices",
	ResponseNamespace="http://www.gnome.org/projects/beagle/webservices")]
	public searchResult[] beagledQuery(searchRequest req)
	{
		try {
			if (! registerChannelDone) {
		
			    ChannelServices.RegisterChannel(new HttpChannel());
			    WellKnownClientTypeEntry WKCTE = 
				new WellKnownClientTypeEntry(typeof(beagledBridge),
					"http://localhost:8347/beagledBridge.rem");
			    RemotingConfiguration.RegisterWellKnownClientType(WKCTE);
			    registerChannelDone = true;
			}

			beagledBridge remoteobj = new beagledBridge();
			searchResult[] sr = remoteobj.doQuery(req);
				
			return sr; 
		}
		catch (Exception e)
		{
				//FIXME:
				//Log an error
				//Return appropriate response: rethrow Exception ?
				throw e;
		}
	}

	[WebMethod(Description = "Simple Interface to beagled")]
	[System.Web.Services.Protocols.SoapDocumentMethodAttribute(
	"http://www.gnome.org/projects/beagle/webservices/simplebeagledQuery",
	RequestNamespace="http://www.gnome.org/projects/beagle/webservices",
	ResponseNamespace="http://www.gnome.org/projects/beagle/webservices")]
	public searchResult[] simplebeagledQuery(string text)
	{
		try {

			if (! registerChannelDone) {
			    ChannelServices.RegisterChannel(new HttpChannel());
			    WellKnownClientTypeEntry WKCTE = 
				new WellKnownClientTypeEntry(typeof(beagledBridge),
					"http://localhost:8347/beagledBridge.rem");
			    RemotingConfiguration.RegisterWellKnownClientType(WKCTE);
			    registerChannelDone = true;
			}

			beagledBridge remoteobj = new beagledBridge();
			searchResult[] sr = remoteobj.doQuery(text);
				
			return sr; 		
		}
		catch (Exception e)
		{
			//FIXME:
			//Log an error
			//Return appropriate response: rethrow Exception ?
			throw e;
		}
	}
   }
}
