//
// beagledBridge.cs
//
// Copyright (C) 2005 Novell, Inc.
//
// Authors:
//   Vijay K. Nanjundaswamy (knvijay@novell.com)
//

//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
using System;
using System.Collections;
using System.Threading;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;

using Beagle.Util;
using Beagle.Daemon;

namespace Beagle.websvc {
	
	[Serializable()]
	public struct searchRequest
	{
		public string[] text;
		public string[] mimeType;		 
		public string[] searchSources;
		public QueryDomain qdomain;
	}

	[Serializable()]
	public class HitProperty
	{
		private string pKey="";
		public string PKey 
		{
			get {return pKey;}
			set {pKey = value;}
		}

		private string pVal="";
		public string PVal
		{
			get {return pVal;}
			set {pVal = value;}
		}
	}

	[Serializable()]
	public struct searchResult
	{
		public int id;
		public string uri;
		public string resourceType;
		public string mimeType;
		public string source;
		public float score;
		public HitProperty[] properties;
		//FIXME: public xxx[] data;
	}
	
	public class beagledBridge: MarshalByRefObject{

		static beagledBridge instance = null;
		Hashtable res;
		Hashtable finished;

		public beagledBridge() {
			res = Hashtable.Synchronized(new Hashtable());
			finished = Hashtable.Synchronized(new Hashtable());
		}

		~beagledBridge() {
			res.Clear(); 
			finished.Clear();
		}		

		public static void initBridge() 
		{
		  instance = new beagledBridge();

		  ChannelServices.RegisterChannel(new HttpChannel(8347));
		  WellKnownServiceTypeEntry WKSTE = 
			new WellKnownServiceTypeEntry(typeof(beagledBridge),
				 "beagledBridge.rem", WellKnownObjectMode.Singleton);
		  RemotingConfiguration.ApplicationName="beagled";
		  RemotingConfiguration.RegisterWellKnownServiceType(WKSTE);
		}

		void OnHitsAdded (QueryResult qres, ICollection hits)
		{	
			if (res.Contains(qres)) {
				ArrayList results = (ArrayList) res[qres];
				results.AddRange(hits);
			}
		}

		void OnHitsSubtracted (QueryResult qres, ICollection uris)
		{

		}

		void OnFinished (QueryResult qres)
		{
			if (finished.Contains(qres)) {
				finished.Remove(qres);
			}			
		}

		void OnCancelled (QueryResult qres)
		{
			if (finished.Contains(qres)) {
				finished.Remove(qres);
			}			
		}

		void AttachQueryResult (QueryResult qres, ArrayList results)
		{
			if (qres != null) {
				qres.HitsAddedEvent += OnHitsAdded;
				qres.HitsSubtractedEvent += OnHitsSubtracted;
				qres.FinishedEvent += OnFinished;
				qres.CancelledEvent += OnCancelled;

				res.Add(qres, results);
				finished.Add(qres, qres);
			}
		}

		void DetachQueryResult (QueryResult qres)
		{
			if (qres != null) {
				res.Remove(qres);
				
				qres.HitsAddedEvent -= OnHitsAdded;
				qres.HitsSubtractedEvent -= OnHitsSubtracted;
				qres.FinishedEvent -= OnFinished;
				qres.CancelledEvent -= OnCancelled;
				qres.Dispose ();
			}
		}

		public searchResult[] doQuery(string searchString)
		{
			QueryBody query = new QueryBody();
			query.AddText (searchString);
			query.AddDomain (QueryDomain.Neighborhood);
			
			return execQuery(query);
		}

		public searchResult[] doQuery(searchRequest req)
		{
			QueryBody query = new QueryBody();

			foreach (string text in req.text)
				query.AddText(text);

			foreach (string mtype in req.mimeType)
				query.AddMimeType(mtype);

			foreach (string src in req.searchSources)
				query.AddSource(src);	

			query.AddDomain(req.qdomain);		
						
			return execQuery(query);
		}

		searchResult[] execQuery(QueryBody query)
		{
			ArrayList results = new ArrayList();

			QueryResult qres = new QueryResult ();


			
			Console.WriteLine("beagledBridge: Starting Query for string \"{0}\"",
						query.QuotedText);

			AttachQueryResult (qres, results);
		
			QueryDriver.DoQuery (query, qres);

			while (finished.Contains(qres))
				Thread.Sleep(100);

			Console.WriteLine("beagledBridge: Got {0} results from beagled", results.Count);

			searchResult[] sr;

			if (results.Count < 20)
				sr = new searchResult[results.Count];
			else
				sr = new searchResult[20];

			int i = -1;
			foreach (Hit h in results) {

				if (++i >= 20)  
				//FIXME:Limiting no. of results to first 20 for now!
					break;
							
				sr[i] = new searchResult();
				sr[i].id = h.Id;
				sr[i].uri = h.Uri.ToString(); 				
	                        sr[i].resourceType = h.Type;		
				sr[i].mimeType = h.MimeType;
				sr[i].source = h.Source;
				sr[i].score = h.Score;

				Hashtable sp = (Hashtable) h.Properties;
				sr[i].properties = new HitProperty[sp.Count];

				int j = -1;
				foreach (string key in sp.Keys) {
					sr[i].properties[++j] = new HitProperty();
					sr[i].properties[j].PKey = key;
					sr[i].properties[j].PVal = (string) sp[key];
				}
			}
			DetachQueryResult(qres);
			return sr;
		}
    }
}
