#include <iostream>
#include "MainWindow.h"

MainWindow::MainWindow() {
    application = Gtk::Application::create(__argc, __argv, "org.ukhf.test");
    builder = Gtk::Builder::create();

    // Load the GtkBuilder file and instantiate its widgets:
    try {
        builder->add_from_file("assets/test.glade");
    } catch (const Glib::FileError &ex) {
        std::cerr << "FileError: " << ex.what() << std::endl;
    } catch (const Glib::MarkupError &ex) {
        std::cerr << "MarkupError: " << ex.what() << std::endl;
    } catch (const Gtk::BuilderError &ex) {
        std::cerr << "BuilderError: " << ex.what() << std::endl;
    }

    // Load CSS
    auto cssProvider = Gtk::CssProvider::create();
    cssProvider->load_from_path("assets/test.css");

    auto styleContext = Gtk::StyleContext::create();

    // Get default screen
    auto screen = Gdk::Screen::get_default();

    // Add provider for screen in all application
    styleContext->add_provider_for_screen(screen, cssProvider, GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);

    builder->get_widget("MainWindow", _window);

    addButtons();
}

int MainWindow::show() {
    return application->run(*_window);
}

void MainWindow::addButtons() {
    std::vector<std::string> names = {"Alpha", "Bravo", "Charlie", "Delta", "Echo", "Foxtrot", "Golf", "Hotel", "Indigo", "Juliet", "Kilo", "Lima", "Mike"};

    Gtk::FlowBox *locationsWidget = nullptr;
    builder->get_widget("flowbox", locationsWidget);

    if (locationsWidget != nullptr) {
        auto tempGroup = Gtk::RadioButtonGroup();
        for(auto &a: names) {
            auto temp = new Gtk::RadioButton(tempGroup, a);
            locationsWidget->add(*temp);
        }
        locationsWidget->show_all_children();
    }
}
