library ieee ;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;



entity counter is
  generic(
    n: natural :=2   --! number of bits of counter
  );
  port(
    clk   : in std_logic;    --! clock
    clear : in std_logic;    --! clear counter
    count : in std_logic;    --! count down
    Q     : out std_logic_vector(n-1 downto 0)  --! counter value
  );
end counter;



architecture behv of counter is

    --! @register_definition{Counter register,Down counter with n bits}
    signal count_reg: std_logic_vector(n-1 downto 0);

begin

    --! @brief Counter logic
    process(clock, count, clear)
    begin
	   if clear = '1' then
 	       count_reg <= (others => '1');
	   elsif (clock='1' and clock'event) then
	       if count = '1' then
	   	count_reg <= count_reg - 1;
	       end if;
	   end if;
    end process;


    Q <= count_reg;

end behv;
