// msvctest.cpp : Definiert den Einstiegspunkt fr die Konsolenanwendung.
//

//#include "stdafx.h"

#include <iostream>

class Object
{
public:
  Object() : i(2)
  {}

  virtual ~Object()
  {}

  int i;
};

// don't use virtual inheritance and it works
class Base : virtual public Object {
public:
  Base() : Object()
  {
    do_dynamic_cast();
  }

  void do_dynamic_cast()
  {
	//Cast it up to the Object and then back down to the Base:
	//The result should be the same as the starting this.
    Object* objectbase_ = static_cast<Object*>(this);
    Base *obj = dynamic_cast<Base*>(objectbase_);

	std::cout << "  this = " << this << ", dynamic_casted this = " << obj << std::endl;

	if(this != obj)
		std::cout << "  dynamic_cast<> seems to have failed." << std::endl;
  }
};


class Derived : public Base
{
public:
  Derived()
  : Base(),
  x(3)
  {}

protected:
  // Comment this and it works again !
  int x;
}; 

int main(int argc, char	**argv)
{
  using namespace std;

  // First with a Base object
  cout << "1. Testing a Base object" << endl; 
  cout << "Inside constructor:" << endl;
  Base b;
  cout << "Outside constructor:" << endl; 
  b.do_dynamic_cast();
  
  // Then with a Derived object
  cout << "2. Testing a Derived object" << endl; 
  cout << "Inside constructor:" << endl; 
  Derived w;
  cout << "Outside constructor:" << endl; 
  w.do_dynamic_cast();
  
  return 0;
}
