/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageStateBorder
extends AbstractEntityImage {
    public static final double RADIUS = 6.0;
    private final TextBlock desc;
    private final Cluster stateParent;
    private final EntityPosition entityPosition;
    private final Bibliotekon bibliotekon;

    public EntityImageStateBorder(ILeaf leaf, ISkinParam skinParam, Cluster stateParent, Bibliotekon bibliotekon) {
        super(leaf, skinParam);
        this.bibliotekon = bibliotekon;
        this.entityPosition = leaf.getEntityPosition();
        if (this.entityPosition == EntityPosition.NORMAL) {
            throw new IllegalArgumentException();
        }
        this.stateParent = stateParent;
        Stereotype stereotype = leaf.getStereotype();
        this.desc = leaf.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.STATE, stereotype), HorizontalAlignment.CENTER, skinParam);
    }

    private boolean upPosition() {
        Point2D clusterCenter = this.stateParent.getClusterPosition().getPointCenter();
        Shape sh = this.bibliotekon.getShape(this.getEntity());
        return sh.getMinY() < clusterCenter.getY();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(12.0, 12.0);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        return dimDesc.getWidth();
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(12.0, 12.0);
        double y = 0.0;
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x = 0.0 - (dimDesc.getWidth() - 12.0) / 2.0;
        y = this.upPosition() ? (y -= 12.0 + dimDesc.getHeight()) : (y += 12.0);
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
        ug = ug.apply(new UStroke(1.5)).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBorder, this.getStereo())));
        HtmlColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBackground, this.getStereo());
        }
        ug = ug.apply(new UChangeBackColor(backcolor));
        ug.draw(circle);
        if (this.entityPosition == EntityPosition.EXIT_POINT) {
            double xc = 6.5;
            double yc = 6.5;
            double radius = 5.5;
            EntityImageStateBorder.drawLine(ug, this.getPointOnCircle(6.5, 6.5, 0.7853981633974483, 5.5), this.getPointOnCircle(6.5, 6.5, 3.9269908169872414, 5.5));
            EntityImageStateBorder.drawLine(ug, this.getPointOnCircle(6.5, 6.5, -0.7853981633974483, 5.5), this.getPointOnCircle(6.5, 6.5, 2.356194490192345, 5.5));
        }
    }

    private Point2D getPointOnCircle(double xc, double yc, double angle, double radius) {
        double x = xc + radius * Math.cos(angle);
        double y = yc + radius * Math.sin(angle);
        return new Point2D.Double(x, y);
    }

    private static void drawLine(UGraphic ug, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(p1.getX(), p1.getY())).draw(new ULine(dx, dy));
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

